#include "common/plug.h"
#include "common/packet.h"
#include "common/utils.h"
#include <common/act_type.h>
#include <common/lattice.h>
#include <common/actors/simple_room.h>
//#include <stdio.h>
#include <signal.h>
#include <allegro.h>


void add_object(Lattice *l, Electron *Object, int x, int y)
{
    Atom *a = l->get(x, y);

    if (!a)
    {
        a = new Atom();
        l->set(a, x, y);
    }

    a->add(Object);

}

Electron * get_electron_from_type(int type, int id)
{
    Electron *e = NULL;

    switch(type)
    {
        case ACTOR_SIMPLE_ROOM:
         e =  new Simple_room(id);
         break;
        case ACTOR_PLAYER:
         fatal("actor type player not yet implemented");
         break;
        default:
         fatal("Illegal or unknown actor type %d", type);
         break;
    }
    return e;
}

void draw_map(Lattice *l, int fromx, int fromy, int tox, int toy)
{
    for (int i = fromx;i < tox; i++)
    {
        for (int j = fromy;j < toy; j++)
        {
            if (l->get(i, j))
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10,  makecol(255, 0, 0));
            }
            else
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10, makecol(0, 255, 0));
            }
        }
    }
}


int main(int argc, char **argv)
{


    allegro_init();
    install_timer();
    install_keyboard();
    progname = argv[0];
    signal(SIGPIPE, SIG_IGN);

    if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
        fatal("error setting gfx mode: %s", allegro_error);
    
    set_palette(desktop_palette);
    clear(screen);

    Plug *connection = new Plug();
    Lattice *lattice;
    Electron *e;
    
    Packet const *p;
    Packet_command *cp;

    /* conenct to the server */
    if (connection->open())
        fatal("unable to connect to server");

    /* wait until we get the initial packets with the map size */
    warning("waiting for map size from server....");
    while (1)
    {
        p = read_packet_static(connection);

        if (p)
           print_packet(p);

        if (
            p &&
            (p->get_type() == TYPE_INFO_VECT) &&
            (((Packet_info_vect *)p)->actor_id == ACTOR_SYSTEM) &&
            (((Packet_info_vect *)p)->var_id == 0)
           )
        {
            lattice = new Lattice(((Packet_info_vect *)p)->var_x,((Packet_info_vect *)p)->var_y);
            break;
        }
    }
    warning("Ok created %d x %d sized map", lattice->get_w(), lattice->get_h());


    while(!key[KEY_ESC])
    {
        p = read_packet_static(connection);


        
        if (p)
        {
//            print_packet(p);
            if (p->get_type() == TYPE_COMMAND)
            {
                cp = (Packet_command *)p;
                if (cp->command == COMMAND_FROM_TO)
                {
                    if ((cp->arg1 == -1) && (cp->arg2 == -1))
                    {
                        e = get_electron_from_type(cp->actor_type, cp->actor_id);
                        add_object(lattice, e, cp->arg3, cp->arg4);
                        draw_map(lattice, cp->arg3, cp->arg4,cp->arg3 + 1, cp->arg4 + 1);
                    }
                }
                
            }
        }

        if (key[KEY_M])
        {
            while(key[KEY_M]);
            draw_map(lattice, 0, 0, lattice->get_w(), lattice->get_h());
        }
        if (key[KEY_S])
        {
            Packet_info_string::write_to(connection, ACTOR_SYSTEM, 0, 0, "shutdown");
            connection->close();
            delete connection;
            connection = NULL;
            break;
        }
    }


    if (connection)
    {
       Packet_info_string::write_to(connection, ACTOR_SYSTEM, 0, 0, "quit");
       connection->close();
       delete connection;

    }

    delete lattice;
    
    return 0;
}

END_OF_MAIN();