#include "common/plug.h"
#include "common/packet.h"
#include "common/utils.h"
#include "common/act_type.h"
#include "common/actors/system.h"
#include "common/lattice.h"
#include "common/actors/simple_room.h"
#include "common/version.h"
//#include <stdio.h>
#include "signal.h"
#include "allegro.h"


Packet const *wait_packet(Plug *connection)
{
    Packet const *p;
    while(!(p = read_packet_static(connection)));
    if (p->err)
       fatal("Error in packet: %s", p->error);

    return p;
}

Plug * setup_connection(char *adress, int port)
{
    Plug *c;
    Packet const *p;

    c = new Plug(adress,port);

    if (c->open())
       fatal("connection open() failed");

    /* wait for lifesigns of server */
    warning("wait for first packet");
    p = wait_packet(c);
    
    warning("got packet");

    if (!Packet_info_num::expect(p, ACTOR_SYSTEM))
       fatal("got wrong type of first packet from server");

    if (Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_MESSAGE, System::STC_I_AM_FULL_GET_LOST))
    {
        fatal("Server is full");
    }
    else if (!Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_VAR, System::VERSION_INT, COMM_VERSION_INT))
    {
        Packet_info_num::write_to(c, ACTOR_SYSTEM, 1, System::WRONG_VERSION_NUMBER, 0);
        fatal("Error reading the communication version number");
    }

    warning("version number OK");
    
    
    /* send my version nr to server */
    Packet_info_num::write_to(c, ACTOR_SYSTEM, SYS_VAR, System::VERSION_INT, COMM_VERSION_INT);

    warning("wrote version number , wait for answer");
    /* wait for answer */
    p = wait_packet(c);

    warning("got packet");

    if (!(Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_VAR, System::NUM_PLAYERS)))
       fatal("error reading number of players from server");


    warning("number of players = %d", ((Packet_info_num *)p)->var_value);


    warning(" upto here it's ok");

    warning("press y or n");

    int key = readkey();

    if ((key >> 8) == KEY_Y)
    {
       Packet_info_num::write_to(c, ACTOR_SYSTEM, SYS_MESSAGE, System::CTS_INTERESTED_YN, SYS_YES);
    }
    else
    {
       Packet_info_num::write_to(c, ACTOR_SYSTEM, SYS_MESSAGE, System::CTS_INTERESTED_YN, SYS_NO);
       fatal("ok, exiting");
    }


    fatal("ok you're in");
    return c;
}




void add_object(Lattice *l, Electron *Object, int x, int y)
{
    Atom *a = l->get(x, y);

    if (!a)
    {
        a = new Atom();
        l->set(a, x, y);
    }

    a->add(Object);

}

Electron * get_electron_from_type(int type, int id)
{
    Electron *e = NULL;

    switch(type)
    {
        case ACTOR_SIMPLE_ROOM:
         e =  new Simple_room(id);
         break;
        case ACTOR_PLAYER:
         fatal("actor type player not yet implemented");
         break;
        default:
         fatal("Illegal or unknown actor type %d", type);
         break;
    }
    return e;
}

void draw_map(Lattice *l, int fromx, int fromy, int tox, int toy)
{
    for (int i = fromx;i < tox; i++)
    {
        for (int j = fromy;j < toy; j++)
        {
            if (l->get(i, j))
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10,  makecol(255, 0, 0));
            }
            else
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10, makecol(0, 255, 0));
            }
        }
    }
}


int main(int argc, char **argv)
{


    allegro_init();
    install_timer();
    install_keyboard();
    progname = argv[0];
    signal(SIGPIPE, SIG_IGN);


    Plug *connection = setup_connection("localhost", 5000);

    if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
        fatal("error setting gfx mode: %s", allegro_error);
    
    set_palette(desktop_palette);
    clear(screen);


    Lattice *lattice;
    Electron *e;
    
    Packet const *p;
    Packet_command *cp;

    /* conenct to the server */
    if (connection->open())
        fatal("unable to connect to server");

    /* wait until we get the initial packets with the map size */
    warning("waiting for map size from server....");
    while (1)
    {
        p = read_packet_static(connection);

        if (p)
           print_packet(p);

        if (
            p &&
            (p->get_type() == TYPE_INFO_VECT) &&
            (((Packet_info_vect *)p)->actor_id == ACTOR_SYSTEM) &&
            (((Packet_info_vect *)p)->var_id == 0)
           )
        {
            lattice = new Lattice(((Packet_info_vect *)p)->var_x,((Packet_info_vect *)p)->var_y);
            break;
        }
    }
    warning("Ok created %d x %d sized map", lattice->get_w(), lattice->get_h());


    while(!key[KEY_ESC])
    {
        p = read_packet_static(connection);


        
        if (p)
        {
//            print_packet(p);
            if (p->get_type() == TYPE_COMMAND)
            {
                cp = (Packet_command *)p;
                if (cp->command == COMMAND_FROM_TO)
                {
                    if ((cp->arg1 == -1) && (cp->arg2 == -1))
                    {
                        e = get_electron_from_type(cp->actor_type, cp->actor_id);
                        add_object(lattice, e, cp->arg3, cp->arg4);
                        draw_map(lattice, cp->arg3, cp->arg4,cp->arg3 + 1, cp->arg4 + 1);
                    }
                }
                
            }
        }

        if (key[KEY_M])
        {
            while(key[KEY_M]);
            draw_map(lattice, 0, 0, lattice->get_w(), lattice->get_h());
        }
        if (key[KEY_S])
        {
            Packet_info_string::write_to(connection, ACTOR_SYSTEM, 0, 0, "shutdown");
            connection->close();
            delete connection;
            connection = NULL;
            break;
        }
    }


    if (connection)
    {
       Packet_info_string::write_to(connection, ACTOR_SYSTEM, 0, 0, "quit");
       connection->close();
       delete connection;

    }

    delete lattice;
    
    return 0;
}

END_OF_MAIN();