/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <sys/signal.h>
#include <sys/time.h>
#include <unistd.h>   // pipe/fork etc
#include <sys/wait.h> // waitpid  to check if it's still running
#include <string.h>
#include "client.h"
#include "clutils.h"
#include "renderer/renderer.h"
#include "stser.h"


static int my_server = 0;
static int connected = 0;
static int server_pid = 0;

static int fdpopen(char *prog)
{
   int filedes[2];
   
   if (pipe(filedes))
   {
       warning("could not create pipe to subprocess");
       return -1;
   }


   if ((server_pid = vfork()))
   {
      if (server_pid <0)
      {
         warning("could not fork subprocess");
         close(filedes[0]);
         close(filedes[1]);
         return -1;
      }

      message("started server. pid=%d, output sent to stream %d",server_pid,C_STREAM_SERVER);
      return filedes[0];
   }

   /* child process */
   /* warning: used vfork, so here I cannot touch any global data or return
    * if exec fails I should exit here
    */

    // dup2(old, new) duplicates all file/status information associated with 'old'
    // to 'new', closing any file associated with 'new' first, so
    // after this 'new' points to the same file as 'old' did before.

    dup2(filedes[1], STDERR_FILENO); /* redirect stderr to my pipe */

    //solved:         for some reason this doen't work for stdout (while it *does* work with
    //                  a simple test program), maybe allegro does something with stdout?
    //    buffering problem. stdout is buffered a bit much
    
    dup2(filedes[1], STDOUT_FILENO); /* redirect stdout to my pipe */

    close(filedes[1]); // we're done with this file, now it's dup'd to stderr

    execlp("./st","st",NULL);  // does not return if it succeeds


    _exit(-1); // child exits, NOT the main program
    
}

void startserver(char *servername, int port)
{
   if (connected)
   {
       warning("Server already started");
       return;
   }
   if (strcmp(servername, "localhost"))
   {
      warning("can only start local server");
      return;
   }

   if (port != 5000)
   {
      warning("can only start server at port 5000 (for now)");
      return;
   }

   my_server = fdpopen("./st");

   if (my_server <0)
   {
      warning("could not start server");
      return;
   }

   connected = TRUE;

}


static int can_read(int fd, int usec)
{
    timeval tv; // timeout value
    fd_set what_set;   // the set of filedescripors to check for read/write
    int retval;
    
    tv.tv_sec = 0;     // fill the timeout struct
    tv.tv_usec = usec; // usec has to be < 1000000

    // fill the set
    FD_ZERO(&what_set);  
    FD_SET(fd, &what_set);

    while ((retval = select(fd+1, &what_set, NULL, NULL, &tv)) < 0)
    {
        if (errno == EINTR) // EINTR is not a real error
        {
            tv.tv_sec = 0;
            tv.tv_usec = usec;
            FD_ZERO(&what_set);
            FD_SET(fd, &what_set);
            
            continue;
        }
        
        // now we do have a real error
        return retval;
    }

    return retval;
}


int server_runs()
{

   return connected;
   
}


int ser_stdin_stdout()
{
  static char buf[2] = " ";
  int ret, status;
  if (!connected)
      return 0;

  ret = waitpid(server_pid, &status, WNOHANG);



  if (ret)
  {
      warning("the server has died....(aah)");
      close(my_server);
      connected = 0;
      return -1;
  }

  while (can_read(my_server, 0))
  {
     read(my_server,buf,1);
     print_to_stream(C_STREAM_SERVER, orange, buf);
  }
  return 0;
}

void stopserver()
{
   int ret, status;

   
   if (!connected)
      return;

   ret = waitpid(server_pid, &status, WNOHANG);
   
   if (!ret)
      kill(server_pid, SIGINT);

   connected = FALSE;
}
