#ifndef _SOUNDRENDERER_H_
#define _SOUNDRENDERER_H_

#include "client/client.h"

class Voice;

class Voicelist
{
   public:
    Voicelist();
    Voice *head;

    void add(Voice *v);
    void remove(Voice *v);
};

typedef struct Sample_map_info
{
  int samp; // one of the SAMP_ enums below
  char const *name;
  char const *fallback;   // if name cannot be found and fallback != NULL , that one will be used instead
} Sample_map_info;


typedef struct Sample_info
{
   SAMPLE *s;
   char const *name;
} Sample_info;


class Sound_renderer
{
   public:
     friend class Voice; // for get_sample
     Sound_renderer(char const *datafile_name);
     ~Sound_renderer();
     
     Voice *get_voice(Electron *for_who);
     Voice *get_voice(int x, int y);
     void free_voice(Voice *v);

     typedef enum
     {
         SAMP_SIREN = 0,
         SAMP_FOOTSTEP,
         SAMP_BELL,
         SAMP_ENGINE,
         SAMP_LAST
     } SAMPLES;

     
     void one_shot_effect(int priority,int x, int y, SAMPLES s);
     void one_shot_effect(int priority, Electron *from_who, SAMPLES s);
     
     void render_sounds(int ear_x, int ear_y, int ear_height);



   private:


     SAMPLE *get_sample(SAMPLES s);
     int voice_available(int overall_priority); // overall_priority is returend by Voice::calc_priority, calculated from the real priority and the distance

     void take_phys_voice(Voice *v);
     void give_phys_voice(Voice *v);

     // these two functions are called by Voice whenever it is stopped/started
     // to let the renderer dump them in the correct list
     void notify_stop(Voice *who);
     void notify_start(Voice *who);

     
     int max_physical_voices;
     int num_physical_voices;

     int do_sound;
     
     List voices;       // all the logical voices

     List one_shots;    // voices in use for a one shot effect

     Voicelist has_physical;
     Voicelist no_physical;
     Voicelist stopped;


     DATAFILE *samples_datafile;

     Sample_info samples[SAMP_LAST];

     static Sample_map_info sample_map[SAMP_LAST]; // unsorted list of sample/name mappings from samplemap.inc

     
};


class Voice
  : public Object
{
   public:
      Voice();
      ~Voice();

      void set(int xcenter, int ycenter);
      void set(Electron *owner);
      void clear();
      
      void set_sample(Sound_renderer::SAMPLES sampindex);
      void set_volume(int volume, int delta = 0);

      void set_speed(double relative_speed, int delta = 0);
      void set_priority(int priority);
      void start();
      void start_once();
      int has_finished();
      void stop(int in_time); // stops after in_time loops, unless a start has arrived in the mean time
      void stop();

      void update_logic(int ear_x,int ear_y, int ear_z); // ajust running voices for position etc
      void set_postion(int _x,int _y);


      int calc_priority(); // calculates priority from the priority and distance

      void give_phys_voice(); // for the Sound_renderer to give it a physiscal voice
      void take_phys_voice();
      int needs_phys_voice();
      int has_phys_voice();



      SAMPLE *sample;

      Voice *next;
      Voice *prev;
      int compensated_priority; // filled by update_logic
      int is_running;

   private:
      Electron *owner;
      int ear_x, ear_y, ear_z;
      int x, y; // iff owner == NULL these are used instead
      int base_frequency;
      int frequency;
      int volume;
      int priority;

      unsigned int volume_sweep_start, volume_sweep_starttime, volume_sweep_deltatime;
      unsigned int frequency_sweep_start, frequency_sweep_starttime, frequency_sweep_deltatime;
      int frequency_sweep_delta , volume_sweep_delta;

      
      int allegro_voice; // -1 when it has't got one

      int dist();

      void do_pan_volume_frequency(); // calls the allegro voice functions and sets volumes&pan adjusted for the location of the object

      int stop_time;
      int last_freq;

};


extern Sound_renderer *srenderer;


#endif //_SOUNDRENDERER_H_
