#include "client.h"
#include "select.h"




Selection::Selection()
{
   selection = new List;
}



Selection::~Selection()
{
   clear();
   delete selection;
}

void Selection::replace(Electron *e)
{
    clear();
    add(e);
}

void Selection::add(Electron *e)
{
    Display_data *d = (Display_data *)e->extra_data;
    selection->push(e);

    d->selected++;
}

void Selection::del(Electron *e)
{
    Display_data *d = (Display_data *)e->extra_data;
    selection->pop(e);

    d->selected--;

    ASSERT(d->selected >= 0);
}

void Selection::toggle(Electron *e)
{
    if (contains(e))
       del(e);
    else
       add(e);
}


void Selection::clear()
{
   Electron *e;
    Display_data *d;

   selection->reset();
   
   while ((e = (Electron *)(selection->pop())))
   {
       d = (Display_data *)e->extra_data;
       d->selected--;

       ASSERT(d->selected >= 0);

   }
}


int Selection::contains(Electron *other) const
{
   Electron *e;
   selection->reset();

   while((e = (Electron *)(selection->get())))
   {
      if (e == other)
         return TRUE;

      selection->next();
   }

   return FALSE;
}



