/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include "data/gfx.h"


static PPE_TEX *create_texture(DATAFILE *d)
{


   if (d->type == AL_ID('B','M','P',' '))
   {
      return ppe_create_texture((BITMAP *)(d->dat));
   }
   else if (d->type == AL_ID('F','I','L','E'))
   {
      return ppe_create_animated_texture((DATAFILE *)(d->dat), 2);
   }
   else
   {
      fatal("datafile corrupt, texture %s is neither a still nor an animated texture", get_datafile_property(d, AL_ID('N','A','M','E')));
   }
   return NULL;
}

int Renderer_ppe::create_textures()
{
   tex = new (PPE_TEX *)[TEX_COUNT];

//   cons_printf(green,"\ncreating textures\n");

   for (int i=0;i < TEX_COUNT; i++)
   {

       if ( (gfx_data+i)->type != AL_ID('B','I','N',' '))
       {
         tex[i] = create_texture(gfx_data + i);
         if (!tex[i])
            fatal("error loading texture: out of memory or datafile corrupt");
         if (filtering)
            ppe_tex_add_mipmap(tex[i], 25);
       }
       else
       {
         tex[i] = NULL;
       }
          

//       cons_printf(green, "."); //! hmm slighly inefficient
//       switch_buffers();
   }
//   cons_printf(green,"\ndone creating textures\n");
//   switch_buffers();
   
   return 0;
}


void Renderer_ppe::destroy_textures()
{
   for (int i=0; i< TEX_COUNT; i++)
   {
      if (tex[i])
         ppe_destroy_texture(tex[i]);
   }
   delete [] tex;

//!   for (int i=0; i< TEX_A_COUNT; i++)
//       ppe_destroy_texture(a_tex[i]);

//   delete [] a_tex;

}


