/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#ifndef _RENDERER_PPE_H_
#define _RENDERER_PPE_H_

#include <allegro.h>
#include "client/renderer/renderer.h"
#include "ppe/include/ppe.h"
#include "client/clutils.h"


#define NUM_PPE_LAYERS 4
#define MAX_OVERLAYED_STRINGS 10
#define MAX_EFFECTS 100

class Display_object
  : public Object
{
 public:
   Display_object();
   ~Display_object();
   void add_ppe_object(PPE_OBJECT *o);
   int nr_states;
   PPE_OBJECT **ppe_object;

};

class Effect
{
   public:
    int effect;
    double x1,y1,x2,y2;
};


class Renderer_ppe
 : public Renderer
{

public:

   // render_w/h are the size of the playfield in pixels
   // console_w/h is in chracters, the size of the console in pixels
   // is defined by the amount of screen size left over next to the playfield
   // if (stretch) then the renderwindow is stretched to match
   // the width of the screen (the picture is still rendered at small size though)
   Renderer_ppe(int render_w, int console_w, int console_h, int cons_streams, int stretch, int cons_transparancy, char const *dname);
   ~Renderer_ppe();

//int init_renderer();
//void shutdown_renderer();

   int start(int mapsize_x, int mapsize_y);
   void stop();

   void is_dirty(List *dirty_list);
   void render(double camheight, Electron *center, double offset_x, double offset_y); // renders the playfield
   void draw_frame(); // updates the screen, can also be called without a prior 'render' then only the console will be updated
   void screenshot(char *comment); // saves a screenshot to disc
                  // engine can add walls etc

    void effect(int effect, double x1, double y1, double x2, double y2);
    
    void cons_resize(int amount); // changes the amount of screenspace the console occupies
    void cons_switch_font();
    void cons_pgup();
    void cons_pgdn();
    int cons_width() { return cons_vis_w;};

    // for KAZAM's, ZOOoOoOoOM's, BENG's etc.
    // overlays text on the rendered image
    // the style depends on the renderer, but style 0 is guaranteed to]
    // be somewhat neutral and legible ;-)
    // the string may not be deleted until after duration frames
    void overlay_text(char *text, int duration, int style = 0);
    void overlay_bitmap(BITMAP *bmp); // should never be used in the client, cause it can be highly
                                      // inefficient in other renderer implementations

    void show_electron(Electron *e);

    void show_mouse(int choice);

    void cursor(int x, int y);
    void block(int xf, int yf, int xt, int yt);
    
private:
    Effect effects[MAX_EFFECTS];
    int num_effects;
    void draw_effects();

    
    void cons_update_logic();
    void cons_render();
    int cons_hp(); // height in pixels
    FONT *cons_font;
    FONT *cons_normal_font;
    FONT *cons_sml_font;
    int cons_vis_w; // visible width in characters

    int tilesize;

    double cons_y_offset;
    int requested_cons_y_offset;
    int cons_transparancy;

    COLOR_MAP *trans_table;

    BITMAP *stipple_mask;

    int init_renderer();
    void shutdown_renderer();


    void update_logic();



    /* data loading*/
    int load_gfx();
    void unload_gfx();
    void setuptex(int *xtex, int *ytex, PPE_TEX *t, int nx = 1, int ny = 1);
    /* globals*/
    PPE_MAP *ppe_map;
    List *active_list;
    List *dynamic_list;
    //DATAFILE *stills_data;
    //DATAFILE *anims_data;
    DATAFILE *gfx_data;
    Display_object *display_object;
    int darkblue;
    
    //PPE_TEX **s_tex;  // still textures
    //PPE_TEX **a_tex;  // animated textures
    PPE_TEX **tex;
    
    /* dynamic Object management*/
    int is_dynamic(int objnr);
    void init_dynamic_translate();
    void shutdown_dynamic_translate();
    void add_dynamics_to_map();
    
    
    /* ppe Object managment*/
    Display_object *object_from_type(int actor_type); // gets ppe Object with an actor type
    int create_objects(); // sets up all ppe_objects;
    void destroy_objects();
    /*ppe texture management */
    
    int create_textures(); // sets up all the ppe textures
    void destroy_textures();
    
    
    
    /* utility functions from rutils.cc*/
    int datafile_count_objects(DATAFILE *d, int object_id);
    
    
    /* map decoration */
    void decorate_map_region(int x, int y, int w, int h);
    void decorate_pos(int x, int y);
    void decorate_dirty_bits();
    void decorate_addwalls(int x, int y, int layer);
    void decorate_addroofs(int x, int y, int layer);
    int decorate_canberoofed(int x, int y);
    
    /* array of ints marking dirty regions on the map*/
    int **map_dirty;
    int map_is_dirty;
        
    PPE_OBJECT *get_object(int nr);


    BITMAP *playfield;
    BITMAP *console_bitmap;
    int do_stretch;

    double requested_cam_x, requested_cam_y;
    double cam_x, cam_y;
    double cam_vx, cam_vy;

    void calc_cam();

    int has_rendered;


    // overlayed text stuff
    char *ovstring[MAX_OVERLAYED_STRINGS];
    int ovframe[MAX_OVERLAYED_STRINGS];
    int ovstyle[MAX_OVERLAYED_STRINGS];

    void draw_ovtext();

    Electron *electron_to_show;


    BITMAP *bitmap_to_overlay;

    void overlay_electron_info();
    void draw_electron_2d(Electron *e, BITMAP *onto, int x, int y, int w, int h);

    int do_show_mouse;

    int xcursor, ycursor;
    int xblockfrom, yblockfrom, xblockto, yblockto;
    
};

#endif
