#include "p_intern.h"




static BITMAP *scratch = NULL;

static int roundpow2(int x)
{
   int i;

   for (i=1;i<x;i*=2);

   return i;

}

BITMAP *ppe_scratch_bitmap(int w, int h)
{
   int oldw = 0, oldh = 0;
   w = roundpow2(w);
   h = roundpow2(h);
   
   if (!scratch || w > scratch->w || h > scratch->h)
   {
      if (scratch)
      {
         oldw = scratch->w;
         oldh = scratch->h;
         destroy_bitmap(scratch);
      }


      
      scratch = create_bitmap(MAX(oldw,w), MAX(oldh,h));

      if (!scratch)
      {
         if (screen)
            set_gfx_mode(GFX_TEXT,0,0,0,0);
         allegro_message("out of memory allocating scratch bitmap");

         exit(1);
         
      }
      
   }
   
   return scratch;

}


void ppe_cleanup_scratch()
{
   if (scratch)
      destroy_bitmap(scratch);

   scratch = NULL;
}

