#include <stdio.h>
#include "p_intern.h"
/* map rendering functions */



void ppe_map_render(PPE_MAP *m, BITMAP *onto)
{
   if (m->light_map)
      ppe_map_render_lit_ex(m, onto, 0, ppe_building_height - 1);
   else
      ppe_map_render_ex(m, onto, 0, ppe_building_height - 1);
}




static void ppe_draw_container(BITMAP *onto, PPE_CONTAINER *c, double offset_x, double offset_y, int layer, int pass)
{
   PPE_LIST *l;

   for (l = c->object[pass]; l; l=l->next)
   {
      if (l->object->type == PPE_T_TILE)
          ppe_draw_tile(layer, l->xfrom - offset_x, l->yfrom - offset_y,l->object->texture, onto, l->anim_offset);
      else if ( l->object->type >= PPE_T_NWALL && l->object->type <= PPE_T_SEWALL)
          ppe_draw_wall(l->face, layer, l->xfrom - offset_x,
                                 l->yfrom - offset_y,
                                 l->xto - offset_x,
                                 l->yto - offset_y,
                                 l->object->xtex, l->object->ytex, l->object->texture,
                                 onto, l->anim_offset);
      else if( l->object->type >= PPE_T_NSLOPE && l->object->type <= PPE_T_SECORNER2)
              ppe_draw_slope(l->face, l->type, layer,
                                      l->xfrom - offset_x, l->yfrom - offset_y,
                                      l->xto - offset_x, l->yto - offset_y,
                                      l->object->xtex, l->object->ytex, l->object->texture,
                                      onto, l->anim_offset);
      else if( l->object->type >= PPE_T_NULTRIANGLE && l->object->type <= PPE_T_SWLRTRIANGLE)
          ppe_draw_triangle(l->face, l->type, l->slope, layer,
                                  l->xfrom - offset_x, l->yfrom - offset_y,
                                  l->xto - offset_x, l->yto - offset_y,
                                  l->object->xtex, l->object->ytex, l->object->texture,
                                  onto, l->anim_offset);
      else if (l->object->type == PPE_T_DYNAMIC)
      {
   
          ppe_rotate_sprite(layer, l->fine_l, l->xfrom - offset_x,  l->yfrom - offset_y, l->angle,
                                    l->object->texture, onto, l->anim_offset);
      }
   }
//      textprintf(screen,font,0,0,makecol(255,0,0), "%d pass %d",layer,i);
      
//    readkey();
      

}

static void ppe_draw_lit_container(BITMAP *onto, PPE_CONTAINER *c, double offset_x, double offset_y, int layer, int pass, int lx,int ly,int ***light_map)
{
   PPE_LIST *l;

   for (l = c->object[pass]; l; l=l->next)
   {
      if (l->object->type == PPE_T_TILE)
          ppe_draw_lit_tile(layer, l->xfrom - offset_x, l->yfrom - offset_y,l->object->texture, onto, l->anim_offset, lx, ly, light_map);
      else if ( l->object->type >= PPE_T_NWALL && l->object->type <= PPE_T_SEWALL)
          ppe_draw_lit_wall(l->face, layer, l->xfrom - offset_x,
                                 l->yfrom - offset_y,
                                 l->xto - offset_x,
                                 l->yto - offset_y,
                                 l->object->xtex, l->object->ytex, l->object->texture,
                                 onto, l->anim_offset,lx,ly,light_map);
      else if( l->object->type >= PPE_T_NSLOPE && l->object->type <= PPE_T_SECORNER2)
              ppe_draw_slope(l->face, l->type, layer,
                                      l->xfrom - offset_x, l->yfrom - offset_y,
                                      l->xto - offset_x, l->yto - offset_y,
                                      l->object->xtex, l->object->ytex, l->object->texture,
                                      onto, l->anim_offset);
      else if( l->object->type >= PPE_T_NULTRIANGLE && l->object->type <= PPE_T_SWLRTRIANGLE)
          ppe_draw_triangle(l->face, l->type, l->slope, layer,
                                  l->xfrom - offset_x, l->yfrom - offset_y,
                                  l->xto - offset_x, l->yto - offset_y,
                                  l->object->xtex, l->object->ytex, l->object->texture,
                                  onto, l->anim_offset);
      else if (l->object->type == PPE_T_DYNAMIC)
      {
   
          ppe_rotate_lit_sprite(layer,l->fine_l, l->xfrom - offset_x,  l->yfrom - offset_y, l->angle,
                                    l->object->texture, onto, l->anim_offset,lx,ly,light_map);
      }
   }
//      textprintf(screen,font,0,0,makecol(255,0,0), "%d pass %d",layer,i);
      
//    readkey();
      

}


static void ppe_draw_container_schematic(BITMAP *onto, PPE_CONTAINER *c, double offset_x, double offset_y, int layer, int pass, int wireframe,int symbolic, int solid, int scolor)
{
   PPE_LIST *l;

   for (l = c->object[pass]; l; l=l->next)
   {
      if (l->object->type == PPE_T_TILE)
      {
         if (solid)
             ppe_draw_tile_solid(layer, l->xfrom - offset_x, l->yfrom - offset_y,l->object->texture, onto, scolor);

         if (symbolic || wireframe)
             ppe_draw_tile_schematic(layer, l->xfrom - offset_x, l->yfrom - offset_y,l->object->texture, onto);
   
      }
      else if ( l->object->type >= PPE_T_NWALL && l->object->type <= PPE_T_SEWALL)
          ppe_draw_wall_schematic(l->face, layer, l->xfrom - offset_x,
                                 l->yfrom - offset_y,
                                 l->xto - offset_x,
                                 l->yto - offset_y,
                                 l->object->xtex, l->object->ytex, l->object->texture,
                                 onto, wireframe, symbolic, solid, scolor);
      else if( l->object->type >= PPE_T_NSLOPE && l->object->type <= PPE_T_SECORNER2)
              ppe_draw_slope_schematic(l->face, l->type, layer,
                                      l->xfrom - offset_x, l->yfrom - offset_y,
                                      l->xto - offset_x, l->yto - offset_y,
                                      l->object->xtex, l->object->ytex, l->object->texture,
                                      onto, wireframe, symbolic, solid, scolor);
      else if( l->object->type >= PPE_T_NULTRIANGLE && l->object->type <= PPE_T_SWLRTRIANGLE)
          ppe_draw_triangle_schematic(l->face, l->type, l->slope, layer,
                                  l->xfrom - offset_x, l->yfrom - offset_y,
                                  l->xto - offset_x, l->yto - offset_y,
                                  l->object->xtex, l->object->ytex, l->object->texture,
                                  onto, wireframe, symbolic, solid, scolor);
      else if (l->object->type == PPE_T_DYNAMIC && solid) // in solid mode draw the sprites as normal
      {
   
          ppe_rotate_sprite(layer,l->fine_l, l->xfrom - offset_x,  l->yfrom - offset_y, l->angle,
                                    l->object->texture, onto, l->anim_offset);
      }
//      textprintf(screen,font,0,0,makecol(255,0,0), "%d pass %d",layer,i);
      
//    readkey();
      
   }
}


/* returns the mapcoordinates of the visible rectangle
 * when rendered on the screen
 */
void ppe_map_visible(PPE_MAP *m, BITMAP *onto,int *min_x, int * min_y, int *max_x, int *max_y)
{
      int x_from,y_from,x_to,y_to;
      x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l ,m->cam_lfine)) - 1;
      y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l ,m->cam_lfine)) - 1;
      x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l ,m->cam_lfine)) + 1;
      y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l ,m->cam_lfine)) + 1;


      *min_x = MAX(0, x_from);
      *min_y = MAX(0, y_from);
      *min_x = MIN(m->w - 1, *min_x);
      *min_y = MIN(m->h - 1, *min_y);
      *max_x = MAX(0, x_to);
      *max_y = MAX(0, y_to);
      *max_x = MIN(m->w - 1, *max_x);
      *max_y = MIN(m->h - 1, *max_y);

}


void ppe_map_render_ex(PPE_MAP *m,BITMAP *onto, int bottomlayer, int toplayer)
{

   
   int layr,i;
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;
   int tile_x_from, tile_y_from, tile_x_to, tile_y_to;
   int tile_x_mid, tile_y_mid;
   int x_from, y_from, x_to, y_to, x_mid, y_mid;
   int x, y;
   PPE_CONTAINER ****data;

   if (m->light_map)
   {
      ppe_map_render_lit_ex(m, onto, bottomlayer, toplayer);
      return;
   }
   
   bottomlayer = MID(0, m->l - 1, bottomlayer);
   toplayer = MID(0, m->l - 1, toplayer);

   data = (PPE_CONTAINER ****)(m->data);
   ppe_building_height = m->l;
   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   for (layr = bottomlayer;layr <= toplayer;layr++)
   {
      x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
      y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
      x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
      y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
      x_mid = (int)m->vpx;
      y_mid = (int)m->vpy;


      tile_x_from = MAX(0, x_from);
      tile_y_from = MAX(0, y_from);
      tile_x_from = MIN(m->w - 1, tile_x_from);
      tile_y_from = MIN(m->h - 1, tile_y_from);
      tile_x_to = MAX(0, x_to);
      tile_y_to = MAX(0, y_to);
      tile_x_to = MIN(m->w - 1, tile_x_to);
      tile_y_to = MIN(m->h - 1, tile_y_to);
      tile_x_mid = MAX(0, x_mid);
      tile_y_mid = MAX(0, y_mid);
      tile_x_mid = MIN(m->w - 1, tile_x_mid);
      tile_y_mid = MIN(m->h - 1, tile_y_mid);

      if (!layr)
      {
         for (x = tile_x_to+1; x<= x_to;x++)
             for (y = y_from; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);

             }
         for (x = x_from; x< tile_x_from ;x++)
             for (y = y_from; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
             
         for (x = tile_x_from ; x<= tile_x_to;x++)
             for (y = y_from; y< tile_y_from;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
         for (x = tile_x_from ; x<= tile_x_to;x++)
             for (y = tile_y_to+1; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
      }
      for (i=0; i< PPE_MAX_PASSES;i++)
      {
         for (x = tile_x_from; x< tile_x_mid; x++)
         {
            for (y = tile_y_from; y < tile_y_mid; y++)
            {
               if (data[x][y][layr])
                  ppe_draw_container(onto, data[x][y][layr], offsx, offsy, layr, i);
            }
         }
   
         for (x = tile_x_to; x> tile_x_mid; x--)
         {
            for (y = tile_y_from; y < tile_y_mid; y++)
            {
               if (data[x][y][layr])
                  ppe_draw_container(onto, data[x][y][layr], offsx, offsy, layr, i);
            }
         }
   
   
         for (x = tile_x_from; x< tile_x_mid; x++)
         {
            for (y = tile_y_to; y > tile_y_mid; y--)
            {
               if (data[x][y][layr])
                  ppe_draw_container(onto, data[x][y][layr], offsx, offsy, layr, i);
            }
         }
   
   
         for (x = tile_x_to; x> tile_x_mid; x--)
         {
            for (y = tile_y_to; y > tile_y_mid; y--)
            {
               if (data[x][y][layr])
                  ppe_draw_container(onto, data[x][y][layr], offsx, offsy, layr, i);
            }
         }
   
         for (x = tile_x_to; x> tile_x_mid; x--)
               if (data[x][tile_y_mid][layr])
                  ppe_draw_container(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i);
   
         for (x = tile_x_from; x< tile_x_mid; x++)
               if (data[x][tile_y_mid][layr])
                  ppe_draw_container(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i);
   
         for (y = tile_y_from; y < tile_y_mid; y++)
               if (data[tile_x_mid][y][layr])
                  ppe_draw_container(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i);
   
         for (y = tile_y_to; y > tile_y_mid; y--)
               if (data[tile_x_mid][y][layr])
                  ppe_draw_container(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i);
         
         if (data[tile_x_mid][tile_y_mid][layr])
                  ppe_draw_container(onto, data[tile_x_mid][tile_y_mid][layr], offsx, offsy, layr, i);

      }
   }
}


void ppe_map_render_lit_ex(PPE_MAP *m,BITMAP *onto, int bottomlayer, int toplayer)
{
   int layr,i;
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;
   int tile_x_from, tile_y_from, tile_x_to, tile_y_to;
   int tile_x_mid, tile_y_mid;
   int x_from, y_from, x_to, y_to, x_mid, y_mid;
   int x, y;
   PPE_CONTAINER ****data;

   ASSERT(m->light_map);

   bottomlayer = MID(0, m->l - 1, bottomlayer);
   toplayer = MID(0, m->l - 1, toplayer);

   data = (PPE_CONTAINER ****)(m->data);
   ppe_building_height = m->l;
   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   for (layr = bottomlayer;layr <= toplayer;layr++)
   {
      x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
      y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
      x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
      y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
      x_mid = (int)m->vpx;
      y_mid = (int)m->vpy;


      tile_x_from = MAX(0, x_from);
      tile_y_from = MAX(0, y_from);
      tile_x_from = MIN(m->w - 1, tile_x_from);
      tile_y_from = MIN(m->h - 1, tile_y_from);
      tile_x_to = MAX(0, x_to);
      tile_y_to = MAX(0, y_to);
      tile_x_to = MIN(m->w - 1, tile_x_to);
      tile_y_to = MIN(m->h - 1, tile_y_to);
      tile_x_mid = MAX(0, x_mid);
      tile_y_mid = MAX(0, y_mid);
      tile_x_mid = MIN(m->w - 1, tile_x_mid);
      tile_y_mid = MIN(m->h - 1, tile_y_mid);

      if (!layr)
      {
         for (x = tile_x_to+1; x<= x_to;x++)
             for (y = y_from; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);

             }
         for (x = x_from; x< tile_x_from ;x++)
             for (y = y_from; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
             
         for (x = tile_x_from ; x<= tile_x_to;x++)
             for (y = y_from; y< tile_y_from;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
         for (x = tile_x_from ; x<= tile_x_to;x++)
             for (y = tile_y_to+1; y<= y_to;y++)
             {
               ppe_draw_empty_tile(layr,x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, ppe_border_color);
             }
      }
      for (i=0; i< PPE_MAX_PASSES;i++)
      {
         for (x = tile_x_from; x< tile_x_mid; x++)
         {
            for (y = tile_y_from; y < tile_y_mid; y++)
            {
               if (data[x][y][layr])
                  ppe_draw_lit_container(onto, data[x][y][layr], offsx, offsy, layr, i, x, y, m->light_map);
            }
         }
   
         for (x = tile_x_to; x> tile_x_mid; x--)
         {
            for (y = tile_y_from; y < tile_y_mid; y++)
            {
               if (data[x][y][layr])
                  ppe_draw_lit_container(onto, data[x][y][layr], offsx, offsy, layr, i, x, y, m->light_map);
            }
         }
   
   
         for (x = tile_x_from; x< tile_x_mid; x++)
         {
            for (y = tile_y_to; y > tile_y_mid; y--)
            {
               if (data[x][y][layr])
                  ppe_draw_lit_container(onto, data[x][y][layr], offsx, offsy, layr, i, x, y, m->light_map);
            }
         }
   
   
         for (x = tile_x_to; x> tile_x_mid; x--)
         {
            for (y = tile_y_to; y > tile_y_mid; y--)
            {
               if (data[x][y][layr])
                  ppe_draw_lit_container(onto, data[x][y][layr], offsx, offsy, layr, i, x, y, m->light_map);
            }
         }
   
         for (x = tile_x_to; x> tile_x_mid; x--)
               if (data[x][tile_y_mid][layr])
                  ppe_draw_lit_container(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, x, tile_y_mid, m->light_map);
   
         for (x = tile_x_from; x< tile_x_mid; x++)
               if (data[x][tile_y_mid][layr])
                  ppe_draw_lit_container(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, x, tile_y_mid, m->light_map);
   
         for (y = tile_y_from; y < tile_y_mid; y++)
               if (data[tile_x_mid][y][layr])
                  ppe_draw_lit_container(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, tile_x_mid, y, m->light_map);
   
         for (y = tile_y_to; y > tile_y_mid; y--)
               if (data[tile_x_mid][y][layr])
                  ppe_draw_lit_container(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, tile_x_mid, y, m->light_map);
         
         if (data[tile_x_mid][tile_y_mid][layr])
                  ppe_draw_lit_container(onto, data[tile_x_mid][tile_y_mid][layr], offsx, offsy, layr, i, tile_x_mid, tile_y_mid, m->light_map);

      }
   }
}






void ppe_map_render_schematic(PPE_MAP *m,BITMAP *onto, int layr,int wireframe,int symbolic, int solid)
{
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;
   int tile_x_from, tile_y_from, tile_x_to, tile_y_to;
   int x, y;
   int tile_x_mid, tile_y_mid;
   int i;
   PPE_CONTAINER ****data;


   data = (PPE_CONTAINER ****)(m->data);
   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   tile_x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   tile_y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   
   
   tile_x_from = MAX(0, tile_x_from);
   tile_y_from = MAX(0, tile_y_from);
   tile_x_from = MIN(m->w -1, tile_x_from);
   tile_y_from = MIN(m->h -1 , tile_y_from);
   tile_x_to = MAX(0, tile_x_to);
   tile_y_to = MAX(0, tile_y_to);
   tile_x_to = MIN(m->w  -1, tile_x_to);
   tile_y_to = MIN(m->h  -1, tile_y_to);
   tile_x_mid = (int)m->vpx;
   tile_y_mid = (int)m->vpy;
   tile_x_mid = MAX(0, tile_x_mid);
   tile_y_mid = MAX(0, tile_y_mid);
   tile_x_mid = MIN(m->w - 1, tile_x_mid);
   tile_y_mid = MIN(m->h - 1, tile_y_mid);

   for (i=0; i< PPE_MAX_PASSES;i++)
   {
   

      for (x = tile_x_from; x< tile_x_mid; x++)
      {
         for (y = tile_y_from; y < tile_y_mid; y++)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
         }
      }
      
      for (x = tile_x_to; x> tile_x_mid; x--)
      {
         for (y = tile_y_from; y < tile_y_mid; y++)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
         }
      }
      
      
      for (x = tile_x_from; x< tile_x_mid; x++)
      {
         for (y = tile_y_to; y > tile_y_mid; y--)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
         }
      }
      
      
      for (x = tile_x_to; x> tile_x_mid; x--)
      {
         for (y = tile_y_to; y > tile_y_mid; y--)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
         }
      }
      
      for (x = tile_x_to; x> tile_x_mid; x--)
            if (data[x][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
      
      for (x = tile_x_from; x< tile_x_mid; x++)
            if (data[x][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
      
      for (y = tile_y_from; y < tile_y_mid; y++)
            if (data[tile_x_mid][y][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
      
      for (y = tile_y_to; y > tile_y_mid; y--)
            if (data[tile_x_mid][y][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);
      
      if (data[tile_x_mid][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][tile_y_mid][layr], offsx, offsy, layr, i, wireframe, symbolic, solid, -1);

   
   }
}

void ppe_map_render_grid(PPE_MAP *m,BITMAP *onto, int layr, int color)
{
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;
   int tile_x_from, tile_y_from, tile_x_to, tile_y_to;
   int x, y;


   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   tile_x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   tile_y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   
   
   tile_x_from = MAX(0, tile_x_from);
   tile_y_from = MAX(0, tile_y_from);
   tile_x_from = MIN(m->w  -1, tile_x_from);
   tile_y_from = MIN(m->h  -1, tile_y_from);
   tile_x_to = MAX(0, tile_x_to);
   tile_y_to = MAX(0, tile_y_to);
   tile_x_to = MIN(m->w  -1, tile_x_to);
   tile_y_to = MIN(m->h  -1, tile_y_to);
   
   for (x = tile_x_from; x< tile_x_to; x++)
   {
      for (y = tile_y_from; y < tile_y_to; y++)
      {
         ppe_draw_empty_tile_schematic(layr,  x * ppe_tile_size - offsx, y *ppe_tile_size - offsy, onto, color);
      }
   }
}


extern void ppe_map_render_hiddenwire(PPE_MAP *m,BITMAP *onto, int layr, int bgcolor)
{
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;
   int tile_x_from, tile_y_from, tile_x_to, tile_y_to;
   int x, y;
   int tile_x_mid, tile_y_mid;
   int i;
   PPE_CONTAINER ****data;


   data = (PPE_CONTAINER ****)(m->data);
   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   tile_x_from = m->vpx - m->cam_x/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_y_from = m->vpy - m->cam_y/ (ppe_tile_size * PPE_SCALE(m->cam_l - layr,m->cam_lfine)) - 1;
   tile_x_to = m->vpx + (onto->w - m->cam_x)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   tile_y_to = m->vpy + (onto->h - m->cam_y)/ (ppe_tile_size * PPE_SCALE(m->cam_l -layr,m->cam_lfine)) + 1;
   
   
   tile_x_from = MAX(0, tile_x_from);
   tile_y_from = MAX(0, tile_y_from);
   tile_x_from = MIN(m->w -1, tile_x_from);
   tile_y_from = MIN(m->h -1, tile_y_from);
   tile_x_to = MAX(0, tile_x_to);
   tile_y_to = MAX(0, tile_y_to);
   tile_x_to = MIN(m->w -1, tile_x_to);
   tile_y_to = MIN(m->h -1, tile_y_to);
   tile_x_mid = (int)m->vpx;
   tile_y_mid = (int)m->vpy;
   tile_x_mid = MAX(0, tile_x_mid);
   tile_y_mid = MAX(0, tile_y_mid);
   tile_x_mid = MIN(m->w - 1, tile_x_mid);
   tile_y_mid = MIN(m->h - 1, tile_y_mid);

   for (i=0; i< PPE_MAX_PASSES;i++)
   {
   

      for (x = tile_x_from; x< tile_x_mid; x++)
      {
         for (y = tile_y_from; y < tile_y_mid; y++)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
         }
      }
      
      for (x = tile_x_to; x> tile_x_mid; x--)
      {
         for (y = tile_y_from; y < tile_y_mid; y++)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
         }
      }
      
      
      for (x = tile_x_from; x< tile_x_mid; x++)
      {
         for (y = tile_y_to; y > tile_y_mid; y--)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
         }
      }
      
      
      for (x = tile_x_to; x> tile_x_mid; x--)
      {
         for (y = tile_y_to; y > tile_y_mid; y--)
         {
            if (data[x][y][layr])
               ppe_draw_container_schematic(onto, data[x][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
         }
      }
      
      for (x = tile_x_to; x> tile_x_mid; x--)
            if (data[x][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
      
      for (x = tile_x_from; x< tile_x_mid; x++)
            if (data[x][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[x][tile_y_mid][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
      
      for (y = tile_y_from; y < tile_y_mid; y++)
            if (data[tile_x_mid][y][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
      
      for (y = tile_y_to; y > tile_y_mid; y--)
            if (data[tile_x_mid][y][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][y][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);
      
      if (data[tile_x_mid][tile_y_mid][layr])
               ppe_draw_container_schematic(onto, data[tile_x_mid][tile_y_mid][layr], offsx, offsy, layr, i, TRUE, FALSE, TRUE, bgcolor);

   
   }

}




void ppe_map_highlight_tile(PPE_MAP *m,BITMAP *onto,  int x, int y, int layr, int color)
{
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;


   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   ppe_draw_empty_tile_schematic(layr,  x * ppe_tile_size - offsx, y *ppe_tile_size- offsy, onto, color);


}

void ppe_map_highlight_rect(PPE_MAP *m,BITMAP *onto,  int xf, int yf, int xt, int yt, int layr, int color)
{
   double offsx = m->vpx * ppe_tile_size - m->cam_x;
   double offsy = m->vpy * ppe_tile_size - m->cam_y;


   
   ppe_set_camera_pos(m->cam_x, m->cam_y);
   ppe_set_camera_height(m->cam_l, m->cam_lfine);

   ppe_draw_arced_region(layr,  xf * ppe_tile_size - offsx, yf *ppe_tile_size- offsy,  xt * ppe_tile_size - offsx, yt *ppe_tile_size- offsy, onto, color);
}


/* translate screencoordinates to mapcoordinates */
void ppe_map_select_tile(PPE_MAP *m, int x, int y, int layr, int *xm, int *ym)
{



   x -= m->cam_x;
   y -= m->cam_y;

   x /= PPE_SCALE(m->cam_l - layr,m->cam_lfine);
   y /= PPE_SCALE(m->cam_l - layr,m->cam_lfine);

   

   x += m->vpx * ppe_tile_size;
   y += m->vpy * ppe_tile_size;


   x /= ppe_tile_size;
   y /= ppe_tile_size;


   *xm = MID(0, m->w - 1, x);
   *ym = MID(0, m->h - 1, y);
}
