#include <stdio.h>
#include "p_intern.h"



PPE_OBJECT *ppe_create_object(int type, int *xtex, int *ytex, PPE_TEX *texture, int len)
{
    return ppe_create_object_ex(type, xtex, ytex, texture, len, -1, -1);

}

PPE_OBJECT *ppe_create_object_ex(int type, int *xtex, int *ytex, PPE_TEX *texture, int e, int texnr, int objnr)
{
   PPE_OBJECT *o;

   o = malloc(sizeof(PPE_OBJECT));

   if (!o)
   {
      sprintf(ppe_error,"out of memory");
      return NULL;
   }

   ppe_change_object_ex(o,type, xtex, ytex, texture,  e, texnr, objnr);

   if (type == PPE_T_BUILDING)
   {
    o->building = ppe_create_building();
    if (!o->building)
    {
      free(o);
      return NULL;
    }
   }
   
   return o;
}

PPE_OBJECT *ppe_change_object_ex(PPE_OBJECT *o,int type, int *xtex, int *ytex, PPE_TEX *texture, int e, int texnr, int objnr)
{
   int i;


   o->type = type;
   o->texture = texture;
   o->length = e;
   o->texture_number = texnr;
   o->object_number = objnr;

   
//   if (type != PPE_T_TILE)
//   {
     if (xtex && ytex)
     {
      for (i = 0; i < 4; i++)
      {
          o->xtex[i] = xtex[i];
          o->ytex[i] = ytex[i];
      }
     }
//   }

   return o;
}


void ppe_compound_object_add(PPE_OBJECT *obj, int x, int y, int layer, PPE_OBJECT *o)
{
   ASSERT(obj->type == PPE_T_BUILDING);

   ppe_building_add(obj->building, x, y, layer, o);

}

void ppe_destroy_object(PPE_OBJECT *obj)
{
   if (obj->type == PPE_T_BUILDING)
   {
      ppe_destroy_building(obj->building);
   }
   free(obj);
}

PPE_LIST ppe_object_table[PPE_T_LAST] =
{
        /*xfrom,yfrom,xto,yto, face, type, slope, pass, typename*/
 {NULL, NULL, 0, 0, 0, 0, 0, 0, FALSE, 0, "Simple tile"} , /*   PPE_T_TILE = 0*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N, 0, FALSE, 3, "North wall" } , /*   PPE_T_NWALL*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S, 0, FALSE, 3, "South wall" } , /*   PPE_T_SWALL*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E, 0, FALSE, 3, "East wall" } , /*   PPE_T_EWALL*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W, 0, FALSE, 3, "West wall" } , /*   PPE_T_WWALL*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, 0, FALSE, 3, "Northwest wall" } , /*   PPE_T_NWWALL*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, 0, FALSE, 3, "Northeast wall" } , /*   PPE_T_NEWALL*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, 0, FALSE, 3, "Southwest wall" } , /*   PPE_T_SWWALL*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, 0, FALSE, 3, "Southeast wall" } , /*   PPE_T_SEWALL*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N, 0, TRUE, 3, "North slope" } , /*   PPE_T_NSLOPE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S, 0, TRUE, 3, "South slope" } , /*   PPE_T_SSLOPE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E, 0, TRUE, 3, "East slope" } , /*   PPE_T_ESLOPE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W, 0, TRUE, 3, "West slope" } , /*   PPE_T_WSLOPE*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, CORNER_HIGH, TRUE, 3, "Northwest slope 1" } , /*   PPE_T_NWCORNER1*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, CORNER_HIGH, TRUE, 3, "Southwest slope 1" } , /*   PPE_T_SWCORNER1*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, CORNER_HIGH, TRUE, 3, "Northeast slope 1" } , /*   PPE_T_NECORNER1*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, CORNER_HIGH, TRUE, 3, "Southeast slope 1" } , /*   PPE_T_SECORNER1*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, CORNER_LOW, TRUE, 3, "Northwest slope 2" } , /*   PPE_T_NWCORNER2*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, CORNER_LOW, TRUE, 3, "Southwest slope 2" } , /*   PPE_T_SWCORNER2*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, CORNER_LOW, TRUE, 3, "Northeast slope 2" } , /*   PPE_T_NECORNER2*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, CORNER_LOW, TRUE, 3, "Southeast slope 2" } , /*   PPE_T_SECORNER2*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_UL, FALSE, 3, "North upper left triangle " } , /*   PPE_T_NULTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_UL, FALSE, 3, "South upper left triangle " } , /*   PPE_T_SULTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_UL, FALSE, 3, "East upper left triangle  " } , /*   PPE_T_EULTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_UL, FALSE, 3, "West upper left triangle  " } , /*   PPE_T_WULTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_LL, FALSE, 3, "North lower left triangle " } , /*   PPE_T_NLLTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_LL, FALSE, 3, "South lower left triangle " } , /*   PPE_T_SLLTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_LL, FALSE, 3, "East lower left triangle  " } , /*   PPE_T_ELLTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_LL, FALSE, 3, "West lower left triangle  " } , /*   PPE_T_WLLTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_UR, FALSE, 3, "North upper right triangle" } , /*   PPE_T_NURTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_UR, FALSE, 3, "South upper right triangle" } , /*   PPE_T_SURTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_UR, FALSE, 3, "East upper right triangle " } , /*   PPE_T_EURTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_UR, FALSE, 3, "West upper right triangle " } , /*   PPE_T_WURTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_LR, FALSE, 3, "North lower right triangle" } , /*   PPE_T_NLRTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_LR, FALSE, 3, "South lower right triangle" } , /*   PPE_T_SLRTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_LR, FALSE, 3, "East lower right triangle " } , /*   PPE_T_ELRTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_LR, FALSE, 3, "West lower right triangle " } , /*   PPE_T_WLRTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_UL, TRUE, 3, "Sloped North upper left triangle " } , /*   PPE_T_S_NULTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_UL, TRUE, 3, "Sloped South upper left triangle " } , /*   PPE_T_S_SULTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_UL, TRUE, 3, "Sloped East upper left triangle  " } , /*   PPE_T_S_EULTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_UL, TRUE, 3, "Sloped West upper left triangle  " } , /*   PPE_T_S_WULTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_LL, TRUE, 3, "Sloped North lower left triangle " } , /*   PPE_T_S_NLLTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_LL, TRUE, 3, "Sloped South lower left triangle " } , /*   PPE_T_S_SLLTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_LL, TRUE, 3, "Sloped East lower left triangle  " } , /*   PPE_T_S_ELLTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_LL, TRUE, 3, "Sloped West lower left triangle  " } , /*   PPE_T_S_WLLTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_UR, TRUE, 3, "Sloped North upper right triangle" } , /*   PPE_T_S_NURTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_UR, TRUE, 3, "Sloped South upper right triangle" } , /*   PPE_T_S_SURTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_UR, TRUE, 3, "Sloped East upper right triangle " } , /*   PPE_T_S_EURTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_UR, TRUE, 3, "Sloped West upper right triangle " } , /*   PPE_T_S_WURTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 0, PPE_N,  PPE_LR, TRUE, 3, "Sloped North lower right triangle" } , /*   PPE_T_S_NLRTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 1, PPE_S,  PPE_LR, TRUE, 3, "Sloped South lower right triangle" } , /*   PPE_T_S_SLRTRIANGLE*/
 {NULL, NULL, 1, 1, 1, 0, PPE_E,  PPE_LR, TRUE, 3, "Sloped East lower right triangle " } , /*   PPE_T_S_ELRTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 1, PPE_W,  PPE_LR, TRUE, 3, "Sloped West lower right triangle " } , /*   PPE_T_S_WLRTRIANGLE*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, PPE_UL, FALSE, 3, "Northeast upper left triangle  " } , /*      PPE_T_NEULTRIANGLE*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, PPE_UR, FALSE, 3, "Northeast upper right triangle " } , /*      PPE_T_NEURTRIANGLE*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, PPE_LL, FALSE, 3, "Northeast lower left triangle  " } , /*      PPE_T_NELLTRIANGLE*/
 {NULL, NULL, 1, 1, 0, 0, PPE_NE, PPE_LR, FALSE, 3, "Northeast lower right triangle " } , /*      PPE_T_NELRTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, PPE_UL, FALSE, 3, "Northwest upper left triangle  " } , /*      PPE_T_NWULTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, PPE_UR, FALSE, 3, "Northwest upper right triangle " } , /*      PPE_T_NWURTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, PPE_LL, FALSE, 3, "Northwest lower left triangle  " } , /*      PPE_T_NWLLTRIANGLE*/
 {NULL, NULL, 1, 0, 0, 1, PPE_NW, PPE_LR, FALSE, 3, "Northwest lower right triangle " } , /*      PPE_T_NWLRTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, PPE_UL, FALSE, 3, "Southeast upper left triangle  " } , /*      PPE_T_SEULTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, PPE_UR, FALSE, 3, "Southeast upper right triangle " } , /*      PPE_T_SEURTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, PPE_LL, FALSE, 3, "Southeast lower left triangle  " } , /*      PPE_T_SELLTRIANGLE*/
 {NULL, NULL, 0, 1, 1, 0, PPE_SE, PPE_LR, FALSE, 3, "Southeast lower right triangle " } , /*      PPE_T_SELRTRIANGLE*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, PPE_UL, FALSE, 3, "Southwest upper left triangle  " } , /*      PPE_T_SWULTRIANGLE*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, PPE_UR, FALSE, 3, "Southwest upper right triangle " } , /*      PPE_T_SWURTRIANGLE*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, PPE_LL, FALSE, 3, "Southwest lower left triangle  " } , /*      PPE_T_SWLLTRIANGLE*/
 {NULL, NULL, 0, 0, 1, 1, PPE_SW, PPE_LR, FALSE, 3, "Southwest lower right triangle " } ,  /*      PPE_T_SWLRTRIANGLE*/
 {NULL, NULL, 0, 0, 0, 0, 0,  0,  FALSE, 1, "dynamic object"  }, /* dynamic object  (sprite)   //! vul default dingen nog in*/
 {NULL, NULL, 0, 0, 0, 0, 0,  0,  FALSE, 1, "compound object"  }
};
