#include <stdlib.h>
#include <stdio.h>
#include "p_intern.h"


static PPE_CONTAINER *ppe_create_container()
{
   PPE_CONTAINER *c;
   int i;

   c = malloc(sizeof(PPE_CONTAINER));

   if (!c)
      return NULL;

   c->nr_obj = 0;

   for (i=0; i< PPE_MAX_PASSES; i++)
      c->object[i] = NULL;



   return c;

}


static void ppe_destroy_container(PPE_CONTAINER *c)
{
   int p;

   if (!c)
      return;

   for (p = 0; p< PPE_MAX_PASSES;p++)
   {
      if (c->object[p])
         ppe_free_list(c->object[p]);
   }
   free(c);
}

static PPE_LIST *ppe_copy_list(PPE_LIST *source)
{
   PPE_LIST *l;

   l = ppe_new_list_elem();

   if (!l)
      return NULL;

   l->next = source->next;
   l->object = source->object;
   l->xfrom = source->xfrom;
   l->yfrom = source->yfrom;
   l->xto = source->xto;
   l->yto = source->yto;
   l->face = source->face;
   l->type = source->type;
   l->slope = source->slope;
   l->pass = source->pass;

   l->angle = 0;
   l->anim_offset = 0;
   l->fine_l = 0;
   return l;
}






static PPE_LIST *ppe_container_add(PPE_CONTAINER *c, PPE_OBJECT *o, int x, int y)
{
   PPE_LIST *l;

   ASSERT(o->type != PPE_T_DYNAMIC);

   // create new list element setup for this type of object
   l = ppe_copy_list(ppe_object_table + o->type);

//   if (o->texture->nr_frames)
//       l->anim_offset = o->texture->nr_frames -
//                        ((ppe_animation_frame >> o->texture->multiplier) % o->texture->nr_frames);

   l->anim_offset = rand() % 100;
      
   l->next = c->object[l->pass];
   l->object = o;

   c->object[l->pass] = l;
   c->nr_obj++;

   l->xfrom = (x + l->xfrom) * ppe_tile_size;
   l->yfrom = (y + l->yfrom) * ppe_tile_size;
   l->xto = (x + l->xto) * ppe_tile_size;
   l->yto = (y + l->yto) * ppe_tile_size;


   switch(l->face)
   {
      case PPE_N:
       l->xto -= (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_S:
       l->xto += (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_E:
       l->yto -= (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_W:
       l->yto += (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_NW:
       l->xto -= (o->length  - 1) * ppe_tile_size;
       l->yto += (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_NE:
       l->xto -= (o->length  - 1) * ppe_tile_size;
       l->yto -= (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_SW:
       l->xto += (o->length  - 1) * ppe_tile_size;
       l->yto += (o->length  - 1) * ppe_tile_size;
       break;
      case PPE_SE:
       l->xto += (o->length  - 1) * ppe_tile_size;
       l->yto -= (o->length  - 1) * ppe_tile_size;
       break;
   }

   return l;
}

static PPE_LIST *ppe_container_add_dynamic(PPE_CONTAINER *c, PPE_OBJECT *o, int x, int y, double fine_x, double fine_y, double fine_l, int angle, int anim_offset)
{
   PPE_LIST *l;


   ASSERT(o->type == PPE_T_DYNAMIC);



   l = ppe_copy_list(ppe_object_table + o->type);

   if (o->type == PPE_T_DYNAMIC)
      l->pass = o->ytex[1]; /* copy pass parameter from sprite object */

   l->anim_offset = anim_offset;

   l->pass = ((int)fine_l>10) ? 4 : 1;
   l->fine_l = fine_l;
   l->angle = itofix(angle);
   l->next = c->object[l->pass];
   l->object = o;

   c->object[l->pass] = l;
   c->nr_obj++;

   l->xfrom = ppe_tile_size * (x + fine_x); //! re-use unused texture coords
   l->yfrom = ppe_tile_size * (y + fine_y);


   return l;
}


static void ppe_container_remove(PPE_CONTAINER *c, PPE_OBJECT *o)
{
   int p;
   PPE_LIST *i, *last;


   for (p = 0; p< PPE_MAX_PASSES;p++)
   {
      last = NULL;
      for (i = c->object[p]; i; i = i->next)
      {
        if (i->object == o)
        {
            if (last)
               last->next = i->next;
            else
               c->object[p] = i->next;
               
            ppe_free_list_elem(i);
            c->nr_obj--;
            
            return;
        }
        
        last = i;
      }
   }
}

static PPE_LIST *ppe_container_getlist(PPE_CONTAINER *c, int nr)
{
   int counter = 0;
   PPE_LIST *i;
   int p;
   
   for (p = 0; p< PPE_MAX_PASSES;p++)
   {
      for (i = c->object[p]; i; i = i->next)
      {
         if (counter == nr)
            return i;
            
         counter++;
      }
   }

   return NULL;
}


PPE_MAP *ppe_create_map(int size_x, int size_y, int layers)
{
   PPE_MAP *map;
   int x, y, i, j;
   PPE_CONTAINER ****data; /* 3d map */

   map = malloc(sizeof(PPE_MAP));
   map->w = size_x;
   map->h = size_y;
   ppe_building_height = map->l = layers;
   
   ppe_set_perspective(ppe_max_size, ppe_min_size);

   map->cam_x = ppe_cam_x;
   map->cam_y = ppe_cam_y;
   map->cam_l = ppe_cam_l;
   map->vpx = size_x/2;
   map->vpy = size_y/2;

   map->light_map = NULL;
   
   data = malloc(sizeof(PPE_CONTAINER ***) * size_x);

   if (!data)
   {
      free(map);
      sprintf(ppe_error,"out of memory allocating map");
      return NULL;
   }

   for (x = 0; x< size_x;x++)
   {
      data[x] = malloc(sizeof(PPE_CONTAINER **) * size_y);
      if (!data[x])
      {
         for (i = 0; i<x; i++)
             free(data[i]);
             
         free(data);
         sprintf(ppe_error,"out of memory allocating map");
         free(map);
         return NULL;
      }
      for (y = 0;y < size_y; y++)
      {
         data[x][y] = malloc(sizeof(PPE_CONTAINER *) * ppe_building_height);
         if (!data[x][y])
         {
            for (i = 0; i< y;i++)
                free(data[x][i]);

            for (i = 0; i<x; i++)
            {
                for (j = 0; j< ppe_building_height;j++)
                    free(data[i][j]);
                    
                free(data[i]);
            }
            free(data);
            free(map);
            sprintf(ppe_error,"out of memory allocating map");
            return NULL;
         }
         for (i = 0; i < ppe_building_height; i++)
             data[x][y][i] = NULL;

      }
      
   }

   map->data = data;
   return map;
}

void ppe_destroy_map(PPE_MAP *map)
{
   int x,y,l;
   PPE_CONTAINER ****data;


   data = (PPE_CONTAINER ****)(map->data);

   for (x = 0; x < map->w; x++)
   {
      for (y = 0; y < map->h;y++)
      {
         for (l = 0;l < map->l;l++)
                ppe_destroy_container(data[x][y][l]);

         free(data[x][y]);
      }
      free(data[x]);
   }
   free(data);

   if (map->light_map)
      ppe_disable_lighting(map);

   free(map);
}

void ppe_map_set_viewpos(PPE_MAP *m,double x, double y, double camheight)
{
   m->vpx = x;
   m->vpy = y;
   m->cam_l = (int)camheight;
   m->cam_lfine = (camheight - (int)camheight) * (1 << PPE_FINESHIFT);

   m->cam_l = MIN(m->cam_l, ppe_nr_layers - 1);
   m->cam_l = MAX(m->cam_l, 1);
}

extern void ppe_map_set_camerapos(PPE_MAP *m, int x,int y)
{
   m->cam_x = x;
   m->cam_y = y;
}



PPE_OBJHANDLE *ppe_map_add_object(PPE_MAP *m,int x, int y, int l, PPE_OBJECT *o)
{
   PPE_LIST *list;
   PPE_CONTAINER ****data;


   if (o->type == PPE_T_BUILDING)
   {
      ppe_map_add_building(m,x,y,l,o->building);
      return NULL;
   }

   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      data[x][y][l] = ppe_create_container();

   if (!(data[x][y][l]))
      return NULL;

    list = ppe_container_add(data[x][y][l], o,  x, y);

    return (PPE_OBJHANDLE *)list;
}




PPE_MAP *ppe_load_map(char *mapfilename, char *texfilename, PPE_OBJECT ***objects)
{
   PACKFILE *f;
   PPE_MAP *m = NULL;
   int i,j,x,y,l,w,h,d, textures_needed, nr_objects;
   PPE_OBJECT **objs = NULL;
   /*object props*/
   int objtype, objlength, objtex, objnr;
   int objxtex[4];
   int objytex[4];
   
   
   if (texfilename)
   {
      if (ppe_load_textures(texfilename, FALSE))
         return NULL;
   }

   if (!ppe_textures)
   {
      sprintf(ppe_error,"need textures loaded to load the map");
      return NULL;
   }

   
   f = pack_fopen(mapfilename, F_READ_PACKED);

   if (!f)
   {
      sprintf(ppe_error,"could not open file %s",mapfilename);
      return NULL;
   }
   
   if (pack_mgetl(f) != AL_ID('P','P','E','M'))
   {

      sprintf(ppe_error,"%s is not a valid ppe mapfile",mapfilename);
      goto getout;
   }

   textures_needed = pack_mgetw(f);

   if (textures_needed != ppe_nr_textures)
      sprintf(ppe_error,"Warning: nr of textures loaded greater than needed, are you sure this is the right texturefile?");

   if(textures_needed > ppe_nr_textures)
   {
      sprintf(ppe_error,"There are not enough textures loaded for this map (loaded %d, needed %d)",ppe_nr_textures, textures_needed);
      goto getout;
   }
   
   w = pack_mgetw(f);
   h = pack_mgetw(f);
   d = pack_mgetw(f);
   nr_objects = pack_mgetw(f);

   if(d >= ppe_cam_l)
   {
      sprintf(ppe_error,"The maximum camera height is not high enough for this map");
      goto getout;
   }


   objs = malloc(sizeof(PPE_OBJECT *) * nr_objects + 1);
   
   if (!objs)
   {
      sprintf(ppe_error,"out of memory allocating space for objects ");
      goto getout;
   
   }


   for (i=0; i<nr_objects;i++)
   {
      objtype = pack_mgetw(f);
      objtex = pack_mgetw(f);
      for (j=0;j<4;j++)
      {
         objxtex[j] = pack_mgetw(f);
         objytex[j] = pack_mgetw(f);
      }
      objlength = pack_mgetw(f);

      objs[i] = ppe_create_object_ex(objtype,objxtex,objytex,&(ppe_textures[objtex]), objlength, objtex, i);
      if (!objs[i])
      {
         ppe_destroy_objects(objs);
         sprintf(ppe_error,"out of memory allocating space for objects ");
         objs = NULL;
         goto getout;
      }
   }
   objs[nr_objects] = NULL;
   
   
   m = ppe_create_map(w, h, d);

   if (!m)
   {
      sprintf(ppe_error,"out of memory allocating %dx%dx%d map",w,h,d);
      ppe_destroy_objects(objs);
      objs = NULL;
      goto getout;
   }

   for (x=0;x<w;x++)
   {
      for(y=0; y<h ;y++)
      {
         for(l=0;l<d;l++)
         {
            nr_objects = pack_mgetw(f);
/*            if (nr_objects)
               fprintf(stderr," %d %d %d: %d\n",x,y,l,nr_objects); */
            for (i = 0; i< nr_objects;i++)
            {
               objnr = pack_mgetw(f);
               ppe_map_add_object(m, x, y, l, objs[objnr]);
            }
         }
      }
   }


getout:
   *objects = objs;
   pack_fclose(f);
   return m;


}


extern void ppe_destroy_objects(PPE_OBJECT **objs)
{
   int i;

   for (i = 0; objs[i];i++)
   {
      ppe_destroy_object(objs[i]);
   }


   free(objs);
}



void ppe_map_remove_object(PPE_MAP *m, int x,int y,int l,PPE_OBJECT *o)
{
   PPE_CONTAINER ****data;


   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      return;
      
   ppe_container_remove(data[x][y][l], o);

   if (!(data[x][y][l]->nr_obj))
   {
      ppe_destroy_container(data[x][y][l]);
      data[x][y][l] = NULL;
   }

}


PPE_LIST *ppe_map_get_listobject(PPE_MAP *m, int x, int y, int l,int nr)
{
   PPE_CONTAINER ****data;

   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      return NULL;

   return ppe_container_getlist(data[x][y][l], nr);
   
}

int ppe_map_get_nr_objects(PPE_MAP *m, int x, int y, int l)
{
   PPE_CONTAINER ****data;

   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      return 0;

   return data[x][y][l]->nr_obj;
}


inline void ppe_map_clear_pass(PPE_MAP *m, int x, int y, int l, int pass)
{
   PPE_CONTAINER ****data;

   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      return;

   if (data[x][y][l]->object[pass])
       ppe_free_list(data[x][y][l]->object[pass]);

   data[x][y][l]->object[pass] = NULL;

}

void ppe_map_clear(PPE_MAP *m, int x, int y, int l)
{
   int i;
   
   for (i = 0; i < PPE_MAX_PASSES; i++)
       ppe_map_clear_pass(m, x, y, l, i);
}


void ppe_map_clear_dynamic(PPE_MAP *m, int xfrom, int yfrom, int xto, int yto)
{
   int l,x,y;
   PPE_CONTAINER ****data;

   data = (PPE_CONTAINER ****)(m->data);

   for (l = 0;l< m->l;l++)
   {
      for (x = xfrom; x<=xto;x++)
      {
         for (y = yfrom;y<=yto;y++)
         {
            /* dynamic objects are in pass 1 or 4*/
            if (data[x][y][l])
            {
               ppe_map_clear_pass(m,x,y,l,1);
               ppe_map_clear_pass(m,x,y,l,4);
            }
         }
      }
   }

}


PPE_OBJHANDLE  *ppe_map_add_dynamic(PPE_MAP *m, int x, int y, int l, double fine_x, double fine_y, double fine_l,int angle,PPE_OBJECT *o, int anim_offset)
{
   PPE_LIST *list;
   PPE_CONTAINER ****data;

   ASSERT(o->type == PPE_T_DYNAMIC);

   data = (PPE_CONTAINER ****)(m->data);

   if (!(data[x][y][l]))
      data[x][y][l] = ppe_create_container();

   if (!(data[x][y][l]))
      return NULL;

   list = ppe_container_add_dynamic(data[x][y][l], o,  x, y, fine_x, fine_y, fine_l, angle, anim_offset);


   return (PPE_OBJHANDLE *)list;

}

void ppe_map_transform(PPE_MAP *m, double x, double y, int l, int *xo, int *yo)
{
   double scale = PPE_SCALE((m->cam_l) - l, (m->cam_lfine));

   x -= m->vpx;
   y -= m->vpy;

   *xo = (int)((x * ppe_tile_size) * scale + m->cam_x);
   *yo = (int)((y * ppe_tile_size) * scale + m->cam_y);
                     
}

