#include "p_intern.h"

int ppe_max_num_dynamic_lights = 0;

int ppe_enable_lighting(PPE_MAP *map, int lightlevel)
{
   int i,j, k;
   
   ASSERT(map);
   ASSERT(!(map->light_map));

   map->light_map = malloc(sizeof(int **) * (map->w + 1));

   if (!map->light_map)
      return -1;

   for (i = 0;i<=map->w;i++)
   {
      map->light_map[i] = malloc(sizeof(int *)* (map->h + 1));
      if (!(map->light_map[i]))
      {
         for (j=0;j<i;j++)
         {
             for (k = 0;k <= map->w;k++)
                 free(map->light_map[j][k]);

             free(map->light_map[j]);
         }
         free(map->light_map);

         map->light_map = NULL;

         return -1;
      }
      for (j=0;j<=map->h;j++)
      {
         map->light_map[i][j] = malloc(sizeof(int) * (map->l + 1));
         if (!(map->light_map[i][j]))
         {
            for (k=0;k<j;k++)
            {
               free(map->light_map[i][k]);
            }

            free(map->light_map[i]);
            for (j=0;j<i;j++)
            {
                for (k = 0;k <= map->w;k++)
                    free(map->light_map[j][k]);
   
                free(map->light_map[j]);
            }
            free(map->light_map);
   
            map->light_map = NULL;
   
            return -1;
         }

         for (k = 0;k<=map->l;k++)
         {
            map->light_map[i][j][k] = lightlevel;
         }
         
      }
   }

   return 0;
}


void ppe_disable_lighting(PPE_MAP *map)
{
   int i,j;
   
   ASSERT(map);

   if (map->light_map)
   {
      for (i = 0;i<=map->w;i++)
      {
          for (j=0;j<=map->h;j++)
              free(map->light_map[i][j]);

          free(map->light_map[i]);
      }
      free(map->light_map);

      map->light_map = NULL;

   }
   
}

static void base_light(int ***light, int w, int h, int l, int base)
{
   int i,j,k;

   for (i=0;i<w;i++)
       for (j=0;j<h;j++)
           for (k=0;k<l;k++)
               light[i][j][k] = base;
}

static void fill_light(int ***light,double x, double y, double l, int strength, double radius1, double radius2, int maxx,int maxy, int maxl)
{

   int i,j,k;
   int fx,fy,fl,tx,ty,tl;
   int to_add;
   double cur_rad;


   fx = MAX(0, x - (radius1 + radius2) - 1);
   fy = MAX(0, y - (radius1 + radius2) - 1);
   fl = MAX(0, l - (radius1 + radius2) - 1);

   tx = MIN(maxx, x + (radius1 + radius2) + 1);
   ty = MIN(maxy, y + (radius1 + radius2) + 1);
   tl = MIN(maxl, l + (radius1 + radius2) + 1);

   for (i= fx;i<tx;i++)
   {
      for(j=fy;j<ty;j++)
      {
         for(k=fl;k<tl;k++)
         {
            cur_rad = sqrt((i-x)*(i-x)+(j-y)*(j-y)+(k-l)*(k-l));
            if (cur_rad <= radius1)
                to_add = strength;
            else if (cur_rad <= radius2 + radius1)
                to_add = strength * pow(1 -   (cur_rad - radius1)/(radius2), 2);
            else
                to_add = 0;
            light[i][j][k] += to_add;
            
            light[i][j][k] = MIN(light[i][j][k],255);
            light[i][j][k] = MAX(light[i][j][k],1);
         }
      }
   }


}

void ppe_add_light(PPE_MAP  *map, double x, double y, double l, int strength, double radius1, double radius2)
{
   if (!map->light_map)
      return;

   fill_light(map->light_map, x, y, l, strength, radius1, radius2, map->w+1, map->h+1, map->l+1);
   
}

void ppe_light_border_zero(PPE_MAP *m)
{
   int i,j;

   if (!m->light_map)
      return;
      
   for (i= 0;i<m->w +1;i++)
   {
      for (j = 0; j< m->l+1;j++)
      {
         m->light_map[i][0][j] = 0;
         m->light_map[i][m->h][j] = 0;
      }

   }

   for (i= 1;i<m->h +1;i++)
   {
      for (j = 0; j< m->l;j++)
      {
         m->light_map[0][i][j] = 0;
         m->light_map[m->w][i][j] = 0;
      }

   }
}


int ppe_num_dynamic_lights = 0;
PPE_DYN_LIGHT *ppe_dynamic_lights;

static int ***alloc_light(int radius)
{
   int ***l;

   int i,j,k,m;
   int n = (2 * radius + 1);

   l = malloc(sizeof(int**) * n) ;

   if (!l)
      return NULL;

   for (i = 0; i< n;i++)
   {
      l[i] = malloc(sizeof(int *) * n);
      if (!l[i])
      {
         for (j=0;j<i;j++)
         {
            free(l[j]);
         }
         free(l);
         return NULL;
      }

      for (j=0; j< n;j++)
      {
         l[i][j] = malloc(sizeof(int) * n);
         if (!l[i][j])
         {
            for (k=0;k<j;k++)
            {
                free(l[i][k]);
            }
            free(l[i]);
            for (k=0;k<i;k++)
            {
                for (m = 0; m< n;m++)
                {
                  free(l[k][m]);
                }
                free(l[k]);
                
            }

            free(l);
            return NULL;
         }

      }
      
   }

   return l;
}

static void dealloc_light(int ***l, int radius)
{
   int i,j;
   int n = 2 * radius + 1;

   for (i=0;i<n;i++)
   {
      for(j=0;j<n;j++)
      {
         free(l[i][j]);
      }
      free(l[i]);
   }
   free(l);
}



int ppe_create_dynamic_light(int radius, int strength)
{
   PPE_DYN_LIGHT *tmp;
   
   ppe_num_dynamic_lights++;



   if (ppe_num_dynamic_lights > ppe_max_num_dynamic_lights)
   {
      ppe_max_num_dynamic_lights+=10;
      tmp = realloc(ppe_dynamic_lights, ppe_max_num_dynamic_lights * sizeof(PPE_DYN_LIGHT));
      if (!tmp)
      {
         ppe_max_num_dynamic_lights+=10;
         ppe_num_dynamic_lights--;
         return -1;
      }
      else
      {
         ppe_dynamic_lights = tmp;
      }
   }

   ppe_dynamic_lights[ppe_num_dynamic_lights - 1].data = alloc_light(radius);

   if (!ppe_dynamic_lights[ppe_num_dynamic_lights - 1].data)
   {
      ppe_num_dynamic_lights--;
      return -1;
   }

   base_light(ppe_dynamic_lights[ppe_num_dynamic_lights - 1].data,2 * radius+1, 2 * radius+1, 2 * radius+1,0);
   fill_light(ppe_dynamic_lights[ppe_num_dynamic_lights - 1].data, radius ,radius,radius , strength , 0, radius, 2 * radius+1, 2 * radius+1, 2 * radius+1);


   ppe_dynamic_lights[ppe_num_dynamic_lights - 1].on = FALSE;
   ppe_dynamic_lights[ppe_num_dynamic_lights - 1].radius = radius;

   return ppe_num_dynamic_lights - 1;
   
}



void ppe_dynamic_light_set(int light,int radius, int strength)
{
   int ***tmp;
   if (light <0 || light >= ppe_num_dynamic_lights)
       return;
   
   if (radius != ppe_dynamic_lights[light].radius)
   {
       tmp = alloc_light(radius);

       if (!tmp)
          return; /*//1  set error code*/

       dealloc_light(ppe_dynamic_lights[light].data, radius);

       ppe_dynamic_lights[light].data = tmp;
       ppe_dynamic_lights[light].radius = radius;

   }

   base_light(ppe_dynamic_lights[light].data,2 * radius+1, 2 * radius+1, 2 * radius+1,0);
   fill_light(ppe_dynamic_lights[light].data, radius ,radius,radius , strength , radius/2, radius/2, 2 * radius+1, 2 * radius+1, 2 * radius+1);

   
}

void ppe_dynamic_light_pos(int light,int x, int y, int l)
{
   if (light <0 || light >= ppe_num_dynamic_lights)
       return;
       
       ppe_dynamic_lights[light].x = x;
       ppe_dynamic_lights[light].y = y;
       ppe_dynamic_lights[light].l = l;

}

void ppe_dynamic_light_on(int light,int on)
{
   if (light <0 || light >= ppe_num_dynamic_lights)
       return;
       
       ppe_dynamic_lights[light].on = on;

}

void ppe_destroy_dynamic_lights()
{
   int i;
   for (i=0;i<ppe_num_dynamic_lights;i++)
   {
      dealloc_light(ppe_dynamic_lights[i].data, ppe_dynamic_lights[i].radius);
   }
   free(ppe_dynamic_lights);

   ppe_num_dynamic_lights = ppe_max_num_dynamic_lights = 0;
   
}

