#include <stdio.h>
#include "p_intern.h"

void ppe_exit()
{
   if (ppe_scale_table)
       free(ppe_scale_table);
   ppe_scale_table = NULL;

   ppe_cleanup_freelist();

   ppe_cleanup_scratch();
}

static void fill_scale_table()
{
   int i;
   double fact;

   /* this table yields max_size for distance 0
    * and min_size for distance building_height
    * smaller for larger distances
    */
   fact = ((double)ppe_building_height/(ppe_max_size/ppe_min_size - 1));
   for (i = 0;i < (ppe_nr_layers<<PPE_FINESHIFT);i++)
       ppe_scale_table[i] = (float)ppe_max_size / (i/ (fact * (1 << PPE_FINESHIFT)) + 1) ;

// linear table, (looks wrong)
//   for (i = 0;i < (ppe_nr_layers<<PPE_FINESHIFT);i++)
//       ppe_scale_table[i] = ppe_max_size - (ppe_max_size - ppe_min_size) * i / (ppe_building_height * (1 << PPE_FINESHIFT));

}

int ppe_init(int _tile_size, int _max_camera_height, int _max_building_height, double _max_layer_size, double _min_layer_size)
{

   ppe_tile_size = _tile_size;
   ppe_nr_layers = _max_camera_height;
   ppe_building_height = _max_building_height;
   ppe_min_size = _min_layer_size;
   ppe_max_size = _max_layer_size;
   ppe_cam_x = SCREEN_W / 2;
   ppe_cam_y = SCREEN_H / 2;
   ppe_cam_l = ppe_nr_layers - 1;

   ppe_scale_table = malloc(sizeof(double) * (ppe_nr_layers << PPE_FINESHIFT));
   if (!ppe_scale_table)
   {
      sprintf(ppe_error, "out of memory allocating scale  table of %d elements", ppe_nr_layers);
      return TRUE;
   }

   fill_scale_table(); /* uses min_size, max)size */


   return FALSE;
}


void ppe_set_camera_pos(int x, int y)
{
   ppe_cam_x = x;
   ppe_cam_y = y;
}

void ppe_set_camera_height(int layer, int fine)
{
   ppe_cam_l = layer;
   ppe_cam_lfine = fine;
   ppe_cam_l = MAX(ppe_cam_l, 0);
   ppe_cam_l = MIN(ppe_cam_l, ppe_nr_layers - 1);
}


void ppe_set_perspective(double max, double min)
{
   ppe_max_size = max;
   ppe_min_size = min;

   fill_scale_table();

}
