#include <stdlib.h>
#include <stdio.h>
#include "p_intern.h"



static PPE_LIST *freelist = NULL;
static PPE_LIST *list_last = NULL;

PPE_LIST *ppe_new_list_elem()
{
   PPE_LIST *ret;
   
   if (freelist)
   {
      ret = freelist;
      freelist = freelist->next;
      if (!freelist)
         list_last = NULL;
   }
   else
       ret = malloc(sizeof(PPE_LIST));

   return ret;
}

void ppe_free_list_elem(PPE_LIST *l)
{
   ASSERT(l);

   l->next = NULL;
   if (list_last)
   {
      list_last->next = l;
      list_last = l;
   }
   else
   { /* list empty*/
      freelist = list_last = l;
   }
}

/* l should be a valid terminated linked list*/
void ppe_free_list(PPE_LIST *l)
{
   ASSERT(l);

   if (list_last)
   {
      list_last->next = l;
   }
   else
   {
      list_last = freelist = l;
   }

   /* adjust list_last pointer*/
   while (list_last->next)
   {
//         printf("%p list_last->next->xf %d n %p\n", list_last,list_last->next->xfrom, list_last->next->next);
         list_last = list_last->next;
   }

//   printf("*******\n");

}

void ppe_cleanup_freelist()
{
   PPE_LIST *last,*i;

   last = NULL;
   for (i = freelist;i;i=i->next)
   {
//      fprintf(stderr,"i %p last %p next %p\n", i, last, i->next);
      if (last)
         free(last);
      last = i;
   }

   freelist = NULL;
   list_last = NULL;
}
