#include <math.h>
#include <stdio.h>
#include "p_intern.h"


static V3D_f v[4]; /* all drawing routines share this V3D array */

/*
static int darken(int color)

{
   return makecol(getr(color)>>1,getg(color)>>1,getb(color)>>1);
}
  */

static int ppe_calc_lights(int ***ambient, int x,int y,int l)
{
   int i;
   int ret = ambient[x][y][l];
   
   for (i=0; i<ppe_num_dynamic_lights;i++)
   {
   
      if (ppe_dynamic_lights[i].on &&
          x >= ppe_dynamic_lights[i].x - ppe_dynamic_lights[i].radius &&
          x <= ppe_dynamic_lights[i].x + ppe_dynamic_lights[i].radius &&
          y >= ppe_dynamic_lights[i].y - ppe_dynamic_lights[i].radius &&
          y <= ppe_dynamic_lights[i].y + ppe_dynamic_lights[i].radius &&
          l >= ppe_dynamic_lights[i].l - ppe_dynamic_lights[i].radius &&
          l <= ppe_dynamic_lights[i].l + ppe_dynamic_lights[i].radius)
      {
         ret += ppe_dynamic_lights[i].data[x - ppe_dynamic_lights[i].x + ppe_dynamic_lights[i].radius]
                                          [y - ppe_dynamic_lights[i].y + ppe_dynamic_lights[i].radius]
                                          [l -ppe_dynamic_lights[i].l + ppe_dynamic_lights[i].radius];
      }
   }
   return MAX(MIN(ret, 255),0);
   
}

void ppe_rect_arcd(BITMAP *onto, int x1, int y1, int x2, int y2, int color, int distrib, int facing)
{
   int x,y;
   double stepsize = 10;
   double distchange = .9;
   double i;
   rect(onto, x1,y1,x2,y2,color);

   if (!distrib)
   {
      for (y=y1; y<y2;y++)
        for (x=x1; x<x2; x+=8)
          if (x + (y % 8) < x2)
             putpixel(onto, x + (y % 8),y, color);
   }
   else
   {
      switch(facing)
      {
         case PPE_N:
          for (i = y1; i<y2;i+=stepsize)
          {
            hline(onto, x1, i, x2, color);
            stepsize *= distchange;
            stepsize = MAX(stepsize, 2);
          }
          break;
         case PPE_S:
          for (i = y2; i>y1;i-=stepsize)
          {
            hline(onto, x1, i, x2, color);
            stepsize *= distchange;
            stepsize = MAX(stepsize, 2);
          }
          break;
         case PPE_W:
          for (i = x1; i<x2;i+=stepsize)
          {
            vline(onto, i, y1, y2, color);
            stepsize *= distchange;
            stepsize = MAX(stepsize, 2);
          }
          break;
         case PPE_E:
          for (i = x2; i>x1;i-=stepsize)
          {
            vline(onto, i, y1, y2, color);
            stepsize *= distchange;
            stepsize = MAX(stepsize, 2);
          }
          break;
      }

   }
   
}

/* draws a striped triangle , the stripes are parrallel  to the base between p1,p3
 * as long as p1,p2 is as long as p2,p3, if these lengths are different it will
 * skew a bit
 * if distrib is <0 then the stipes will be closer together at the base
 * if distrib > 0 then the stripes will be closer together at the top
 */
void ppe_triangle_arcd(BITMAP *onto, int x1, int y1, int x2, int y2, int x3, int y3, int color, int distrib)
{
   int h;
   double stepsize = 10;
   double distchange = .8;
   double i;

   /* get approx triangle height */

   h = sqrt(((x1 + x3) / 2 - x2) * ((x1 + x3) / 2 - x2) + ((y1 + y3) / 2 - y2) * ((y1 + y3) / 2 - y2));

   /* draw the thing */

   for (i = 0.0; i< h;i +=stepsize)
   {
      if (distrib >=0) /* draw bottum up */
      {
         line (onto, x1 + ( x2 - x1) * i / h, y1 + ( y2 - y1) * i / h,
                     x3 + ( x2 - x3) * i / h, y3 + ( y2 - y3) * i / h, color);
      }
      else /* draw top down */
      {
         line (onto, x2 + ( x1 - x2) * i / h, y2 + ( y1 - y2) * i / h,
                     x2 + ( x3 - x2) * i / h, y2 + ( y3 - y2) * i / h, color);
      }
      if (distrib)
         stepsize *= distchange;

      stepsize = MAX(stepsize, 2);
   }
   line (onto, x1, y1, x2, y2, color);
   line (onto, x2, y2, x3, y3, color);
   line (onto, x1, y1, x3, y3, color);

}


void ppe_quad(BITMAP *onto, int x0, int y0, int x1, int y1,int x2, int y2, int x3, int y3, int color)
{
   triangle(onto,x0,y0,x1,y1,x2,y2, color);
   triangle(onto,x2,y2,x3,y3,x0,y0, color);
}

void ppe_rotate_lit_sprite(int layer, int fine_layer, int x, int y, fixed angle,  PPE_TEX *sprite, BITMAP *onto, int animation_offset, int lx, int ly, int ***light_map)
{
   int ldist = ppe_cam_l - layer;
   int fdist = ppe_cam_lfine - fine_layer;

   double scale = PPE_SCALE(ldist, fdist);
   BITMAP *b = ppe_texture_get_bitmap(sprite, scale, animation_offset);
   BITMAP *scratch;
   int xf = (int)((x - ppe_cam_x ) * scale + ppe_cam_x + .5);
   int yf = (int)((y - ppe_cam_y ) * scale + ppe_cam_y + .5);
   int s_size = MAX(b->w * scale, b->h * scale);
   int xt = (int)((x - ppe_cam_x ) * scale + ppe_cam_x + .5 + b->w * scale);
   int yt = (int)((y - ppe_cam_y ) * scale + ppe_cam_y + b->h * scale + .5);

//   printf("draw _sprite %d %d \n",x,y);
   scratch = ppe_scratch_bitmap(s_size, s_size);

   rectfill(scratch,0,0,s_size,s_size, bitmap_mask_color(scratch));
   rotate_scaled_sprite(scratch,  b, 0, 0, angle, ftofix(scale));

   v[0].x = xf;
   v[0].y = yf;
   v[1].x = xt;
   v[1].y = yf;
   v[2].x = xt;
   v[2].y = yt;
   v[3].x = xf;
   v[3].y = yt;

   /* setup texture */
   v[0].u = 0;
   v[0].v = 0;
   v[1].u = xt - xf;
   v[1].v = 0;
   v[2].u = xt - xf;
   v[2].v = yt - yf;
   v[3].u = 0;
   v[3].v = yt - yf;

   v[0].c = ppe_calc_lights(light_map,lx,ly,layer);
   v[1].c = ppe_calc_lights(light_map,lx+1,ly,layer);
   v[2].c = ppe_calc_lights(light_map,lx+1,ly+1,layer);
   v[3].c = ppe_calc_lights(light_map,lx,ly+1,layer);
   quad3d_f(onto, POLYTYPE_ATEX_MASK_LIT, scratch, v, v+1, v+2, v+3);
   
}

void ppe_rotate_sprite(int layer, int fine_layer, double x, double y, fixed angle,  PPE_TEX *sprite, BITMAP *onto, int animation_offset)
{
   int ldist = ppe_cam_l - layer;
   int fdist = ppe_cam_lfine - fine_layer;

   double scale = PPE_SCALE(ldist, fdist);
   BITMAP *b = ppe_texture_get_bitmap(sprite, scale, animation_offset);


   int xf = (int)((x - ppe_cam_x ) * scale + ppe_cam_x + .5);
   int yf = (int)((y - ppe_cam_y ) * scale + ppe_cam_y + .5);
//   int xt = (int)((x - ppe_cam_x ) * scale + ppe_cam_x + .5 + b->w * scale);
//   int yt = (int)((y - ppe_cam_y ) * scale + ppe_cam_y + b->h * scale + .5);

//   printf("draw _sprite %d %d \n",x,y);
   
   rotate_scaled_sprite(onto,  b, xf, yf, angle, ftofix(scale));
}


void ppe_draw_tile(int layer, double x, double y,  PPE_TEX *tile, BITMAP *onto, int animation_offset)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(tile, scale, animation_offset);

   int xf = (int)((x - ppe_cam_x) * scale + ppe_cam_x + .5);
   int yf = (int)((y - ppe_cam_y) * scale + ppe_cam_y + .5);
   int xt = (int)((x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size * scale + .5);
   int yt = (int)((y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size * scale + .5);
   


   stretch_sprite(onto, b,
                      xf,
                      yf,
                      xt - xf,
                      yt - yf);

}

void ppe_draw_lit_tile(int layer, double x, double y,  PPE_TEX *tile, BITMAP *onto, int animation_offset, int lx, int ly , int ***light_map)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(tile, scale, animation_offset);
   BITMAP *scratch;

   int xf = (int)((x - ppe_cam_x) * scale + ppe_cam_x + .5);
   int yf = (int)((y - ppe_cam_y) * scale + ppe_cam_y + .5);
   int xt = (int)((x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size * scale + .5);
   int yt = (int)((y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size * scale + .5);
   

   scratch = ppe_scratch_bitmap(xt - xf, yt - yf);

//   clear_to_color(scratch, bitmap_mask_color(scratch));
                                         
   stretch_blit(b, scratch, 0, 0, b->w, b->h,
                      0,
                      0,
                      xt - xf,
                      yt - yf);

   v[0].x = xf;
   v[0].y = yf;
   v[1].x = xt;
   v[1].y = yf;
   v[2].x = xt;
   v[2].y = yt;
   v[3].x = xf;
   v[3].y = yt;

   /* setup texture */
   v[0].u = 0;
   v[0].v = 0;
   v[1].u = xt - xf;
   v[1].v = 0;
   v[2].u = xt - xf;
   v[2].v = yt - yf;
   v[3].u = 0;
   v[3].v = yt - yf;


   v[0].c = ppe_calc_lights(light_map,lx,ly,layer);
   v[1].c = ppe_calc_lights(light_map,lx+1,ly,layer);
   v[2].c = ppe_calc_lights(light_map,lx+1,ly+1,layer);
   v[3].c = ppe_calc_lights(light_map,lx,ly+1,layer);
   
   quad3d_f(onto, POLYTYPE_ATEX_MASK_LIT, scratch, v, v+1, v+2, v+3);
   

}





void ppe_draw_tile_schematic(int layer, double x, double y,  PPE_TEX *tile, BITMAP *onto)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);



   ppe_rect_arcd(onto, (x - ppe_cam_x) * scale + ppe_cam_x,
                   (y - ppe_cam_y) * scale + ppe_cam_y,
                   (x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size  * scale,
                   (y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size  * scale,
                   makecol(0,0,255), FALSE, 0);
   

}

void ppe_draw_tile_solid(int layer, double x, double y,  PPE_TEX *tile, BITMAP *onto, int color)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);


   if (color <0)
      color = tile->mean_color;

   if (color<0)
      color = makecol(128,128,128);

   rectfill(onto, (x - ppe_cam_x) * scale + ppe_cam_x,
                   (y - ppe_cam_y) * scale + ppe_cam_y,
                   (x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size  * scale - 1,
                   (y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size  * scale - 1,
                   color
                   );
   

}


void ppe_draw_empty_tile(int layer, double x, double y, BITMAP *onto, int color)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);

                     
   rectfill(onto, (x - ppe_cam_x) * scale + ppe_cam_x,
                   (y - ppe_cam_y) * scale + ppe_cam_y,
                   (x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size  * scale - .5 ,
                   (y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size  * scale - .5,
                   color);
   
}

void ppe_draw_empty_tile_schematic(int layer, double x, double y, BITMAP *onto, int color)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);



   rect(onto, (x - ppe_cam_x) * scale + ppe_cam_x,
                   (y - ppe_cam_y) * scale + ppe_cam_y,
                   (x - ppe_cam_x) * scale + ppe_cam_x + ppe_tile_size  * scale,
                   (y - ppe_cam_y) * scale + ppe_cam_y + ppe_tile_size  * scale,
                   color);
   
}

void ppe_draw_arced_region(int layer, double xf, double yf, double xt, double yt, BITMAP *onto, int color)
{
   double scale = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);



   ppe_rect_arcd(onto, (xf - ppe_cam_x) * scale + ppe_cam_x,
                   (yf - ppe_cam_y) * scale + ppe_cam_y,
                   (xt - ppe_cam_x) * scale + ppe_cam_x,
                   (yt - ppe_cam_y) * scale + ppe_cam_y,
                   color,0,0);
   
}


void ppe_draw_wall(int face, int layer, double fx, double fy, double tx, double ty, int *xtex, int * ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(texture, scale_bot, animation_offset);
   
   int bfx = (int)((fx - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bfy = (int)((fy - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int btx = (int)((tx - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bty = (int)((ty - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int tfx = (int)((fx - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tfy = (int)((fy - ppe_cam_y) * scale_top + ppe_cam_y + .5);
   int ttx = (int)((tx - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tty = (int)((ty - ppe_cam_y) * scale_top + ppe_cam_y + .5);

   /* do some simple backface culling */
   if ((face == PPE_N ) && (tfy <= bfy))
      return;

   if ((face == PPE_S ) && (tfy >= bfy))
      return;

   if ((face == PPE_W) && (tfx <= bfx))
      return;

   if ((face == PPE_E) && (tfx >= bfx))
      return;

   if ((face == PPE_NW) && ((tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((face == PPE_SW) && ((tfx - bfx) - (tfy - bfy) < 0))
      return;

   if ((face == PPE_NE) && (-(tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((face == PPE_SE) && (-(tfx - bfx) - (tfy - bfy) < 0))
      return;


   v[0].x = tfx;
   v[0].y = tfy;
   v[1].x = ttx;
   v[1].y = tty;
   v[2].x = btx;
   v[2].y = bty;
   v[3].x = bfx;
   v[3].y = bfy;

   /* setup texture */
   v[0].u = xtex[0];
   v[0].v = ytex[0];
   v[1].u = xtex[1];
   v[1].v = ytex[1];
   v[2].u = xtex[2];
   v[2].v = ytex[2];
   v[3].u = xtex[3];
   v[3].v = ytex[3];

//   printf("%g %g  %g %g %g %g  %g %g\n", v[0].x, v[0].y, v[1].x, v[1].y, v[2].x, v[2].y, v[3].x, v[3].y);

   quad3d_f(onto, ppe_polytype, b, v, v+1, v+2, v+3);

}

void ppe_draw_lit_wall(int face, int layer, double fx, double fy, double tx, double ty, int *xtex, int * ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset,int lx, int ly, int ***light_map)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(texture, scale_bot, animation_offset);
   
   int bfx = (int)((fx - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bfy = (int)((fy - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int btx = (int)((tx - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bty = (int)((ty - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int tfx = (int)((fx - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tfy = (int)((fy - ppe_cam_y) * scale_top + ppe_cam_y + .5);
   int ttx = (int)((tx - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tty = (int)((ty - ppe_cam_y) * scale_top + ppe_cam_y + .5);

   /* do some simple backface culling */
   if ((face == PPE_N ) && (tfy <= bfy))
      return;

   if ((face == PPE_S ) && (tfy >= bfy))
      return;

   if ((face == PPE_W) && (tfx <= bfx))
      return;

   if ((face == PPE_E) && (tfx >= bfx))
      return;

   if ((face == PPE_NW) && ((tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((face == PPE_SW) && ((tfx - bfx) - (tfy - bfy) < 0))
      return;

   if ((face == PPE_NE) && (-(tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((face == PPE_SE) && (-(tfx - bfx) - (tfy - bfy) < 0))
      return;


   v[0].x = tfx;
   v[0].y = tfy;
   v[1].x = ttx;
   v[1].y = tty;
   v[2].x = btx;
   v[2].y = bty;
   v[3].x = bfx;
   v[3].y = bfy;

   /* setup texture */
   v[0].u = xtex[0];
   v[0].v = ytex[0];
   v[1].u = xtex[1];
   v[1].v = ytex[1];
   v[2].u = xtex[2];
   v[2].v = ytex[2];
   v[3].u = xtex[3];
   v[3].v = ytex[3];

   /* setup light */
   switch(face)
   {
    case PPE_S:
     v[0].c = ppe_calc_lights(light_map,lx,ly+1,layer+1);
     v[1].c = ppe_calc_lights(light_map,lx+1,ly+1,layer+1);
     v[2].c = ppe_calc_lights(light_map+1,lx,ly+1,layer);
     v[3].c = ppe_calc_lights(light_map,lx,ly+1,layer);
     break;
    case PPE_N:
     v[0].c = ppe_calc_lights(light_map,lx+1,ly,layer+1);
     v[1].c = ppe_calc_lights(light_map,lx,ly,layer+1);
     v[2].c = ppe_calc_lights(light_map,lx,ly,layer);
     v[3].c = ppe_calc_lights(light_map,lx+1,ly,layer);
     break;
    case PPE_W:
     v[0].c = ppe_calc_lights(light_map,lx,ly,layer+1);
     v[1].c = ppe_calc_lights(light_map,lx,ly+1,layer+1);
     v[2].c = ppe_calc_lights(light_map,lx,ly+1,layer);
     v[3].c = ppe_calc_lights(light_map,lx,ly,layer);
     break;
    case PPE_E:
     v[0].c = ppe_calc_lights(light_map,lx+1,ly+1,layer+1);
     v[1].c = ppe_calc_lights(light_map,lx+1,ly,layer+1);
     v[2].c = ppe_calc_lights(light_map,lx+1,ly,layer);
     v[3].c = ppe_calc_lights(light_map,lx+1,ly+1,layer);
     break;
   }

//   printf("%g %g  %g %g %g %g  %g %g\n", v[0].x, v[0].y, v[1].x, v[1].y, v[2].x, v[2].y, v[3].x, v[3].y);

   quad3d_f(onto, POLYTYPE_ATEX_MASK_LIT, b, v, v+1, v+2, v+3);

}


/* draws a schematic representation of the wall
 * wireframe toggles wireframe drawing
 * symbolic toggles symbolic drawing of the wall
 * solid toggles solid drawing of the wall
 *  if scolor < 0 then the mean_color of the texture is used for solid drawing
 */
void ppe_draw_wall_schematic(int face, int layer, double fx, double fy, double tx, double ty, int *xtex, int * ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   
   int cull = FALSE;
   int color = makecol(255,0,0);
   int bfx = (fx - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bfy = (fy - ppe_cam_y) * scale_bot + ppe_cam_y;
   int btx = (tx - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bty = (ty - ppe_cam_y) * scale_bot + ppe_cam_y;
   int tfx = (fx - ppe_cam_x) * scale_top + ppe_cam_x;
   int tfy = (fy - ppe_cam_y) * scale_top + ppe_cam_y;
   int ttx = (tx - ppe_cam_x) * scale_top + ppe_cam_x;
   int tty = (ty - ppe_cam_y) * scale_top + ppe_cam_y;
   int thickness = (int)(scale_bot * ppe_tile_size/8);

   /* do some simple backface culling */
   if ((face == PPE_N ) && (tfy <= bfy))
      cull = TRUE;
   if ((face == PPE_S ) && (tfy >= bfy))
      cull = TRUE;;

   if ((face == PPE_W) && (tfx <= bfx))
      cull = TRUE;;

   if ((face == PPE_E) && (tfx >= bfx))
      cull = TRUE;;

   if ((face == PPE_NW) && ((tfx - bfx) + (tfy - bfy) < 0))
      cull = TRUE;;

   if ((face == PPE_SW) && ((tfx - bfx) - (tfy - bfy) < 0))
      cull = TRUE;;

   if ((face == PPE_NE) && (-(tfx - bfx) + (tfy - bfy) < 0))
      cull = TRUE;;

   if ((face == PPE_SE) && (-(tfx - bfx) - (tfy - bfy) < 0))
      cull = TRUE;;

   if (symbolic)
   {
      switch(face)
      {
         case PPE_N:
          rectfill(onto, bfx, bfy, btx, bty + thickness, color);
          break;
         case PPE_W:
          rectfill(onto, bfx, bfy, btx + thickness, bty, color);
          break;
         case PPE_S:
          rectfill(onto, bfx, bfy, btx, bty - thickness, color);
          break;
         case PPE_E:
          rectfill(onto, bfx, bfy, btx - thickness, bty, color);
          break;
         case PPE_NW:
          ppe_quad(onto, bfx, bfy, btx, bty, btx + thickness, bty, bfx, bfy  + thickness, color);
          break;
         case PPE_SW:
          ppe_quad(onto, bfx, bfy, btx, bty, btx,  bty - thickness, bfx + thickness, bfy, color);
          break;
         case PPE_SE:
          ppe_quad(onto, bfx, bfy, btx, bty, btx - thickness,  bty,  bfx , bfy - thickness, color);
          break;
         case PPE_NE:
          ppe_quad(onto, bfx, bfy, btx, bty, btx ,  bty + thickness,  bfx - thickness, bfy , color);
          break;
      }
   }
   if (cull)
      color = makecol(100,0,0);

   if (solid && !cull)
   {
      if (scolor <0)
         scolor = texture->mean_color;

      if (scolor <0)
         scolor = color;

      triangle(onto, bfx, bfy, btx, bty, ttx, tty, scolor);
      triangle(onto, bfx, bfy, tfx, tfy, ttx, tty, scolor);

   }

   if (wireframe && !(cull && solid))
   {
//      if (solid)
//         color = darken(scolor);
      line(onto, bfx, bfy, btx, bty, color);
      line(onto, btx, bty, ttx, tty, color);
      line(onto, ttx, tty, tfx, tfy, color);
      line(onto, tfx, tfy, bfx, bfy, color);
   }
   
}




static void draw_diagonal_slope(int facing, int type, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(texture, scale_bot, animation_offset);

   if (type == CORNER_LOW)
   {
      v[0].x = (int)((xf - ppe_cam_x) * scale_top + ppe_cam_x + .5);
      v[0].y = (int)((yf - ppe_cam_y) * scale_top + ppe_cam_y + .5);
      v[1].x = (int)((xt - ppe_cam_x) * scale_top + ppe_cam_x + .5);
      v[1].y = (int)((yt - ppe_cam_y) * scale_top + ppe_cam_y + .5);
      if (facing == PPE_NE || facing == PPE_SW)
      {
         v[2].x = (int)((xf - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
         v[2].y = (int)((yt - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
      }
      else
      {
         v[2].x = (int)((xt - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
         v[2].y = (int)((yf - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
      }
      
      if ((facing == PPE_NW) && (v[2].y >= v[0].y - (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_NE) && (v[2].y >= v[0].y + (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_SW) && (v[2].y <= v[0].y + (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_SE) && (v[2].y <= v[0].y - (v[2].x - v[0].x) ))
         return;


   }
   else
   {


      v[0].x = (int)((xf - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
      v[0].y = (int)((yf - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
      v[1].x = (int)((xt - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
      v[1].y = (int)((yt - ppe_cam_y) * scale_bot + ppe_cam_y + .5);

      if (facing == PPE_NW || facing == PPE_SE)
      {
         v[2].x = (int)((xf - ppe_cam_x) * scale_top + ppe_cam_x + .5);
         v[2].y = (int)((yt - ppe_cam_y) * scale_top + ppe_cam_y + .5);
      }
      else
      {
         v[2].x = (int)((xt - ppe_cam_x) * scale_top + ppe_cam_x + .5);
         v[2].y = (int)((yf - ppe_cam_y) * scale_top + ppe_cam_y + .5);
      }

      if ((facing == PPE_SE) && (v[2].y >= v[0].y - (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_SW) && (v[2].y >= v[0].y + (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_NE) && (v[2].y <= v[0].y + (v[2].x - v[0].x) ))
         return;
         
      if ((facing == PPE_NW) && (v[2].y <= v[0].y - (v[2].x - v[0].x) ))
         return;


   }
   v[0].u = xtex[0];
   v[0].v = ytex[0];
   v[1].u = xtex[1];
   v[1].v = ytex[1];
   v[2].u = xtex[2];
   v[2].v = ytex[2];
   
   triangle3d_f(onto, ppe_polytype, b, v, v+1, v+2);
}

static void draw_simple_slope(int facing, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(texture, scale_bot, animation_offset);
   
   int bfx = (int)((xf - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bfy = (int)((yf - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int btx = (int)((xt - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bty = (int)((yt - ppe_cam_y) * scale_bot + ppe_cam_y + .5);



   switch(facing)
   {
      case PPE_N:
       v[0].x = (int)((xf - ppe_cam_x) * scale_top + ppe_cam_x  + .5);
       v[0].y = (int)((yf + ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       v[1].x = (int)((xt - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[1].y = (int)((yt + ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       break;
      case PPE_E:
       v[0].x = (int)((xf - ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[0].y = (int)((yf - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       v[1].x = (int)((xt - ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[1].y = (int)((yt - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       break;
      case PPE_W:
       v[0].x = (int)((xf + ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[0].y = (int)((yf - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       v[1].x = (int)((xt + ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[1].y = (int)((yt - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       break;
      case PPE_S:
       v[0].x = (int)((xf - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[0].y = (int)((yf - ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       v[1].x = (int)((xt - ppe_cam_x) * scale_top + ppe_cam_x + .5);
       v[1].y = (int)((yt - ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y + .5);
       break;
      default:
        return;
   }
   v[2].x = btx;
   v[2].y = bty;
   v[3].x = bfx;
   v[3].y = bfy;

   if ((facing == PPE_N) && (v[3].y >= v[0].y))
         return;

   if ((facing == PPE_S) && (v[3].y <= v[0].y))
         return;

   if ((facing == PPE_E) && (v[3].x <= v[0].x))
         return;

   if ((facing == PPE_W) && (v[3].x >= v[0].x))
         return;


   /* setup texture */
   v[0].u = xtex[0];
   v[0].v = ytex[0];
   v[1].u = xtex[1];
   v[1].v = ytex[1];
   v[2].u = xtex[2];
   v[2].v = ytex[2];
   v[3].u = xtex[3];
   v[3].v = ytex[3];


   quad3d_f(onto, ppe_polytype, b, v, v+1, v+2, v+3);
   
}











void ppe_draw_slope(int facing, int type, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset)
{
   if (facing == PPE_NE || facing == PPE_NW || facing == PPE_SE || facing == PPE_SW)
       draw_diagonal_slope(facing, type, layer, xf,yf,xt,yt, xtex, ytex, texture, onto, animation_offset);
   else
       draw_simple_slope(facing,layer , xf,yf,xt,yt, xtex, ytex, texture, onto, animation_offset);

}



static void draw_diagonal_slope_schematic(int facing, int type, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   int cull = FALSE;
   int color = makecol(255,0,100);
   int v2x, v2y;

   if (type == CORNER_LOW)
   {
      v[0].x = (xf - ppe_cam_x) * scale_top + ppe_cam_x;
      v[0].y = (yf - ppe_cam_y) * scale_top + ppe_cam_y;
      v[1].x = (xt - ppe_cam_x) * scale_top + ppe_cam_x;
      v[1].y = (yt - ppe_cam_y) * scale_top + ppe_cam_y;
      if (facing == PPE_NE || facing == PPE_SW)
      {
         v[2].x = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
         v[2].y = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
      }
      else
      {
         v[2].x = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
         v[2].y = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;
      }
      
      if ((facing == PPE_NW) && (v[2].y >= v[0].y - (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_NE) && (v[2].y >= v[0].y + (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_SW) && (v[2].y <= v[0].y + (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_SE) && (v[2].y <= v[0].y - (v[2].x - v[0].x) ))
         cull = TRUE;


   }
   else
   {


      v[0].x = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
      v[0].y = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
      v[1].x = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
      v[1].y = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;



      if (facing == PPE_NW || facing == PPE_SE)
      {
         v[2].x = (xf - ppe_cam_x) * scale_top + ppe_cam_x;
         v[2].y = (yt - ppe_cam_y) * scale_top + ppe_cam_y;
      }
      else
      {
         v[2].x = (xt - ppe_cam_x) * scale_top + ppe_cam_x;
         v[2].y = (yf - ppe_cam_y) * scale_top + ppe_cam_y;
      }

      if ((facing == PPE_SE) && (v[2].y >= v[0].y - (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_SW) && (v[2].y >= v[0].y + (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_NE) && (v[2].y <= v[0].y + (v[2].x - v[0].x) ))
         cull = TRUE;
         
      if ((facing == PPE_NW) && (v[2].y <= v[0].y - (v[2].x - v[0].x) ))
         cull = TRUE;


   }

   if (symbolic)
   {
      if (type == CORNER_LOW)
      {
         if (facing == PPE_NE || facing == PPE_SW)
         {
            v2x = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
            v2y = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
         }
         else
         {
            v2x = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
            v2y = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;
         }
         ppe_triangle_arcd(onto, v[0].x, v[0].y, v2x, v2y, v[1].x, v[1].y, color, -1);
      }
      else
      {
         if (facing == PPE_NW || facing == PPE_SE)
         {
            v2x = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
            v2y = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;
         }
         else
         {
            v2x = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
            v2y = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
         }
         ppe_triangle_arcd(onto, v[0].x, v[0].y, v2x, v2y, v[1].x, v[1].y, color, 1);
      }
   }


   if (cull)
      color = makecol(100, 0, 50);

   if (solid && !cull)
   {
      if (scolor <0)
          scolor = texture->mean_color;

      if (scolor <0)
         scolor = color;

      triangle(onto, v[0].x, v[0].y, v[1].x, v[1].y, v[2].x, v[2].y, scolor);
   }

   if (wireframe && !(cull && solid))
   {
//      if (solid)
//         color = darken(scolor);
      line(onto, v[0].x, v[0].y, v[1].x, v[1].y, color);
      line(onto, v[1].x, v[1].y, v[2].x, v[2].y, color);
      line(onto, v[2].x, v[2].y, v[0].x, v[0].y, color);
   }


}

static void draw_simple_slope_schematic(int facing, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   int cull = FALSE;
   int color = makecol(255,0,100);
   
   int bfx = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bfy = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
   int btx = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bty = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;
   int ox = 0,oy = 0;



   switch(facing)
   {
      case PPE_N:
       v[0].x = (xf - ppe_cam_x) * scale_top + ppe_cam_x;
       v[0].y = (yf + ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y;
       v[1].x = (xt - ppe_cam_x) * scale_top + ppe_cam_x;
       v[1].y = (yt + ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y;
       ox = btx;
       oy = bfy;
       break;
      case PPE_E:
       v[0].x = (xf - ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x;
       v[0].y = (yf - ppe_cam_y) * scale_top + ppe_cam_y;
       v[1].x = (xt - ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x;
       v[1].y = (yt - ppe_cam_y) * scale_top + ppe_cam_y;
       ox = btx - ppe_tile_size * scale_bot;
       oy = bty;
       break;
      case PPE_W:
       v[0].x = (xf + ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x;
       v[0].y = (yf - ppe_cam_y) * scale_top + ppe_cam_y;
       v[1].x = (xt + ppe_tile_size - ppe_cam_x) * scale_top + ppe_cam_x;
       v[1].y = (yt - ppe_cam_y) * scale_top + ppe_cam_y;
       ox = bfx;
       oy = bfy;
       break;
      case PPE_S:
       v[0].x = (xf - ppe_cam_x) * scale_top + ppe_cam_x;
       v[0].y = (yf - ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y;
       v[1].x = (xt - ppe_cam_x) * scale_top + ppe_cam_x;
       v[1].y = (yt - ppe_tile_size - ppe_cam_y) * scale_top + ppe_cam_y;
       ox = bfx;
       oy = bfy - ppe_tile_size * scale_bot;
       break;
      default:
        return;
   }
   v[2].x = btx;
   v[2].y = bty;
   v[3].x = bfx;
   v[3].y = bfy;

   if ((facing == PPE_N) && (v[3].y >= v[0].y))
         cull = TRUE;

   if ((facing == PPE_S) && (v[3].y <= v[0].y))
         cull = TRUE;

   if ((facing == PPE_E) && (v[3].x <= v[0].x))
         cull = TRUE;

   if ((facing == PPE_W) && (v[3].x >= v[0].x))
         cull = TRUE;

   if (symbolic)
      ppe_rect_arcd(onto, ox, oy, ox + ppe_tile_size * scale_bot, oy + ppe_tile_size * scale_bot, color, TRUE, facing);

   if (cull)
      color = makecol(100,0,50);


   if (solid && !cull)
   {
      if (scolor <0)
          scolor = texture->mean_color;

      if (scolor <0)
         scolor = color;

      triangle(onto, v[0].x, v[0].y, v[1].x, v[1].y, v[2].x, v[2].y, scolor);
      triangle(onto, v[0].x, v[0].y, v[3].x, v[3].y, v[2].x, v[2].y, scolor);
   
   }

   if (wireframe && !(cull && solid))
   {
//      if (solid)
//         color = darken(scolor);
      line(onto, v[0].x, v[0].y, v[1].x, v[1].y, color);
      line(onto, v[1].x, v[1].y, v[2].x, v[2].y, color);
      line(onto, v[2].x, v[2].y, v[3].x, v[3].y, color);
      line(onto, v[0].x, v[0].y, v[3].x, v[3].y, color);
   }
   
   
}



void ppe_draw_slope_schematic(int facing, int type, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor)
{

   if (facing == PPE_NE || facing == PPE_NW || facing == PPE_SE || facing == PPE_SW)
       draw_diagonal_slope_schematic(facing, type, layer, xf,yf,xt,yt, xtex, ytex, texture, onto, wireframe, symbolic, solid, scolor);
   else
       draw_simple_slope_schematic(facing,layer , xf,yf,xt,yt, xtex, ytex, texture, onto, wireframe, symbolic, solid, scolor);
       
}


/* draw triangular wall parts or slope parts
 * facing = N,NE, E etc.
 * type = LR, LL, UR, UL
 * slope = TRUE/FALSE
 */
 
void ppe_draw_triangle(int facing, int type, int slope,
                           int layer,
                           double xf, double yf,
                           double xt, double yt,
                           int *xtex, int *ytex, PPE_TEX *texture,
                           BITMAP *onto, int animation_offset)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   BITMAP *b = ppe_texture_get_bitmap(texture, scale_bot, animation_offset);
   
   int top_tile_size = (int)(ppe_tile_size * scale_top + .5);
   int bfx = (int)((xf - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bfy = (int)((yf - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int btx = (int)((xt - ppe_cam_x) * scale_bot + ppe_cam_x + .5);
   int bty = (int)((yt - ppe_cam_y) * scale_bot + ppe_cam_y + .5);
   int tfx = (int)((xf - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tfy = (int)((yf - ppe_cam_y) * scale_top + ppe_cam_y + .5);
   int ttx = (int)((xt - ppe_cam_x) * scale_top + ppe_cam_x + .5);
   int tty = (int)((yt - ppe_cam_y) * scale_top + ppe_cam_y + .5);


   if (slope)
   {
      switch(facing)
      {
         case PPE_N:
           tfy += top_tile_size;
           tty += top_tile_size;
           break;
         case PPE_E:
           tfx -= top_tile_size;
           ttx -= top_tile_size;
           break;
         case PPE_S:
           tfy -= top_tile_size;
           tty -= top_tile_size;
          break;
         case PPE_W:
           tfx += top_tile_size;
           ttx += top_tile_size;
          break;
      }
   }



   if  (type == PPE_LL || type == PPE_LR)
   {
      v[1].x = bfx;
      v[1].y = bfy;
      v[1].u = xtex[3];
      v[1].v = ytex[3];
      v[2].x = btx;
      v[2].y = bty;
      v[2].u = xtex[2];
      v[2].v = ytex[2];
      if (type == PPE_LL)
      {
        v[0].x = tfx;
        v[0].y = tfy;
        v[0].u = xtex[0];
        v[0].v = ytex[0];
      }
      else /* type == LR */
      {
        v[0].x = ttx;
        v[0].y = tty;
        v[0].u = xtex[1];
        v[0].v = ytex[1];
      }


   }
   else /* type == UR || type == UL */
   {
      if (type == PPE_UL)
      {
         v[1].x = bfx;
         v[1].y = bfy;
         v[1].u = xtex[2];
         v[1].v = ytex[2];
      }
      else /* type == UR */
      {
         v[1].x = btx;
         v[1].y = bty;
         v[1].u = xtex[3];
         v[1].v = ytex[3];
      }
      
      v[2].x = ttx;
      v[2].y = tty;
      v[2].u = xtex[1];
      v[2].v = ytex[1];
      v[0].x = tfx;
      v[0].y = tfy;
      v[0].u = xtex[0];
      v[0].v = ytex[0];

   }



   /* do some simple backface culling */

   if ((facing == PPE_N ) && (tfy <= bfy))
      return;

   if ((facing == PPE_S ) && (tfy >= bfy))
      return;

   if ((facing == PPE_W) && (tfx <= bfx))
      return;

   if ((facing == PPE_E) && (tfx >= bfx))
      return;
      
   if ((facing == PPE_NW) && ((tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((facing == PPE_SW) && ((tfx - bfx) - (tfy - bfy) < 0))
      return;

   if ((facing == PPE_NE) && (-(tfx - bfx) + (tfy - bfy) < 0))
      return;

   if ((facing == PPE_SE) && (-(tfx - bfx) - (tfy - bfy) < 0))
      return;



   triangle3d_f(onto, ppe_polytype, b, v, v+1, v+2);

}

void ppe_draw_triangle_schematic(int facing, int type, int slope,
                           int layer,
                           double xf, double yf,
                           double xt, double yt,
                           int *xtex, int *ytex, PPE_TEX *texture,
                           BITMAP *onto, int wireframe, int symbolic, int solid, int scolor)
{
   double scale_bot = PPE_SCALE(ppe_cam_l - layer, ppe_cam_lfine);
   double scale_top = PPE_SCALE(ppe_cam_l - layer - 1,ppe_cam_lfine);
   int cull = FALSE;
   int color =  makecol(0, 255,0);
   int top_tile_size = (int)(ppe_tile_size * scale_top);
   int bfx = (xf - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bfy = (yf - ppe_cam_y) * scale_bot + ppe_cam_y;
   int btx = (xt - ppe_cam_x) * scale_bot + ppe_cam_x;
   int bty = (yt - ppe_cam_y) * scale_bot + ppe_cam_y;
   int tfx = (xf - ppe_cam_x) * scale_top + ppe_cam_x;
   int tfy = (yf - ppe_cam_y) * scale_top + ppe_cam_y;
   int ttx = (xt - ppe_cam_x) * scale_top + ppe_cam_x;
   int tty = (yt - ppe_cam_y) * scale_top + ppe_cam_y;
   int sx2 = 0,sx3 = 0;
   int sy2 = 0,sy3 = 0;
   int thickness = (int)(scale_bot * ppe_tile_size/8);


   if (symbolic && !slope)
   {
      switch(facing)
      {
         case PPE_N:
          sx3 = bfx;
          sx2 = bfx;
          sy2 = sy3 = bty + thickness;
          break;
         case PPE_W:
          sx2 = sx3 = btx + thickness;
          sy3 = bfy;
          sy2 = bty;
          break;
         case PPE_S:
          sx3 = bfx;
          sx2 = bfx;
          sy2 = sy3 = bty - thickness;
          break;
         case PPE_E:
          sx2 = sx3 = btx - thickness;
          sy3 = bfy;
          sy2 = bty;
          break;
         case PPE_NW:
          sx2 = btx + thickness;
          sx3 = bfx;
          sy2 = bty;
          sy3 = bfy + thickness;
          break;
         case PPE_SW:
          sx2 = btx;
          sx3 = bfx + thickness;
          sy2 = bty - thickness;
          sy3 = bfy;
          break;
         case PPE_SE:
          sx2 = btx - thickness;
          sx3 = bfx;
          sy2 = bty;
          sy3 = bfy - thickness;
          break;
         case PPE_NE:
          sx2 = btx;
          sx3 = bfx - thickness;
          sy2 = bty + thickness;
          sy3 = bfy;
          break;
      }

      switch(type)
      {
         case PPE_LL:
          triangle(onto, bfx, bfy, sx2,sy2,sx3,sy3, color);
          break;
         case PPE_UL:
          triangle(onto, bfx, bfy, btx,bty,sx3,sy3, color);
          break;
         case PPE_LR:
          triangle(onto, sx2, sy2, btx,bty,sx3,sy3, color);
          break;
         case PPE_UR:
          triangle(onto, sx2, sy2, btx,bty,bfx,bfx, color);
          break;
      }
   }

   if (slope)
   {
      switch(facing)
      {
         case PPE_N:
           tfy += top_tile_size;
           tty += top_tile_size;
           break;
         case PPE_E:
           tfx -= top_tile_size;
           ttx -= top_tile_size;
           break;
         case PPE_S:
           tfy -= top_tile_size;
           tty -= top_tile_size;
          break;
         case PPE_W:
           tfx += top_tile_size;
           ttx += top_tile_size;
          break;
      }
   }



   if  (type == PPE_LL || type == PPE_LR)
   {
      v[1].x = bfx;
      v[1].y = bfy;
      v[2].x = btx;
      v[2].y = bty;
      if (type == PPE_LL)
      {
        v[0].x = tfx;
        v[0].y = tfy;
      }
      else /* type == LR */
      {
        v[0].x = ttx;
        v[0].y = tty;
      }


   }
   else /* type == UR || type == UL */
   {
      if (type == PPE_UL)
      {
         v[1].x = bfx;
         v[1].y = bfy;
      }
      else /* type == UR */
      {
         v[1].x = btx;
         v[1].y = bty;
      }
      
      v[2].x = ttx;
      v[2].y = tty;
      v[0].x = tfx;
      v[0].y = tfy;

   }


   /* do some simple backface culling */

   if ((facing == PPE_N ) && (tfy <= bfy))
      cull = TRUE;

   if ((facing == PPE_S ) && (tfy >= bfy))
      cull = TRUE;

   if ((facing == PPE_W) && (tfx <= bfx))
      cull = TRUE;

   if ((facing == PPE_E) && (tfx >= bfx))
      cull = TRUE;
      
   if ((facing == PPE_NW) && ((tfx - bfx) + (tfy - bfy) < 0))
      cull = TRUE;

   if ((facing == PPE_SW) && ((tfx - bfx) - (tfy - bfy) < 0))
      cull = TRUE;

   if ((facing == PPE_NE) && (-(tfx - bfx) + (tfy - bfy) < 0))
      cull = TRUE;

   if ((facing == PPE_SE) && (-(tfx - bfx) - (tfy - bfy) < 0))
      cull = TRUE;

   if (cull)
      color= makecol(0, 100,0);


   if (solid && !cull)
   {
      if (scolor <0)
          scolor = texture->mean_color;

      if (scolor <0)
         scolor = color;

      triangle(onto, v[0].x, v[0].y, v[1].x, v[1].y, v[2].x, v[2].y, scolor);
   
   }

   if (wireframe && !(cull && solid))
   {
//      if (solid)
//         color = darken(scolor);
         
      line(onto, v[0].x, v[0].y, v[1].x, v[1].y, color);
      line(onto, v[1].x, v[1].y, v[2].x, v[2].y, color);
      line(onto, v[0].x, v[0].y, v[2].x, v[2].y, color);
   }
   
   if (symbolic && slope)
   {
      color= makecol(0, 255,0);
      ttx = (ttx - ppe_cam_x) * scale_bot / scale_top + ppe_cam_x;
      tfx = (tfx - ppe_cam_x) * scale_bot / scale_top + ppe_cam_x;
      tty = (tty - ppe_cam_y) * scale_bot / scale_top + ppe_cam_y;
      tfy = (tfy - ppe_cam_y) * scale_bot / scale_top + ppe_cam_y;

      switch(type)
      {
         case PPE_UL:
          ppe_triangle_arcd(onto, tfx, tfy, bfx, bfy, ttx, tty, color, -1);
          break;
         case PPE_UR:
          ppe_triangle_arcd(onto, tfx, tfy, btx, bty, ttx, tty, color, -1);
          break;
         case PPE_LL:
          ppe_triangle_arcd(onto, bfx, bfy, tfx, tfy, btx, bty, color, 1);
          break;
         case PPE_LR:
          ppe_triangle_arcd(onto, bfx, bfy, ttx, tty, btx, bty, color, 1);
          break;
      }
   }
}
