#include <stdio.h>
#include "p_intern.h"





PPE_BUILDING *ppe_create_building()
{
   PPE_BUILDING *b = malloc(sizeof(PPE_BUILDING));
   
   if (!b)
      return NULL;

   b->nr_objects = 0;
   b->objects = NULL;

   return b;
}

void ppe_destroy_building(PPE_BUILDING *b)
{
   if (!b)
      return;

   if (b->objects)
      ppe_free_list(b->objects);


   free(b);
}





void ppe_building_add(PPE_BUILDING *b, int x, int y, int layer, PPE_OBJECT *o)
{
   PPE_LIST *l;


   if (o->type != PPE_T_BUILDING)
   {
      l = ppe_new_list_elem();
   
   
      if (!l)
         return;
   
      b->w = MAX(b->w, x);
      b->h = MAX(b->h, y);
      b->d = MAX(b->d, layer);
   
      l->object = o;
      l->next = (PPE_LIST *)b->objects;
      b->nr_objects++;
      /* abuse xfrom,yfrom, xto to store x,y,layer */
   
      l->xfrom = x;
      l->yfrom = y;
      l->xto = layer;
      b->objects = l;
   }
   else
   {
      ppe_add_buildings(b,x,y,layer, o->building);
   }
}

void ppe_map_add_building(PPE_MAP *m, int x, int y, int layer, PPE_BUILDING *b)
{
   PPE_LIST *i;
   for (i = (PPE_LIST *)(b->objects); i; i = i->next)
   {
      /*LIST->xfrom/yfrom/xto are abused to store x,y,layer of the objects */
      if (x + i->xfrom >=0 && x + i->xfrom < m->w &&
          y + i->yfrom >=0 && y + i->yfrom < m->h &&
          layer + i->xto >=0 && layer + i->xto < m->l)
          ppe_map_add_object(m, x + i->xfrom, y + i->yfrom, layer + i->xto, i->object);
   
   }
   
}

void ppe_add_buildings(PPE_BUILDING *add_to, int x, int y, int l, PPE_BUILDING *to_add)
{
   PPE_LIST *i;
   for (i = (PPE_LIST *)(to_add->objects); i; i = i->next)
   {
      /*LIST->xfrom/yfrom/xto are abused to store x,y,layer of the objects */
      ppe_building_add(add_to, x + i->xfrom, y+ i->yfrom, l + i->xto, i->object);
   
   }

}


extern void ppe_building_add_tile(PPE_BUILDING *b, int xb, int yb, int layerb,PPE_MAP *m, int xm, int ym, int layerm)
{
   int i;
   PPE_LIST *l;

   for (i=0;i<ppe_map_get_nr_objects(m,xm,ym,layerm);i++)
   {
      l = ppe_map_get_listobject(m, xm, ym, layerm,i);
      ASSERT(l);
      ppe_building_add(b, xb, yb, layerb, l->object);
   }

}

extern PPE_BUILDING *ppe_building_copy(PPE_BUILDING *b)
{
   PPE_BUILDING *nw;


   nw = ppe_create_building();

   if (!nw)
      return NULL;

   ppe_add_buildings(nw, 0, 0, 0, b);

   return nw;
}

void ppe_building_save(char *filename, PPE_BUILDING *b)
{
   PACKFILE *out = pack_fopen(filename, F_WRITE_PACKED);


   if (!out)
   {
      alert("could not open file", filename,"oops","OK",NULL,13,0);
      return;
   }
   ppe_building_write(out, b);

   pack_fclose(out);

}


void ppe_building_write(PACKFILE *out, PPE_BUILDING *b)
{
   PPE_LIST *objects = b->objects;
   PPE_LIST *l;

   int o;
   int max_id = 0;


   for (l = objects;l;l =l->next)
   {
      max_id = MAX(l->object->object_number, max_id);
      ASSERT(l->object->object_number >= 0);
   }

   pack_mputl(AL_ID('P','P','E','B'), out);
   pack_mputw((short)b->w, out);
   pack_mputw((short)b->h, out);
   pack_mputw((short)b->d, out);
   pack_mputw((short)max_id, out);
   pack_mputw((short)b->nr_objects, out);
   for (l = objects;l;l =l->next)
   {
      pack_mputw((short)l->object->object_number, out);
      o = l->xfrom;
      if (o < 0)
         o +=65536;
      pack_mputw(o, out);
      o = l->yfrom;
      if (o < 0)
         o +=65536;
      pack_mputw(o, out);
      o = l->xto;
      if (o < 0)
         o +=65536;
      pack_mputw(o, out);
   
   }

}


PPE_BUILDING *ppe_building_load(char *filename, int nr_available_objects, PPE_OBJECT **objects)
{
   PPE_BUILDING *ret;
   PACKFILE *in = pack_fopen(filename, F_READ_PACKED);
   
   if (!in)
   {
      sprintf(ppe_error,"could not open %s", filename);
      return NULL;
   }
   
   ret= ppe_building_read(in, nr_available_objects, objects);

   pack_fclose(in);


   return ret;
}


PPE_BUILDING *ppe_building_read(PACKFILE *in, int nr_available_objects, PPE_OBJECT **objects)
{
   int needed;
   int nr, i;
   int x,y,l, obj_id;
   
   PPE_BUILDING *nw = NULL;
   

   if (pack_mgetl(in) != AL_ID('P','P','E','B'))
   {
      sprintf(ppe_error,"not a valid file");
      return NULL;
   }

   nw = ppe_create_building();

   if (!nw)
   {
      sprintf(ppe_error,"out of memory");
      return NULL;
   }

   /* for now skip dimensions */

   pack_mgetw(in);
   pack_mgetw(in);
   pack_mgetw(in);

   needed = pack_mgetw(in);

   if (needed > nr_available_objects)
   {
      sprintf(ppe_error,"this collection uses more objects than available");
      return NULL;
   }

   nr = pack_mgetw(in);

   for (i = 0;i< nr;i++)
   {
      obj_id = pack_mgetw(in);
      x = pack_mgetw(in);
      if (x > 32767)
         x -= 65536;
      y = pack_mgetw(in);
      if (y > 32767)
         y -= 65536;
      l = pack_mgetw(in);
      if (l > 32767)
         l -= 65536;

      ppe_building_add(nw, x, y, l, objects[obj_id]);
   }


   return nw;
}



