#ifndef _PPE_INTERN_H_
#define _PPE_INTERN_H_
#include <math.h>
#include "ppe.h"


#define PPE_FINESHIFT 5

#define PPE_EPSILON  (1.0 / 2048)

extern double *ppe_scale_table;
extern int ppe_nr_layers, ppe_tile_size, ppe_building_height;
extern double ppe_max_size, ppe_min_size;
extern int ppe_cam_x, ppe_cam_y, ppe_cam_l, ppe_cam_lfine;
extern PPE_OBJECT *ppe_change_object_ex(PPE_OBJECT *o,int type, int *xtex, int *ytex, PPE_TEX *texture, int e, int texnr, int objnr);

#define PPE_SCALE(dist, finedist)     (ppe_scale_table[(dist) >= 0 ? (((dist)<<PPE_FINESHIFT)) + finedist : 0])
/* 0 = floortiles 1 = dynamic objects 2 = sloped surfaces
   3 = walls 4 is dynamic objects */
#define PPE_MAX_PASSES 5

typedef struct PPE_LIST
{
   struct PPE_LIST *next;
   PPE_OBJECT *object;
   int xfrom,
       yfrom,
       xto,
       yto, /* caculated from the type of object */
       face,
       type,
       slope,

       pass;

   char *type_name; /* for use in map editor */
   fixed angle;
   int anim_offset; /* used to store an offset to the global animation counter for
                       objects containing animated textures*/
   int fine_l;
} PPE_LIST;



typedef struct PPE_CONTAINER
{
   int nr_obj;

   PPE_LIST *object[PPE_MAX_PASSES];

} PPE_CONTAINER;

extern PPE_LIST ppe_object_table[PPE_T_LAST];


extern PPE_LIST *ppe_map_get_listobject(PPE_MAP *m, int x, int y, int l,int nr);
extern int ppe_map_get_nr_objects(PPE_MAP *m, int x, int y, int l);


extern void ppe_quad(BITMAP *onto, int x0, int y0, int x1, int y1,int x2, int y2, int x3, int y3, int color);

/* you can only save/load buildings when you have used create_object_ex to create the objects*/
PPE_BUILDING *ppe_building_load(char *filename,  int nr_available_objects, PPE_OBJECT **objects);
void ppe_building_save(char *filename, PPE_BUILDING *b);

PPE_BUILDING *ppe_building_read(PACKFILE *in, int nr_available_objects, PPE_OBJECT **objects);
void ppe_building_write(PACKFILE *out, PPE_BUILDING *b);

/* freelist stuff*/
void ppe_free_list(PPE_LIST *l);
void ppe_free_list_elem(PPE_LIST *l);
PPE_LIST *ppe_new_list_elem();
void ppe_cleanup_freelist();


typedef struct PPE_DYN_LIGHT
{
   int ***data;
   int x, y,l, on;
   int radius;
} PPE_DYN_LIGHT;

extern int ppe_num_dynamic_lights;
extern PPE_DYN_LIGHT *ppe_dynamic_lights;



#endif
