#ifndef _PPE_H_
#define _PPE_H_


#ifdef __cplusplus
  extern "C" {
#endif

#include <allegro.h>

#define PPE_N  0
#define PPE_NE 1
#define PPE_E  2
#define PPE_SE 3
#define PPE_S  4
#define PPE_SW 5
#define PPE_W  6
#define PPE_NW 7

#define CORNER_LOW  0
#define CORNER_HIGH 1


#define PPE_LL 0
#define PPE_LR 1
#define PPE_UL 2
#define PPE_UR 3

typedef void PPE_OBJHANDLE; // for use as PPE_OBJHANDLE *


/*initialisation etc*/
extern int ppe_init(int tile_size, int max_camera_height, int max_building_height, double max_layer_size, double min_layer_size);
extern void ppe_exit();
extern char ppe_error[];

/* camera coordinates relative to the viewport*/
extern void ppe_set_camera_pos(int x, int y);
extern void ppe_set_camera_height(int layer, int fine);
extern void ppe_set_perspective(double max_layer_size, double min_layer_size);

/* texture stuff, I use my own texture struct instead of BITMAPS
 * to facilitate addition of mipmaps  etc
 * at a later stage
 */

 
typedef struct PPE_TEX
{
   int w,h;
   BITMAP *b;
   int nr_frames; /* nr of animation frames */
   int multiplier; /* 1 makes it run at half the speed of ppe_animation_frame 2 at quarter
                      (animation frame is shifted*/
   BITMAP **frames; /* animation frames or mipmap levels (depending on if mipmap is set) */
   BITMAP ***mipframes; /* mipmapped animation frames (currenly not implemented*/
   
   int mean_color;
   int mipmap;
   int mip_scaleshift; // amount to rightshift the size of the image to get ppe_tile_size

}  PPE_TEX;

extern int ppe_border_color;

/* handle loose textures*/
/*  increase this in a timer to animate the animated textures*/
extern int ppe_animation_frame;

extern PPE_TEX *ppe_create_texture(BITMAP *b);
extern void ppe_destroy_texture(PPE_TEX *t);
extern BITMAP *ppe_texture_get_bitmap(PPE_TEX *tex, double scale, int offset);
extern PPE_TEX *ppe_create_animated_texture(DATAFILE *d, int speed);
extern int ppe_animated_texture_speed(PPE_TEX *t, int speed);
extern void ppe_tex_add_mipmap(PPE_TEX *tex, int max_camheight); // tell ppe to add a mipmap to the texture, the max_camheight determines until which level the mipmap is generated, 0 == ppe_max_camheight
extern void ppe_tex_is_sprite(PPE_TEX *t); // tell ppe a texture is a sprite (are scaled differently, so mipmapping works differently)


/*load a collection of textures from a datafile*/
extern PPE_TEX *ppe_textures;
extern RGB *ppe_texture_palette;
extern int ppe_load_textures(char *datafilename, int load_names);
extern char const **ppe_texture_names;
extern void ppe_unload_textures();
extern int ppe_nr_textures;


/* low level drawing */
extern void ppe_draw_tile(int layer, double x, double y, PPE_TEX *tile, BITMAP *onto, int animation_offset);
extern void ppe_draw_wall(int face, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset);
extern void ppe_draw_slope(int facing, int nr, int layer, double xf, double yf, double xt,double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset);
extern void ppe_draw_triangle(int facing, int type, int slope, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset);
extern void ppe_rotate_sprite(int layer, int fine_layer, double x, double y, fixed angle,  PPE_TEX *sprite, BITMAP *onto, int animation_offset);

extern void ppe_draw_lit_tile(int layer, double x, double y, PPE_TEX *tile, BITMAP *onto, int animation_offset, int lx, int ly, int ***lightmap);
extern void ppe_draw_lit_wall(int face, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset, int lx, int ly, int ***lightmap);
extern void ppe_draw_lit_slope(int facing, int nr, int layer, double xf, double yf, double xt,double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset, int lx, int ly, int ***lightmap);
extern void ppe_draw_lit_triangle(int facing, int type, int slope, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int animation_offset, int lx, int ly, int ***lightmap);
extern void ppe_rotate_lit_sprite(int layer, int fine_layer, int x, int y, fixed angle,  PPE_TEX *sprite, BITMAP *onto, int animation_offset, int lx, int ly,int ***lightmap);


extern void ppe_draw_tile_schematic(int layer, double x, double y, PPE_TEX *tile, BITMAP *onto);
extern void ppe_draw_tile_solid(int layer, double x, double y,  PPE_TEX *tile, BITMAP *onto, int color);
extern void ppe_draw_empty_tile(int layer, double x, double y,  BITMAP *onto, int color);
extern void ppe_draw_empty_tile_schematic(int layer, double x, double y,  BITMAP *onto, int color);
extern void ppe_draw_wall_schematic(int face, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor);
extern void ppe_draw_slope_schematic(int facing, int nr, int layer, double xf, double yf, double xt,double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor);
extern void ppe_draw_triangle_schematic(int facing, int type, int slope, int layer, double xf, double yf, double xt, double yt, int *xtex, int *ytex, PPE_TEX *texture, BITMAP *onto, int wireframe, int symbolic, int solid, int scolor);
extern void ppe_draw_arced_region(int layer, double xf, double yf, double xt, double yt,  BITMAP *onto, int color);



/* map stuff */
typedef  enum
{
   PPE_T_TILE = 0,
   PPE_T_NWALL,
   PPE_T_SWALL,
   PPE_T_EWALL,
   PPE_T_WWALL,
   PPE_T_NWWALL,
   PPE_T_NEWALL,
   PPE_T_SWWALL,
   PPE_T_SEWALL,
   PPE_T_NSLOPE,
   PPE_T_SSLOPE,
   PPE_T_ESLOPE,
   PPE_T_WSLOPE,
   PPE_T_NWCORNER1,
   PPE_T_SWCORNER1,
   PPE_T_NECORNER1,
   PPE_T_SECORNER1,
   PPE_T_NWCORNER2,
   PPE_T_SWCORNER2,
   PPE_T_NECORNER2,
   PPE_T_SECORNER2,
   PPE_T_NULTRIANGLE,
   PPE_T_SULTRIANGLE,
   PPE_T_EULTRIANGLE,
   PPE_T_WULTRIANGLE,
   PPE_T_NLLTRIANGLE,
   PPE_T_SLLTRIANGLE,
   PPE_T_ELLTRIANGLE,
   PPE_T_WLLTRIANGLE,
   PPE_T_NURTRIANGLE,
   PPE_T_SURTRIANGLE,
   PPE_T_EURTRIANGLE,
   PPE_T_WURTRIANGLE,
   PPE_T_NLRTRIANGLE,
   PPE_T_SLRTRIANGLE,
   PPE_T_ELRTRIANGLE,
   PPE_T_WLRTRIANGLE,
   PPE_T_S_NULTRIANGLE,
   PPE_T_S_SULTRIANGLE,
   PPE_T_S_EULTRIANGLE,
   PPE_T_S_WULTRIANGLE,
   PPE_T_S_NLLTRIANGLE,
   PPE_T_S_SLLTRIANGLE,
   PPE_T_S_ELLTRIANGLE,
   PPE_T_S_WLLTRIANGLE,
   PPE_T_S_NURTRIANGLE,
   PPE_T_S_SURTRIANGLE,
   PPE_T_S_EURTRIANGLE,
   PPE_T_S_WURTRIANGLE,
   PPE_T_S_NLRTRIANGLE,
   PPE_T_S_SLRTRIANGLE,
   PPE_T_S_ELRTRIANGLE,
   PPE_T_S_WLRTRIANGLE,
   PPE_T_NEULTRIANGLE,
   PPE_T_NEURTRIANGLE,
   PPE_T_NELLTRIANGLE,
   PPE_T_NELRTRIANGLE,
   PPE_T_NWULTRIANGLE,
   PPE_T_NWURTRIANGLE,
   PPE_T_NWLLTRIANGLE,
   PPE_T_NWLRTRIANGLE,
   PPE_T_SEULTRIANGLE,
   PPE_T_SEURTRIANGLE,
   PPE_T_SELLTRIANGLE,
   PPE_T_SELRTRIANGLE,
   PPE_T_SWULTRIANGLE,
   PPE_T_SWURTRIANGLE,
   PPE_T_SWLLTRIANGLE,
   PPE_T_SWLRTRIANGLE,
   PPE_T_DYNAMIC,
   PPE_T_BUILDING,
   PPE_T_LAST
} PPE_OBJECTS;

typedef struct PPE_BUILDING
{
   int nr_objects;
   void *objects; /* really a LIST * , but that type is only known internally */
   int w,h,d; /* dimensions */
} PPE_BUILDING;


typedef struct PPE_OBJECT
{
   int type;
   int length;
   
   PPE_TEX *texture;
   int xtex[4];
   int ytex[4];

   int plate_xf;
   int plate_yf;
   int plate_xt;
   int plate_yt;
   fixed angle;  /*for dynamic objects which are rotatable 0-255*/
   int texture_number; /* for use in mapeditor */
   int object_number;
   PPE_BUILDING *building; /* if type == PPE_T_BUILDING then this is used, and he rest of the
                              struct is meaningless*/
} PPE_OBJECT;


typedef struct PPE_MAP
{
   int w,h,l; /* dimensions */
   int cam_x, cam_y; /* camera position in the viewport */
   int cam_l;       /* height of the camera in layers */
   int cam_lfine;   /* fine height of camera in 1/(1<<PPE_FINESHIFT) layers*/
   double vpx, vpy;   /* position of the center of the viewport on the map
                       * in tile coordinates
                       */
   void *data;         /* the data, really a container ****, but that type
                        * is not globally known
                        */
   int ***light_map; /* == NULL if lighting not enabled*/
} PPE_MAP;


extern PPE_MAP *ppe_create_map(int size_x, int size_y, int layers);
extern PPE_MAP *ppe_load_map(char *mapfilename, char *texturefilename, PPE_OBJECT ***objects);

extern void ppe_destroy_map(PPE_MAP *map); /* leaves the objects intact*/
extern void ppe_destroy_objects(PPE_OBJECT **o);
extern void ppe_map_set_viewpos(PPE_MAP *m,double x, double y, double camheight);
extern void ppe_map_set_camerapos(PPE_MAP *m, int x,int y);

extern void ppe_map_render(PPE_MAP *m, BITMAP *onto);
extern void ppe_map_render_ex(PPE_MAP *m,BITMAP *onto, int bottomlayer, int toplayer);
extern void ppe_map_render_lit_ex(PPE_MAP *m,BITMAP *onto, int bottomlayer, int toplayer);
extern void ppe_map_render_schematic(PPE_MAP *m,BITMAP *onto, int layr,int wireframe,int symbolic, int solid);
extern void ppe_map_render_grid(PPE_MAP *m,BITMAP *onto, int layr, int color);
extern void ppe_map_render_hiddenwire(PPE_MAP *m,BITMAP *onto, int layr, int bgcolor);
extern void ppe_map_visible(PPE_MAP *m, BITMAP *onto,int *min_x, int * min_y, int *max_x, int *max_y);

/* transform from map to screen coordinates, to overlay stuff on ppe renderings */
extern void ppe_map_transform(PPE_MAP *m,double x, double y, int l, int *xo,int *yo);



extern PPE_OBJHANDLE  *ppe_map_add_object(PPE_MAP *m, int x, int y, int l, PPE_OBJECT *o);
extern void ppe_map_remove_object(PPE_MAP *m, int x,int y,int l,PPE_OBJECT *obj);
extern PPE_OBJHANDLE  *ppe_map_add_dynamic(PPE_MAP *m, int x, int y, int l, double fine_x, double fine_y, double fine_l,int angle, PPE_OBJECT *o, int anim_offset);
extern void ppe_map_clear_dynamic(PPE_MAP *m, int xfrom, int yfrom, int xto, int yto);
extern void ppe_map_clear_pass(PPE_MAP *m, int x, int y, int l, int pass);
extern void ppe_map_clear(PPE_MAP *m, int x, int y, int l); /* clears all passes */


extern PPE_OBJECT *ppe_create_object(int type, int *xtex, int *ytex, PPE_TEX *texture, int length);
extern PPE_OBJECT *ppe_create_object_ex(int type, int *xtex, int *ytex, PPE_TEX *texture, int length, int texnr, int objnr);
extern void ppe_compound_object_add(PPE_OBJECT *obj, int x, int y, int layer, PPE_OBJECT *o);
extern void ppe_destroy_object(PPE_OBJECT *obj);


extern void ppe_map_select_tile(PPE_MAP *m, int x, int y, int layr, int *xm, int *ym);
extern void ppe_map_highlight_tile(PPE_MAP *m,BITMAP *onto,  int x, int y, int layr, int color);
extern void ppe_map_highlight_rect(PPE_MAP *m,BITMAP *onto,  int xf, int yf, int xt, int yt, int layr, int color);




extern PPE_BUILDING *ppe_create_building();
extern void ppe_destroy_building(PPE_BUILDING *b);

extern void ppe_building_add(PPE_BUILDING *b, int x, int y, int layer, PPE_OBJECT *o);
extern void ppe_map_add_building(PPE_MAP *m, int x, int y, int layer, PPE_BUILDING *b);
extern void ppe_add_buildings(PPE_BUILDING *add_to,int x, int y, int l, PPE_BUILDING *to_add);
extern void ppe_building_add_tile(PPE_BUILDING *b, int xb, int yb, int layerb,PPE_MAP *m, int xm, int ym, int layerm);
extern PPE_BUILDING *ppe_building_copy(PPE_BUILDING *b);

extern void ppe_triangle_arcd(BITMAP *onto, int x1, int y1, int x2, int y2, int x3, int y3, int color, int distrib);
extern void ppe_rect_arcd(BITMAP *onto, int x1, int y1, int x2, int y2, int color, int distrib, int facing);


/* dynamic object stiff (sprites) */

extern PPE_OBJECT *ppe_create_dynamic_object(PPE_TEX *sprite);
extern void ppe_destroy_dynamic_object(PPE_OBJECT *o);


extern int ppe_polytype;

/* lighting stuff*/
extern int ppe_enable_lighting(PPE_MAP *map, int ambient_level);
extern void ppe_disable_lighting(PPE_MAP *map);
extern void ppe_add_light(PPE_MAP  *map, double  x, double  y, double  l, int strength, double radius1, double radius2);
extern void ppe_light_border_zero(PPE_MAP *m);

extern int ppe_create_dynamic_light(int radius, int strength);

extern void ppe_dynamic_light_set(int light,int radius, int strength);
extern void ppe_dynamic_light_pos(int light,int x, int y, int l);
extern void ppe_dynamic_light_on(int light,int on);

extern void ppe_destroy_dynamic_lights();


extern BITMAP *ppe_scratch_bitmap(int w, int h);
extern void ppe_cleanup_scratch();





#ifdef __cplusplus
}
#endif



#endif
