/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include "data/gfx.h"
#include "objects.inc"

/* object_from_type() is in dynamic.cc */


Display_object::Display_object()
{

   ppe_object = NULL;
   nr_states = 0;

}

Display_object::~Display_object()
{
   for (int i=0;i<nr_states;i++)
       ppe_destroy_object(ppe_object[i]);

   free(ppe_object);

}

void Display_object::add_ppe_object(PPE_OBJECT *o)
{
   nr_states++;

   //!hack alert, rather ugly to check here, but easier in adding new objects
   if (!o)
      fatal("out of memory");

   ppe_object = (PPE_OBJECT **)realloc(ppe_object, nr_states  * sizeof(PPE_OBJECT *));

   if (!ppe_object)
      fatal("out of memory");


   ppe_object[nr_states -1] = o;
   
}



void Renderer_ppe::setuptex(int *xtex, int *ytex, PPE_TEX *t, int nx = 1, int ny = 1)
{
   if (nx > 0)
   {
      xtex[0] = 0;
      xtex[1] = nx * t->w;
      xtex[2] = nx * t->w;
      xtex[3] = 0;
   }
   else
   {
      xtex[0] = -nx * t->w;
      xtex[1] = 0;
      xtex[2] = 0;
      xtex[3] = -nx * t->w;
   }
   
   if (ny > 0)
   {
      ytex[0] = 0;
      ytex[1] = 0;
      ytex[2] = ny * t->h;
      ytex[3] = ny * t->h;
   }
   else
   {
      ytex[0] = -ny * t->h;
      ytex[1] = -ny * t->h;
      ytex[2] = 0;
      ytex[3] = 0;
   }

}

int Renderer_ppe::create_objects()
{
   int xtex[] = {0,256,256,0};
   int ytex[] = {0,0,256,256};


   setuptex( xtex, ytex,tex[TEX_DOOR]);
   display_object[R_ROOF_N].add_ppe_object(ppe_create_object(PPE_T_NSLOPE, xtex, ytex, tex[TEX_DOOR], 1));
   display_object[R_ROOF_W].add_ppe_object(ppe_create_object(PPE_T_WSLOPE, xtex, ytex, tex[TEX_DOOR], 1));

   display_object[R_ROOF_NWPUNT].add_ppe_object(ppe_create_object(PPE_T_BUILDING, NULL,NULL, NULL, 1));
   ppe_compound_object_add(display_object[R_ROOF_NWPUNT].ppe_object[0],0,0,0,ppe_create_object(PPE_T_S_NLLTRIANGLE, xtex, ytex, tex[TEX_DOOR], 1));
   ppe_compound_object_add(display_object[R_ROOF_NWPUNT].ppe_object[0],0,0,0,ppe_create_object(PPE_T_S_WLRTRIANGLE, xtex, ytex, tex[TEX_DOOR], 1));

   display_object[R_ROOF_SWPUNT].add_ppe_object(ppe_create_object(PPE_T_BUILDING, NULL,NULL, NULL, 1));
   ppe_compound_object_add(display_object[R_ROOF_SWPUNT].ppe_object[0],0,0,0,ppe_create_object(PPE_T_S_SLRTRIANGLE, xtex, ytex, tex[TEX_DOOR], 1));
   ppe_compound_object_add(display_object[R_ROOF_SWPUNT].ppe_object[0],0,0,0,ppe_create_object(PPE_T_S_WLLTRIANGLE, xtex, ytex, tex[TEX_DOOR], 1));


   setuptex( xtex, ytex,tex[TEX_DOOR], -1);
   display_object[R_ROOF_S].add_ppe_object(ppe_create_object(PPE_T_SSLOPE, xtex, ytex, tex[TEX_DOOR], 1));
   display_object[R_ROOF_E].add_ppe_object(ppe_create_object(PPE_T_ESLOPE, xtex, ytex, tex[TEX_DOOR], 1));

   setuptex( xtex, ytex,tex[TEX_AMMO_PAD]);
   display_object[R_AMMO_PAD].add_ppe_object(ppe_create_dynamic_object(tex[TEX_AMMO_PAD]));

   setuptex( xtex, ytex,tex[TEX_REPAIR_PAD]);
   display_object[R_REPAIR_PAD].add_ppe_object(ppe_create_dynamic_object(tex[TEX_REPAIR_PAD]));
   
   setuptex( xtex, ytex,tex[TEX_MEDICAL_PAD]);
   display_object[R_MEDICAL_PAD].add_ppe_object(ppe_create_dynamic_object(tex[TEX_MEDICAL_PAD]));

   setuptex( xtex, ytex,tex[TEX_WEAPONSMITH]);
   display_object[R_WEAPONSMITH].add_ppe_object(ppe_create_dynamic_object(tex[TEX_WEAPONSMITH]));

   setuptex( xtex, ytex,tex[TEX_FIETSENMAKER]);
   display_object[R_FIETSENMAKER].add_ppe_object(ppe_create_dynamic_object(tex[TEX_FIETSENMAKER]));


   setuptex( xtex, ytex,tex[TEX_AMBULANCE]);
   display_object[R_AMBULANCE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_AMBULANCE]));

   setuptex( xtex, ytex,tex[TEX_CYCLE]);
   display_object[R_CYCLE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_CYCLE]));
   
   setuptex( xtex, ytex,tex[TEX_MAN]);
   display_object[R_PLAYER].add_ppe_object(ppe_create_dynamic_object(tex[TEX_MAN]));
   setuptex( xtex, ytex,tex[TEX_MAN_WALKING]);
   display_object[R_PLAYER].add_ppe_object(ppe_create_dynamic_object(tex[TEX_MAN_WALKING]));

   setuptex( xtex, ytex,tex[TEX_GRAY_TEGELS]);
   display_object[R_SIMPLE_FLOOR].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_GRAY_TEGELS], 1));

   setuptex( xtex, ytex,tex[TEX_VOTE]);
   display_object[R_VOTEROOM_FLOOR].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_VOTE], 1));

   setuptex( xtex, ytex,tex[TEX_HOSPITAL]);
   display_object[R_SAFEROOM_FLOOR].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_HOSPITAL], 1));

   setuptex( xtex, ytex,tex[TEX_DEFAULT]);
   display_object[R_SOMETHING].add_ppe_object(ppe_create_dynamic_object(tex[TEX_DEFAULT]));

   setuptex( xtex, ytex,tex[TEX_TANK]);
   display_object[R_TANK].add_ppe_object(ppe_create_dynamic_object(tex[TEX_TANK]));

   setuptex( xtex, ytex,tex[TEX_EXPLOSION]);
   display_object[R_EXPLOSION].add_ppe_object(ppe_create_dynamic_object(tex[TEX_EXPLOSION]));

   setuptex( xtex, ytex,tex[TEX_GRENADE]);
   display_object[R_GRENADE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_GRENADE]));
   
   setuptex( xtex, ytex,tex[TEX_KEY]);
   display_object[R_KEY].add_ppe_object(ppe_create_dynamic_object(tex[TEX_KEY]));

   setuptex( xtex, ytex,tex[TEX_VUUR]);
   display_object[R_FIRE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_VUUR]));

   setuptex( xtex, ytex,tex[TEX_DEFAULT]);
   display_object[R_SOMETHING_STATIC].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_DEFAULT], 1));

   setuptex( xtex, ytex,tex[TEX_ARCH]);
   display_object[R_ARCH_N].add_ppe_object(ppe_create_object(PPE_T_NWALL, xtex, ytex, tex[TEX_ARCH], 1));
   display_object[R_ARCH_W].add_ppe_object(ppe_create_object(PPE_T_WWALL, xtex, ytex, tex[TEX_ARCH], 1));

   setuptex( xtex, ytex,tex[TEX_ARCH], -1);
   display_object[R_ARCH_S].add_ppe_object(ppe_create_object(PPE_T_SWALL, xtex, ytex, tex[TEX_ARCH], 1));
   display_object[R_ARCH_E].add_ppe_object(ppe_create_object(PPE_T_EWALL, xtex, ytex, tex[TEX_ARCH], 1));


   setuptex( xtex, ytex,tex[TEX_BRICKS]);
   display_object[R_BRICK_N].add_ppe_object(ppe_create_object(PPE_T_NWALL, xtex, ytex, tex[TEX_BRICKS], 1));
   display_object[R_BRICK_W].add_ppe_object(ppe_create_object(PPE_T_WWALL, xtex, ytex, tex[TEX_BRICKS], 1));
   
   setuptex( xtex, ytex,tex[TEX_BRICKS], -1);
   display_object[R_BRICK_S].add_ppe_object(ppe_create_object(PPE_T_SWALL, xtex, ytex, tex[TEX_BRICKS], 1));
   display_object[R_BRICK_E].add_ppe_object(ppe_create_object(PPE_T_EWALL, xtex, ytex, tex[TEX_BRICKS], 1));

   setuptex( xtex, ytex,tex[TEX_CLAY]);
   display_object[R_OUTSIDE_TILE].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_CLAY], 1));

   setuptex( xtex, ytex,tex[TEX_VENTILATOR]);
   display_object[R_VENTILATOR_N].add_ppe_object(ppe_create_object(PPE_T_NWALL, xtex, ytex, tex[TEX_VENTILATOR], 1));
   display_object[R_VENTILATOR_W].add_ppe_object(ppe_create_object(PPE_T_WWALL, xtex, ytex, tex[TEX_VENTILATOR], 1));
   display_object[R_VENTILATOR].add_ppe_object(ppe_create_object(PPE_T_TILE, xtex, ytex, tex[TEX_VENTILATOR], 1));

   setuptex( xtex, ytex,tex[TEX_VENTILATOR], -1);
   display_object[R_VENTILATOR_S].add_ppe_object(ppe_create_object(PPE_T_SWALL, xtex, ytex, tex[TEX_VENTILATOR], 1));
   display_object[R_VENTILATOR_E].add_ppe_object(ppe_create_object(PPE_T_EWALL, xtex, ytex, tex[TEX_VENTILATOR], 1));

   display_object[R_VENTILATORS].add_ppe_object(ppe_create_object(PPE_T_BUILDING, NULL,NULL, NULL, 1));

   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,0,1,display_object[R_VENTILATOR_N].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,1,1,display_object[R_VENTILATOR_N].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,0,1,display_object[R_VENTILATOR_S].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,-1,1,display_object[R_VENTILATOR_S].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,0,1,display_object[R_VENTILATOR_E].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],-1,0,1,display_object[R_VENTILATOR_E].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,0,1,display_object[R_VENTILATOR_W].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],1,0,1,display_object[R_VENTILATOR_W].ppe_object[0]);
   ppe_compound_object_add(display_object[R_VENTILATORS].ppe_object[0],0,0,2,display_object[R_VENTILATOR].ppe_object[0]);

   setuptex( xtex, ytex,tex[TEX_HEALTH0]);
   
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH0]));
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH1]));
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH2]));
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH3]));
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH4]));
   display_object[R_HEALTHBAR].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HEALTH5]));

   ASSERT(display_object[R_HEALTHBAR].ppe_object[0]->type == PPE_T_DYNAMIC);
   ASSERT(display_object[R_HEALTHBAR].ppe_object[1]->type == PPE_T_DYNAMIC);
   ASSERT(display_object[R_HEALTHBAR].ppe_object[2]->type == PPE_T_DYNAMIC);
   ASSERT(display_object[R_HEALTHBAR].ppe_object[3]->type == PPE_T_DYNAMIC);
   ASSERT(display_object[R_HEALTHBAR].ppe_object[4]->type == PPE_T_DYNAMIC);
   ASSERT(display_object[R_HEALTHBAR].ppe_object[5]->type == PPE_T_DYNAMIC);



   setuptex( xtex, ytex,tex[TEX_LAUNCHER]);
   display_object[R_LAUNCHER].add_ppe_object(ppe_create_dynamic_object(tex[TEX_LAUNCHER]));

   setuptex( xtex, ytex,tex[TEX_YELLOW_BALL]);
   display_object[R_YELLOW_BALL].add_ppe_object(ppe_create_dynamic_object(tex[TEX_YELLOW_BALL]));

   setuptex( xtex, ytex,tex[TEX_RED_BALL]);
   display_object[R_RED_BALL].add_ppe_object(ppe_create_dynamic_object(tex[TEX_RED_BALL]));

   setuptex( xtex, ytex,tex[TEX_BLUE_BALL]);
   display_object[R_BLUE_BALL].add_ppe_object(ppe_create_dynamic_object(tex[TEX_BLUE_BALL]));


   setuptex( xtex, ytex,tex[TEX_LASERBEAM]);
   display_object[R_LASERBEAM].add_ppe_object(ppe_create_dynamic_object(tex[TEX_LASERBEAM]));

   setuptex( xtex, ytex,tex[TEX_MINE]);
   display_object[R_MINE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_MINE]));

   setuptex( xtex, ytex,tex[TEX_HOVER]);
   display_object[R_HOVER].add_ppe_object(ppe_create_dynamic_object(tex[TEX_HOVER]));

   setuptex( xtex, ytex,tex[TEX_WATER]);
   display_object[R_WATER].add_ppe_object(ppe_create_object(PPE_T_TILE,
							    xtex, ytex,
							    tex[TEX_WATER],
							    1));

   setuptex( xtex, ytex,tex[TEX_DOOR]);
   display_object[R_DOOR].add_ppe_object(ppe_create_object(PPE_T_TILE,
							    xtex, ytex,
							    tex[TEX_DOOR],
							    1));

   setuptex( xtex, ytex,tex[TEX_DOORKEY]);
   display_object[R_DOORKEY].add_ppe_object(
			       ppe_create_dynamic_object(tex[TEX_DOORKEY]));


   setuptex( xtex, ytex,tex[TEX_VOTEMACHINE]);
   display_object[R_VOTEMACHINE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_VOTEMACHINE]));

   setuptex( xtex, ytex,tex[TEX_WEAPONMACHINE]);
   display_object[R_WEAPONMACHINE].add_ppe_object(ppe_create_dynamic_object(tex[TEX_WEAPONMACHINE]));
                
   for (int i=0;i<R_LAST;i++)
       if (!(display_object[i].nr_states))
          fatal("RENDERER: objects.cc : forgot to define Object %d",i);


   return 0;
}


void Renderer_ppe::destroy_objects()
{
   // dit gaat op het moment vanzelf bij het weggooien van het display_object in
//   de destructor van Renderer

}
