/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include <allegro.h>
#include "data/gfx.h"


static DATAFILE *data;

int Renderer_ppe::load_gfx()
{
   data = load_datafile(datafile_name);
   DATAFILE *misc_data;

//   message("Loading datafile 'data/datafile.dat'");


   if (!data)
   {
      fatal("could not load %s",datafile_name);
      return TRUE;
   }
   gfx_data = (DATAFILE *)(data[TEX].dat);
   misc_data = (DATAFILE *)(data[MISC].dat);


   int tilesize_data_size = (misc_data[MISC_TILE_SIZE].size);
   char *tilesize_data = (char *)(misc_data[MISC_TILE_SIZE].dat);
   int tilesize_found_end = 0;


   for (int i=0;i<tilesize_data_size;i++)
   {

      if (tilesize_data[i] < '0' || tilesize_data[i] > '9')
      {
         tilesize_data[i] = 0;
         tilesize_found_end = -1;
         break;
      }
   }
   if (!tilesize_found_end)
       fatal("datafile corrupt, could not read tilesize");


       
   tilesize = atoi(tilesize_data);

   printf(" tile size %d\n", tilesize);

   cons_font = cons_normal_font = (FONT *)(misc_data[MISC_CONSOLE_FONT].dat);
   cons_sml_font = (FONT *)(misc_data[MISC_CONSOLE_FNT_SML].dat);

   return FALSE;
      
}





void Renderer_ppe::unload_gfx()
{
   unload_datafile(data);
   gfx_data = NULL;

}



