/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"

#include "client/clutils.h"
#include "client/extradat.h"
#include <time.h>



void Renderer_ppe::is_dirty(List *dirty_list)
{

    Electron *e;
 /* add dirty List to renderer */
    dirty_list->reset();
    Display_data *d;

    
    while ((e = (Electron *)(dirty_list->pop())))
    {

         d = (Display_data *)e->extra_data;

         if (is_dynamic(e->actor_type))
         {
            if ((e->gx() == -1 && e->gy() == -1) || (d->xe < 0 && d->xe <0))
            {
//               warning("^^^^^^^^^^^^ignore above 2 errors, they're not errors ;-)");
               dynamic_list->pop(e);
               active_list->pop(e);
               if (e == centered)
                   centered = NULL;
            }
            else
            {
               dynamic_list->ifnotfoundpush(e);
               active_list->ifnotfoundpush(e);
            }

         }
         else
         {
            if (e->gx() < 0 || e->gy() < 0 || e->gx() >= ppe_map->w || e->gy() >= ppe_map->h)
            {
               warning("Rendering engine: cannot handle static objects out of map range");
            }
            else
            {
               map_dirty[e->gx()][e->gy()] = TRUE;


               if (e->gx() > 0)
               {
                     map_dirty[e->gx()-1][e->gy()] = TRUE;
                     
                     if (e->gy() > 0)
                        map_dirty[e->gx()-1][e->gy()-1] = TRUE;
                     
                     if (e->gy() < ppe_map->h - 1)
                        map_dirty[e->gx()-1][e->gy()+1] = TRUE;
                        
               }
               
               if (e->gx() < ppe_map->w - 1)
               {
                     map_dirty[e->gx()+1][e->gy()] = TRUE;
                     
                     if (e->gy() > 0)
                        map_dirty[e->gx()+1][e->gy()-1] = TRUE;
                     
                     if (e->gy() < ppe_map->h - 1)
                        map_dirty[e->gx()+1][e->gy()+1] = TRUE;
                        
               }
               
               if (e->gy() > 0)
                    map_dirty[e->gx()][e->gy()-1] = TRUE;
                     
               if (e->gy() < ppe_map->h - 1)
                    map_dirty[e->gx()][e->gy()+1] = TRUE;
               
               map_is_dirty = TRUE;
            }
         }
         
    }


}




void Renderer_ppe::render(double camheight, Electron *center, double offset_x, double offset_y)
{

   has_rendered = TRUE;

   static int yellow = makecol(255,255,0);
   static int red = makecol(255,0,0);
   static int lightblue = makecol(100,100,255);
   int fx,fy,tx,ty;


   centered = center ? find_toplevel_vehicle(center) : NULL;


   if (map_is_dirty)
       decorate_dirty_bits();


   ppe_animation_frame = frame;
   
   ppe_map_set_camerapos(ppe_map, playfield->w/2, playfield->h /2); //! sub optimal to do this each frame



   ppe_map_set_viewpos(ppe_map,cam_x + offset_x , cam_y + offset_y,camheight);

//    warning("rcx %g o %g  t %g", cam_x, offset_x,cam_x + offset_x);



   ppe_map_visible(ppe_map, playfield, &fx, &fy, &tx, &ty);
   ppe_map_clear_dynamic(ppe_map, fx,fy, tx, ty);
   add_dynamics_to_map();

//   int xx1,yy1,xx2,yy2;

   if (camheight < max_world_height)
   {
      switch(_render_mode)
      {
         default:
         // fall through
         case RENDER_MODE_NORMAL:
          ppe_map_render_ex(ppe_map, playfield,0, 0);
          draw_effects();
          ppe_map_render_ex(ppe_map, playfield,1, MIN(NUM_PPE_LAYERS - 1, (int)(camheight - .9)));
          if (xcursor >= 0)
            ppe_map_highlight_tile(ppe_map, playfield, xcursor, ycursor, 0, red);

          break;
         case RENDER_MODE_MAPEDIT:
          ppe_map_render_ex(ppe_map, playfield,0, MIN(NUM_PPE_LAYERS - 1, (int)(camheight - .9)));
          ppe_map_render_grid(ppe_map, playfield, 0, yellow);

          if (xcursor >= 0)
            ppe_map_highlight_tile(ppe_map, playfield, xcursor, ycursor, 0, red);

          if (xblockfrom >=0)
            ppe_map_highlight_rect(ppe_map, playfield, xblockfrom, yblockfrom,xblockto,yblockto, 0, lightblue);
          
          
          break;
      }
   }
   if (camheight >= min_map_height)
   {
//      for (int i=0;i<ppe_map->l;i++)
          if (camheight >= max_world_height)
            clear_to_color(playfield, darkblue);
          ppe_map_render_schematic(ppe_map, playfield, 0, FALSE, TRUE, FALSE); // wireframe,symbolic, solid
//          ppe_map_render_schematic(ppe_map, playfield, 1, TRUE, FALSE, FALSE); // ! test solid
//          ppe_map_render_schematic(ppe_map, playfield, 2, TRUE, FALSE, FALSE); // ! test solid

//      for (int i=0;i<ppe_map->l;i++)
//      {
//         ppe_map_render_hiddenwire(ppe_map, playfield, i, darkblue);
//      }


   }

   overlay_electron_info();
   
   num_effects = 0;

}




static int no_longer_active(Object *o)
{
   Electron *e = (Electron *)o;
   Display_data *d;


   d = (Display_data *)e->extra_data;

//   warning("checking %s", e->type_name);


   if (!(d->is_active))
   {
//      warning("FOUND GUILTY FOUND GUILTY FOUND GUILTY FOUND GUILTY FOUND GUILTY FOUND GUILTY ");
      return List::FILTER_MOVE;
   }
   return List::FILTER_LEAVE;

}


void Renderer_ppe::update_logic()
{
   Display_data *d;
   Electron *e;

   
   active_list->filter(no_longer_active, NULL);

   

   calc_cam();
   
   /* advance frame for active objects */
   for (active_list->reset(); (e = (Electron *)active_list->get());active_list->next())
   {
      d = (Display_data *)e->extra_data;
      if (frame > d->frame_end)
      {

//         warning("removing one");
         d->xc = d->xe;
         d->yc = d->ye;
         d->angle = d->angle_end;
         d->is_active = 0;
         d->speed = 0;
         d->dx = d->dy = 0;
         e->change_state();
         continue;
      }

      d->xc += d->dx;

//      warning("xc %g dx %g", d->xc, d->dx);
      
      d->yc += d->dy;
      d->angle += d->d_angle;

      
      if (d->angle > 255)
         d->angle -= 256;

      if (d->angle < 0)
         d->angle += 256;
   }

   for (int i=0;i<MAX_OVERLAYED_STRINGS;i++)
   {
       if (frame > ovframe[i])
           ovstring[i] = NULL;
   }

}


static BITMAP *blur_buffer = NULL;


void Renderer_ppe::draw_frame()
{

   BITMAP *to_blit =playfield;

   
   if (!cons_transparancy || !has_rendered)
      rectfill(console_bitmap,0,(int)cons_y_offset, console_bitmap->w -1,console_bitmap->h -1, darkblue);

   has_rendered = FALSE;

   if (!cons_smooth_scroll)
      cons_curline[cons_curstream] = cons_requested_curline[cons_curstream];
   
   cons_render();
   //   cons_render(playfield, font);


   draw_ovtext();


   if (speedblur && console_transparancy && console_transparancy < 255)
   {

      if (!blur_buffer)
      {
          blur_buffer = create_bitmap(playfield->w, playfield->h);
          if (!blur_buffer)
              fatal("out of memory allocating speedblur buffer");
      }
      
      draw_trans_sprite(blur_buffer,playfield,0,0);
      
      to_blit = blur_buffer;
   }
   if (bitmap_to_overlay)
   {
      draw_sprite(playfield ,bitmap_to_overlay,0,0);
   }

   if (do_show_mouse)
   {
      ::show_mouse(playfield);
      freeze_mouse_flag = TRUE;
   }


   acquire_screen();
   if (do_stretch)
   {
      if (console_bitmap != playfield)
          stretch_blit (to_blit, screen, 0,0,to_blit->w, to_blit->h,0,0, SCREEN_W, SCREEN_H - console_bitmap->h);
      else
          stretch_blit (to_blit, screen, 0,0,to_blit->w, to_blit->h,0,0, SCREEN_W, SCREEN_H);
   }
   else
       blit (to_blit, screen, 0,0,0,0, playfield->w, playfield->h);

   if (console_bitmap != playfield)
       blit (console_bitmap, screen, 0,0,0, SCREEN_H - console_bitmap->h, console_bitmap->w, console_bitmap->h);

       
   release_screen();

   if (do_show_mouse)
   {
      ::show_mouse(screen);
      freeze_mouse_flag = FALSE;
   }


   
}




void Renderer_ppe::screenshot(char *comment)
{
   char buffer[1024] = "screenshot.pcx";
   
   BITMAP *shot = create_bitmap(SCREEN_W, SCREEN_H);
   PALETTE current_palette;
   time_t t;

   t = time(NULL);

   if (!shot)
   {
      alert("screenshot failed","out of memory",NULL, "OK",NULL,0,0);
      return;
   }
   
   if (bitmap_color_depth(shot) == 8)
      get_palette(current_palette);

   blit(screen, shot, 0,0,0,0,SCREEN_W, SCREEN_H);
   text_mode(-1);
   textprintf(shot,font, 0,0,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 0,1,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 0,2,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 1,0,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 1,2,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 2,0,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 2,1,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));
   textprintf(shot,font, 2,2,makecol(255,255,255), "Screenshot Electron. PPE client. date : %s",ctime(&t));

   textprintf(shot,font, 1,1,makecol(0,0,0), "Screenshot Electron. PPE client. date : %s",ctime(&t));




   textout(shot,font,comment, 0,10,makecol(255,255,255));
   textout(shot,font,comment, 1,10,makecol(255,255,255));
   textout(shot,font,comment, 2,10,makecol(255,255,255));
   textout(shot,font,comment, 0,11,makecol(255,255,255));
   textout(shot,font,comment, 2,11,makecol(255,255,255));
   textout(shot,font,comment, 0,12,makecol(255,255,255));
   textout(shot,font,comment, 1,12,makecol(255,255,255));
   textout(shot,font,comment, 2,12,makecol(255,255,255));
   textout(shot,font,comment, 1,11,makecol(0,0,0));

   
   if (file_select("Save screenshot as:", buffer, "PCX;pcx;BMP;bmp"))
   {
      if (save_bitmap(buffer, shot, current_palette))
          warning("saving of file %s failed", buffer);
      else
          message("Saved %s, printed comment '%s' on image", buffer, comment);
   }
   else
       message("Saving canceled, screenshot not saved");

   destroy_bitmap(shot);

   return;
}

static const double vc_div_mass = .005; // elasticity divided by camera mass
static const double friction = .99;

void Renderer_ppe::calc_cam()
{
    double dx,dy;
    double ax,ay;
    
    if (!centered)
    {
        cam_x = cam_y = 0;
        return;
    }
    // mean velocity calculation
    Display_data *d = (Display_data*)(centered->extra_data);

    d->mvx = 99 * d->mvx + d->dx;
    d->mvx /= 100;
    
    d->mvy = 99 * d->mvy + d->dy;
    d->mvy /= 100;



    switch(nausea_level)
    {
      case 0:
       cam_x = d->xc +.5;
       cam_y = d->yc +.5;
      // fall through
      default:
       break;
      case 1:
       requested_cam_x = (d->xc) + .5 + 30 * d->mvx;
       requested_cam_y = (d->yc) + .5 + 30 * d->mvy;
       dx = (requested_cam_x - cam_x);
       dy = (requested_cam_y - cam_y);
       cam_vx = dx / 20;
       cam_vy = dy / 20;
       cam_x += cam_vx;
       cam_y += cam_vy;
       break;
      case 2:
//       requested_cam_x = (d->xc) + .5 + .5 * sin(frame / 20.0);
//       requested_cam_y = (d->yc) + .5 + .5 * cos(frame / 20.0);
       requested_cam_x = (d->xc) + .5;
       requested_cam_y = (d->yc) + .5;
       dx = (requested_cam_x - cam_x);
       dy = (requested_cam_y - cam_y);
       
//     distance = sqrt(dx * dx + dy * dy);
       
//    a =  vc_div_mass * distance;

       ax = vc_div_mass * dx;
       ay = vc_div_mass * dy;

       cam_vx += ax;
       cam_vy += ay;


       cam_vx *= friction;
       cam_vy *= friction;
       cam_x += cam_vx;
       cam_y += cam_vy;
       break;
    }

}


void Renderer_ppe::show_electron(Electron *e)
{
   electron_to_show = e;
}


void Renderer_ppe::overlay_bitmap(BITMAP *bmp)
{
      bitmap_to_overlay = bmp;
}

void Renderer_ppe::show_mouse(int c)
{
   do_show_mouse = c;

   if (!c)
      ::show_mouse(NULL);
   
}


void Renderer_ppe::cursor(int x,int y)
{
   xcursor = x;
   ycursor = y;
}

void Renderer_ppe::block(int xf, int yf, int xt, int yt)
{
    xblockfrom = xf;
    yblockfrom = yf;
    xblockto = xt+1;
    yblockto = yt+1;
}


void Renderer_ppe::effect(int effect, double x1, double y1, double x2, double y2)
{
    if (num_effects >= MAX_EFFECTS)
        return;

    effects[num_effects].effect = effect;
    effects[num_effects].x1 = x1;
    effects[num_effects].x2 = x2;
    effects[num_effects].y1 = y1;
    effects[num_effects].y2 = y2;

    num_effects++;
}


