/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include "objects.inc"

static int bg_red = 10;
static int bg_green = 10;
static int bg_blue = 0;

int Renderer_ppe::init_renderer()
{
   PALETTE(tmp_pal);
//   message("initialing rendering engine...");
   init_dynamic_translate();
   
//   ppe_init(64, 60, NUM_PPE_LAYERS, 2, 1);

   min_map_height = 199;
   max_world_height = 199;
//   cpu_mmx = FALSE;

   electron_to_show = NULL;

   bitmap_to_overlay = NULL;

   if (bitmap_color_depth(screen) == 8)
   {
      get_palette(tmp_pal);
      color_map = new COLOR_MAP;
      create_light_table(color_map, tmp_pal,bg_red>>2, bg_green>>2,bg_blue>>2, NULL);
   }
   else
   {
      set_trans_blender(bg_red,bg_green,bg_blue,255 - cons_transparancy);
   }
   if(load_gfx())
   {
     fatal("could not load graphics, using built in gfx");
   }
//   ppe_init(tilesize, 200, NUM_PPE_LAYERS, 8 * playfield->w/640.0, 2 * playfield->w/640.0);
   ppe_init(tilesize, 200, NUM_PPE_LAYERS, 64 * 256 * playfield->w/(640.0) * tilesize, 64* perspective_fact * playfield->w/(640.0 * tilesize));
   
   create_textures();

   // tilesize, max_camheight, building_height, perspective_max, perspective_min

//   message(" ...done");

   create_objects();
   active_list = new List;
   dynamic_list = new List;



   darkblue = makecol(0,0,50);

   ppe_border_color = makecol(bg_red,bg_green,bg_blue);
   ppe_polytype = POLYTYPE_ATEX_MASK;

   cam_vx = cam_vy = 0;

   do_show_mouse = FALSE;

   return 0;
}

void Renderer_ppe::shutdown_renderer()
{
//   message("shutting down rendering engine...");
   delete active_list;
   delete dynamic_list;

   destroy_objects();

   destroy_textures();
   
   unload_gfx();

   ppe_exit();
   
   shutdown_dynamic_translate();
//   message(" ...done");

   ppe_destroy_dynamic_lights();
}

int Renderer_ppe::start(int w, int h)
{
   message("create %d x %d sized map in rendering engine...", w,h);

   frame = 0;
   centered = NULL;
   

   ppe_map = ppe_create_map(w, h, NUM_PPE_LAYERS);

   cam_x = w/2;
   cam_y = h/2;

   if (lighting_method)
      ppe_enable_lighting(ppe_map, 128);

   for (int i=0;i<w;i+=32)
   {
      for (int j=0;j<h;j+=32)
          ppe_add_light(ppe_map, i+.5,j+.5,0,255,2,6);
   }
   for (int i=16;i<w;i+=32)
   {
      for (int j=16;j<h;j+=32)
          ppe_add_light(ppe_map, i+.5,j+.5,0,-100,2,6);
   }

   ppe_light_border_zero(ppe_map);

   map_dirty = new (int *)[w];
   for (int i = 0; i < w; i++)
   {
      map_dirty[i] = new int[h];
      for (int j = 0; j < h; j++)
          map_dirty[i][j] = TRUE;
      
   }

   map_is_dirty = TRUE;
   
   message("...done");



   return 0;
}

void Renderer_ppe::stop()
{
   centered = NULL;
   message("cleanup rendering engine's map...");


   for (int i = 0; i < ppe_map->w; i++)
   {
      delete [] map_dirty[i];
      
   }

   delete [] map_dirty;

   map_is_dirty = FALSE;


   ppe_destroy_map(ppe_map);

   active_list->clear();
   dynamic_list->clear();

   message("...done");
}



Renderer_ppe::Renderer_ppe(int playfield_w,  int console_w, int console_h,int _cons_streams, int stretch, int _cons_transparancy, char const *dname)
:  Renderer(playfield_w, console_w, console_h,_cons_streams, stretch, _cons_transparancy, dname)
{
   int console_bitmap_h;
   int playfield_h;
   PALETTE pal;


   do_stretch = stretch;
   cons_transparancy = _cons_transparancy;
   
   if (cons_transparancy)
   {
      playfield_h = playfield_w * SCREEN_H / SCREEN_W;
   }
   else
   {
      playfield_h = playfield_w * 380 / 640;
   }

   
   playfield = create_bitmap(playfield_w, playfield_h);



//   if (stretch && cons_transparancy)
//       fatal("transparant console is not supported when the internal rendering resolution is different from the screen resolution");

   if (stretch && !cons_transparancy)
   {
      console_bitmap_h = SCREEN_H - playfield_h * SCREEN_W/ playfield_w;
   }
   else
   {
      console_bitmap_h = SCREEN_H - playfield_h;
   }

   cons_y_offset = 0;
   requested_cons_y_offset = 0;

   if (cons_transparancy)
   {
       requested_cons_y_offset = (int)(cons_y_offset = (double)(playfield->h - 100 * playfield->w / 640));
       console_bitmap = playfield;

       if (bitmap_color_depth(screen) == 8)
       {
           trans_table = new COLOR_MAP;
           get_palette(pal);
           create_trans_table(trans_table, pal, 255 - cons_transparancy,255 - cons_transparancy,255 - cons_transparancy, NULL);
       }
   }
   else
       console_bitmap = create_bitmap(SCREEN_W, MAX(console_bitmap_h, 16));

   if (!playfield || !console_bitmap)
       fatal("ouf of memory");

   display_object = new Display_object[R_LAST];

   cons_setup(console_w, console_h, _cons_streams);

   init_renderer();

   clear_to_color(playfield, darkblue);


   for (int i=0;i<MAX_OVERLAYED_STRINGS;i++)
   {
        ovstring[i] = NULL;
        ovframe[i] = 0;
   }

   stipple_mask = create_bitmap(2,2);
   if (!stipple_mask)
       fatal("out of memory while initialising");


   clear_to_color(stipple_mask, makecol(255,0,0));
   putpixel(stipple_mask,0,0,bitmap_mask_color(stipple_mask));
   putpixel(stipple_mask,1,1,bitmap_mask_color(stipple_mask));

   cons_vis_w = console_bitmap->w  / text_length(cons_font," ");

   cons_vis_w = MIN(cons_w, cons_vis_w);

   xcursor = xblockfrom = -1;

   num_effects = 0;
}



Renderer_ppe::~Renderer_ppe()
{
   show_mouse(FALSE);
   destroy_bitmap(stipple_mask);
   shutdown_renderer();

   delete [] display_object;
   if (console_bitmap != playfield)
       destroy_bitmap(console_bitmap);
   destroy_bitmap(playfield);
}



