#include "renderer_ppe.h"
#include "client/extradat.h"




void Renderer_ppe::draw_electron_2d(Electron *e, BITMAP *onto, int x, int y, int w, int h)
{
   Display_data *dd = (Display_data *)(e->extra_data);
   Display_object *d = object_from_type(e->actor_type);

   PPE_OBJECT *o = d->ppe_object[0];

   PPE_TEX *t = o->texture;

   BITMAP *b = ppe_texture_get_bitmap(t,  1.0, 0);

   masked_stretch_blit(b, onto, 0,0,b->w,b->h, x,y,w,h);

   if (dd->selected)
      rect(onto,x ,y, x+w-1, y+h-1, red);
   
}




void Renderer_ppe::overlay_electron_info()
{
   if (!electron_to_show)
      return;

   int rect_w = (playfield->w - 100);
   int rect_h = (playfield->h - 100);
   List *inv = electron_to_show->inv();
   int inv_size = inv ? inv->size() : 0;
   int size = (rect_h - 3 * text_height(font)) / 4;

   Electron *e;
   
   int vak = rect_h / 3;
   int delta = (vak - size) / 2;
   int inv_delta = inv_size ? size / inv_size : 0;


   rectfill(playfield, 50, 50, playfield->w - 51,playfield->h - 51, darkblue);
   rect(playfield, 50, 50, playfield->w - 51,playfield->h - 51, green);
   hline(playfield, 55, 50 + vak, playfield -> w - 56, green);
   hline(playfield, 55, 50 + 2 * vak, playfield -> w - 56, green);

   if (electron_to_show->parent)
      draw_electron_2d(electron_to_show->parent,playfield, 60, 50 + delta , size, size);
      
   draw_electron_2d(electron_to_show,playfield, 60 , 50 + vak +delta , size, size);

   textprintf(playfield,font, 70 + size, 50 + vak + delta,green,"%s - id: %d", electron_to_show->type_name, electron_to_show->actor_id);

   if (electron_to_show->has_hmd() && electron_to_show->get_h() >=0)
       textprintf(playfield,font, 70 + size, 60 + vak + delta,green, "health %g %%", electron_to_show->get_h()/ 10.0);

   size = MIN(size, rect_w / (inv_size + 1));
   if (inv)
   {
      inv->reset();
      for (int count = 0;count < inv_size; count++)
      {
         e = (Electron *)(inv->get());

         ASSERT(e);
         
         draw_electron_2d(e,playfield, 50 + inv_delta + count * (inv_delta + size)  , 50 + 2 * vak + delta, size, size);
         inv->next();

      }
   }




}

