#include "renderer_ppe.h"


#define NUMR 100

int lx[NUMR];
int ly[NUMR];

static void lc(BITMAP *bmp, int x, int y, int c)
{
    static int l = 0;

    l++;
    l %= NUMR;

    putpixel(bmp, x + lx[l], y+ly[l], c);

}

static void draw_laser(BITMAP *onto, int x1, int y1, int x2, int y2)
{
    static int initialised = 0;

    if (!initialised)
    {
        initialised = 1;
        for (int i = 0; i < NUMR;i++)
        {
            lx[i] = rand() % 5 - 2;
            ly[i] = rand() % 5 - 2;
        }
    }

    do_line(onto, x1, y1, x2, y2, makecol(0,255,0), lc);
}



void Renderer_ppe::draw_effects()
{
    int x1,y1,x2,y2;
    int i;
    
    for (i = 0; i< num_effects; i++)
    {
        switch(effects[i].effect)
        {
            case Renderer::EFFECT_LASER:
                 ppe_map_transform(ppe_map,effects[i].x1, effects[i].y1,0, &x1, &y1);
                 ppe_map_transform(ppe_map,effects[i].x2, effects[i].y2, 0, &x2, &y2);
                 draw_laser(playfield, x1, y1, x2, y2);

            break;
            default:
             warning("renderer: unknown effect %d",effects[i].effect);
            break;
        }
    }
}

