/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include "client/extradat.h"
#include "objects.inc"

static int translate_dynamic_table[][3] =
{
   /* actor,       is_dynamic, ppe_object it is represented with */
    {ACTOR_SYSTEM,       FALSE, R_SOMETHING_STATIC}, // something is a default fallback Object
    {ACTOR_SIMPLE_ROOM,  FALSE, R_SIMPLE_FLOOR},
    {ACTOR_PLAYER,       TRUE,  R_PLAYER},
    {ACTOR_LIGHTCYCLE,   TRUE,  R_CYCLE},
    {ACTOR_KEY,          TRUE,  R_KEY},
    {ACTOR_CYCLEWALL,    TRUE,  R_FIRE},
    {ACTOR_TANK,         TRUE,  R_TANK},
    {ACTOR_GRENADE,      TRUE,  R_GRENADE},
    {ACTOR_EXPLOSION,    TRUE,  R_EXPLOSION},
    {ACTOR_YELLOW_BALL,  TRUE,  R_YELLOW_BALL},
    {ACTOR_BLUE_BALL,    TRUE,  R_BLUE_BALL},
    {ACTOR_RED_BALL,     TRUE,  R_RED_BALL},
    {ACTOR_LAUNCHER,     TRUE,  R_LAUNCHER},
    {ACTOR_MINE,         TRUE,  R_MINE},
    {ACTOR_HOVER,        TRUE,  R_HOVER},
    {ACTOR_LASERBEAM,    TRUE,  R_LASERBEAM},
    {ACTOR_WATER,        FALSE, R_WATER},
    {ACTOR_DOOR,         FALSE, R_DOOR},
    {ACTOR_DOORKEY,      TRUE,  R_DOORKEY},
    {ACTOR_AMBULANCE,    TRUE,  R_AMBULANCE},
    {ACTOR_MEDICAL_PAD,  TRUE,  R_MEDICAL_PAD},
    {ACTOR_REPAIR_PAD,   TRUE,  R_REPAIR_PAD},
    {ACTOR_AMMO_PAD,     TRUE,  R_AMMO_PAD},
    {ACTOR_FIETSENMAKER, TRUE,  R_FIETSENMAKER},
    {ACTOR_WEAPONSMITH,  TRUE,  R_WEAPONSMITH},
    {ACTOR_VOTE_ROOM,    FALSE, R_VOTEROOM_FLOOR},
    {ACTOR_VOTEMACHINE,  TRUE,  R_VOTEMACHINE},
    {ACTOR_WEAPONMACHINE,TRUE,  R_WEAPONMACHINE},
    {ACTOR_SAFE_ROOM,    FALSE, R_SAFEROOM_FLOOR},
};


static int *is_dynamic_lookup;
static int *object_lookup;

void Renderer_ppe::init_dynamic_translate()
{
   int size_of_table;

   is_dynamic_lookup = new int[ACTOR_LAST];
   object_lookup = new int[ACTOR_LAST];

   size_of_table = sizeof(translate_dynamic_table)/(sizeof(int)*3);


   if (size_of_table != ACTOR_LAST)
      severe("not all Actors are known to the renderer (renderer_ppe/dynamic.cc)");
   
   for (int i=0;i <ACTOR_LAST;i++) /* first set some defaults*/
   {
      is_dynamic_lookup[i] = TRUE;
      object_lookup[i] = R_SOMETHING;
   }

   
   for (int i=0;i <size_of_table;i++)
   {
      is_dynamic_lookup[translate_dynamic_table[i][0]] = translate_dynamic_table[i][1];
      object_lookup[translate_dynamic_table[i][0]] = translate_dynamic_table[i][2];
   }

}

void Renderer_ppe::shutdown_dynamic_translate()
{
   delete[] is_dynamic_lookup;
   delete[] object_lookup;
}

int Renderer_ppe::is_dynamic(int actor_type)
{
   ASSERT(actor_type >=0 && actor_type < ACTOR_LAST);

   return is_dynamic_lookup[actor_type];
}

/* is not really only for dynamic objects, but since it needs
 * the above table I put it here instead of in objects.cc
 *
 */
Display_object *Renderer_ppe::object_from_type(int actor_type)
{
   ASSERT(actor_type >=0 && actor_type < ACTOR_LAST);

   return &(display_object[object_lookup[actor_type]]);
}

void Renderer_ppe::add_dynamics_to_map()
{
   Electron *e;
   Display_data *d;
   Display_object *o;
   int xc,yc;
   double xfc,yfc;
   int hbar_state;
   int fx,fy,tx,ty;
   int health;

   ppe_map_visible(ppe_map, playfield, &fx, &fy, &tx, &ty);
   
   for (dynamic_list->reset();(e = (Electron *)(dynamic_list->get()));dynamic_list->next())
   {


      d = (Display_data *)e->extra_data;


      // nasty exception for lasers, since they can be
      // outside of the map, wile their beam is not
      if (e->actor_type == ACTOR_LASERBEAM)
      {
          Laserbeam *l = (Laserbeam *)e;
          if (l->int_vars[Laserbeam::SOURCE_ID] >=0 && l->int_vars[Laserbeam::TARGET_ID] >=0)
          {

              Electron *src = find_toplevel_vehicle(storage->find(l->int_vars[Laserbeam::SOURCE_TYPE],l->int_vars[Laserbeam::SOURCE_ID]));
              Electron *target = find_toplevel_vehicle(storage->find(l->int_vars[Laserbeam::TARGET_TYPE],l->int_vars[Laserbeam::TARGET_ID]));
              Display_data *srcd, *targetd;

              if (src && target)
              {
                  srcd = (Display_data *)src->extra_data;
                  targetd = (Display_data *)target->extra_data;
                  effect(Renderer::EFFECT_LASER, srcd->xc + .5, srcd->yc + .5, targetd->xc + .5, targetd->yc + .5);
              }
          }

      }
      else if (d->xc >= fx && d->yc >= fy && d->xc <= tx && d->yc <=ty)
      {
          o = object_from_type(e->actor_type);

          xc = (int)(d->xc);
          yc = (int)(d->yc);

          xfc = d->xc - xc;
          yfc = d->yc - yc;

//          warning("adding %s at %g, %g",e->type_name, d->xc, d->yc);
          
          if (e->has_hmd()) //! inefficient, maybe set a flag in extra_data when creating the thing
          {
               health = e->get_h();
               if (health >=0)
               {
                  hbar_state = health * display_object[R_HEALTHBAR].nr_states / 1001;
                  if (health <= 1000)
                      ppe_map_add_dynamic(ppe_map, xc, yc,0, xfc, yfc,15,0, display_object[R_HEALTHBAR].ppe_object[hbar_state],0);
                  else
                      warning("!!!!!!!! Health more than 1000 for Object %d (%s)", e->actor_id,e->type_name);
               }
          }
          if (!d->selected || ((frame >> 5) & 1))
             ppe_map_add_dynamic(ppe_map, xc, yc,0, xfc, yfc,5,(int)(d->angle), o->ppe_object[e->get_state() % o->nr_states],0);
          
      }
   }
}
