/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "renderer_ppe.h"
#include "objects.inc"
#include "client/extradat.h"
#include "common/defs.h"


void Renderer_ppe::decorate_dirty_bits()
{
    for (int i = 0; i < ppe_map->w; i++)
    {
        for (int j = 0; j < ppe_map->h; j++)
        {
            if (map_dirty[i][j])
            {
               decorate_pos(i,j);
               map_dirty[i][j] = 0;
            }
        }
    }

    map_is_dirty = FALSE;
   
}


void Renderer_ppe::decorate_map_region(int x, int y, int w, int h)
{
   for (int i = 0; i < w; i++)
   {
       for (int j = 0; j < h; j++)
       {
           decorate_pos(x + i,y + j);
       }
   }
}

int Renderer_ppe::decorate_canberoofed(int x, int y)
{
   int dirs[4];

   int count = 0;

   if (lattice->get(x, y))
      return FALSE;
   
   if (!x || lattice->get(x - 1, y)) /* the room west to us exists or we are at 0 */
      dirs[DIR_W] = TRUE;
   else
      dirs[DIR_W] = FALSE;

   if (x == ppe_map->w - 1 || lattice->get(x + 1, y))
      dirs[DIR_E] = TRUE;
   else
      dirs[DIR_E] = FALSE;

   if (!y || lattice->get(x , y - 1))
      dirs[DIR_N] = TRUE;
   else
      dirs[DIR_N] = FALSE;
      
   if (y == ppe_map->h - 1 || lattice->get(x, y + 1))
      dirs[DIR_S] = TRUE;
   else
      dirs[DIR_S] = FALSE;


   for(int i=0;i<4;i++)
   {
      if (dirs[i])
          count++;
   }


   if (!count)
       return TRUE;

   if (count == 1)
      return TRUE;

   if (count == 2)
   {
      if (dirs[0] == dirs[2])
         return FALSE;

      return TRUE;
   }

   return FALSE;

}


// adds rooftops to a tile depending on the sort of tile aorund it
void Renderer_ppe::decorate_addroofs(int x, int y, int layer)
{
   int dirs[4];
   int count = 0;

   if (!decorate_canberoofed(x,y))
   {
      ppe_map_add_object(ppe_map,x, y, 2, object_from_type(ACTOR_DOOR)->ppe_object[0]);
      return;
   }

   dirs[DIR_W] = !decorate_canberoofed(x-1,y);
   dirs[DIR_E] = !decorate_canberoofed(x+1,y);
   dirs[DIR_N] = !decorate_canberoofed(x,y-1);
   dirs[DIR_S] = !decorate_canberoofed(x,y+1);

   for(int i=0;i<4;i++)
   {
      if (dirs[i])
          count++;
   }

   if (!count)
   {
      ppe_map_add_object(ppe_map,x, y, 2, object_from_type(ACTOR_DOOR)->ppe_object[0]);
      return;
   }


   if (dirs[DIR_W] && !dirs[DIR_E] && !dirs[DIR_N] && !dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_W].ppe_object[0]);
   }

   //! can be rather oprimised

   if (!dirs[DIR_W] && dirs[DIR_E] && !dirs[DIR_N] && !dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_E].ppe_object[0]);
   }
   else if (!dirs[DIR_W] && !dirs[DIR_E] && dirs[DIR_N] && !dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_N].ppe_object[0]);
   }
   else if (!dirs[DIR_W] && !dirs[DIR_E] && !dirs[DIR_N] && dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_S].ppe_object[0]);
   }
   else if (dirs[DIR_W] && !dirs[DIR_E] && dirs[DIR_N] && !dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_NWPUNT].ppe_object[0]);
   }
   else if (dirs[DIR_W] && !dirs[DIR_E] && !dirs[DIR_N] && dirs[DIR_S])
   {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_ROOF_SWPUNT].ppe_object[0]);
   }

}



// adds walls around x,y depending on the sort of rooms next to it
void Renderer_ppe::decorate_addwalls(int x, int y, int layer)
{

        if (!x || lattice->get(x - 1, y)) /* the room west to us exists or we are at 0, add west wall */
        {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_BRICK_W].ppe_object[0]);
        }
        
        if (x == ppe_map->w - 1 || lattice->get(x + 1, y))
        {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_BRICK_E].ppe_object[0]);
        }
           
        if (!y || lattice->get(x , y - 1))
        {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_BRICK_N].ppe_object[0]);
        }

        if (y == ppe_map->h - 1 || lattice->get(x, y + 1))
        {
           ppe_map_add_object(ppe_map,x, y, layer, display_object[R_BRICK_S].ppe_object[0]);
        }

}

void Renderer_ppe::decorate_pos(int x, int y)
{
    Atom *a;
    Electron *top_level_object;
    Display_data *d;
    //! should clear this room, and rebuild it from the main lattice
    // including the adding of walls and other 'decorations'
    // which depend on the neighbouring rooms
    for (int i = 0; i < NUM_PPE_LAYERS ; i++)
        ppe_map_clear(ppe_map, x, y, i);

    a = lattice->get(x, y);

    if (!a)
    {
        ppe_map_add_object(ppe_map,x, y, 2, display_object[R_OUTSIDE_TILE].ppe_object[0]);

        decorate_addwalls(x,y,0);
        decorate_addwalls(x,y,1);
//        decorate_addroofs(x,y,2);


        if (rand() % 100 > 95)
           ppe_map_add_object(ppe_map,x, y, 1, display_object[R_VENTILATORS].ppe_object[0]);
    }
    else
    {
        top_level_object = a->top_level_object;
        ASSERT(top_level_object);

        d = (Display_data *)top_level_object->extra_data;
        ASSERT(d);

        if (top_level_object->actor_type == ACTOR_DOOR)
        {
          d->renderer_object = ppe_map_add_object(ppe_map,x, y, 2, object_from_type(ACTOR_DOOR)->ppe_object[0]);
          decorate_addwalls(x,y,1);
          if (!x || lattice->get(x - 1, y)) /* the room west to us exists or we are at 0, add west wall */
          {
             ppe_map_add_object(ppe_map,x, y, 0, display_object[R_ARCH_W].ppe_object[0]);
          }
          
          if (x == ppe_map->w - 1 || lattice->get(x + 1, y))
          {
             ppe_map_add_object(ppe_map,x, y, 0, display_object[R_ARCH_E].ppe_object[0]);
          }
             
          if (!y || lattice->get(x , y - 1))
          {
             ppe_map_add_object(ppe_map,x, y, 0, display_object[R_ARCH_N].ppe_object[0]);
          }
  
          if (y == ppe_map->h - 1 || lattice->get(x, y + 1))
          {
             ppe_map_add_object(ppe_map,x, y, 0, display_object[R_ARCH_S].ppe_object[0]);
          }
          
          ppe_map_add_object(ppe_map,x, y, 0, display_object[R_SIMPLE_FLOOR].ppe_object[0]);

        }
        else
        {
          d->renderer_object = ppe_map_add_object(ppe_map,x, y, 0, object_from_type(top_level_object->actor_type)->ppe_object[0]);
        }
    }

   //! walk *all* static objects in a tile and tie ppe objects to them
   //! instead of only the top_level one

}
