#include "renderer_ppe.h"

void Renderer_ppe::cons_render() //! naar aparte file
{
   int nrlines = cons_hp() / (text_height(cons_font)+2) + 2;
   int offset = (cons_hp() % (text_height(cons_font)+2)) - (text_height(cons_font)+ 2);
   int cl, fine_offset;
   double sbar = (cons_y[cons_curstream] - cons_curline[cons_curstream]);

   COLOR_MAP *orig;

   set_clip(console_bitmap, 0, (int)cons_y_offset,console_bitmap->w - 1, console_bitmap->h - 1);



   if(cons_transparancy && cons_transparancy != 255)
   {
      orig = color_map;
      color_map = trans_table;
      if (cons_transparancy < 255)
      {
         drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
      }
      else
      {
         drawing_mode(DRAW_MODE_MASKED_PATTERN,stipple_mask,0,0);
      }
      rectfill(console_bitmap,0, (int)cons_y_offset, console_bitmap->w-1, console_bitmap->h-1, darkblue);
      solid_mode();
      color_map = orig;
   }
   else if (!cons_transparancy)
      rectfill(console_bitmap,0, (int)cons_y_offset, console_bitmap->w-1, console_bitmap->h-1, darkblue);


       
   if (sbar < 0)
      sbar += cons_h;

   sbar *= cons_hp();
   sbar /= cons_h;

   if ((frame >> 4) & 1) // cursor
   {
        cons_lines[cons_y[cons_curstream] + cons_stream_offset][cons_x[cons_curstream]] = '_';
        cons_lines[cons_y[cons_curstream] + cons_stream_offset][cons_x[cons_curstream]+1] = 0;
   }
   else
   {
        cons_lines[cons_y[cons_curstream] + cons_stream_offset][cons_x[cons_curstream]] = 0;
   }

   fine_offset = (int)((cons_curline[cons_curstream] - (int)cons_curline[cons_curstream]) * (text_height(cons_font) + 2)) + 1;
   for (int i=0; i < nrlines; i++)
   {
        cl = ((int)cons_curline[cons_curstream] - nrlines + 2 + i);
        while (cl < 0)
           cl += cons_h;
           
        cl %= cons_h;
        text_mode(cons_bgcol);
        textout(console_bitmap, cons_font, cons_lines[cl + cons_stream_offset], 0, i * (text_height(cons_font)+2) + offset - fine_offset + (int)cons_y_offset, cons_color[cl + cons_stream_offset]);
   }

   vline(console_bitmap, console_bitmap->w - 1, 0, console_bitmap->h -1, cons_gray);
   vline(console_bitmap, console_bitmap->w - 1, console_bitmap->h - (int)sbar -1, console_bitmap->h - 1 - (int)(sbar + ((double)nrlines * console_bitmap->h / cons_h)), cons_white);
   set_clip(console_bitmap, 0, 0,console_bitmap->w - 1, console_bitmap->h - 1);
}


void Renderer_ppe::cons_update_logic()
{
   //scroll       //!dit deel moet naar de  het common renderer stuk
   double dist = (cons_curline[cons_curstream] - cons_requested_curline[cons_curstream]);
   if (dist > cons_h/2)
   {
      dist -= cons_h;
   }
   else if (dist < -cons_h/2)
   {
      dist += cons_h;
   }
   cons_curline[cons_curstream] -=  dist/ 10;

   while(cons_curline <0)
       cons_curline += cons_h;
       
   while(cons_curline[cons_curstream] >=cons_h)
       cons_curline[cons_curstream] -= cons_h;

  //move about console window
   dist = cons_y_offset - requested_cons_y_offset;

   cons_y_offset -= dist/20;
}

void Renderer_ppe::cons_pgup()
{
   int nrlines = cons_hp() / (text_height(cons_font)+2);

   cons_scroll_back(nrlines/2+1);
}

void Renderer_ppe::cons_pgdn()
{
   int nrlines = cons_hp() / (text_height(cons_font)+2);

   cons_scroll_back(-nrlines/2-1);
}

void Renderer_ppe::cons_resize(int amount)
{
   if (!cons_transparancy)
       return;

   requested_cons_y_offset -= amount;

   requested_cons_y_offset = MIN(requested_cons_y_offset, SCREEN_H - 2);
   requested_cons_y_offset = MAX(requested_cons_y_offset, 0);

}

int Renderer_ppe::cons_hp()
{
   if (cons_transparancy)
      return (int)(console_bitmap->h - cons_y_offset);

   return console_bitmap->h;

}

void Renderer_ppe::cons_switch_font()
{

   if (cons_font == cons_normal_font)
       cons_font = cons_sml_font;
   else
       cons_font = cons_normal_font;

   cons_vis_w = console_bitmap->w  / text_length(cons_font," ");

   cons_vis_w = MIN(cons_w, cons_vis_w);
}



