/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#ifndef _RENDERER_H_
#define _RENDERER_H_

#include <allegro.h>

#define CONTINUATION_CHAR '\\'
#include "common/object.h"
#include "common/list.h"
#include "common/electron.h"
#include "common/common.h"

class Renderer
 : public Object
{

public:

   // render_w/h are the size of the playfield in pixels
   // console_w/h is in chracters, the size of the console in pixels
   // is defined by the amount of screen size left over next to the playfield
   // if (stretch) then the renderwindow is stretched to match
   // the width of the screen (the picture is still rendered at small size though)
   Renderer(int render_w, int console_w, int console_h, int cons_streams, int stretch, int cons_transparancy, char const *datafile_name);
   ~Renderer();


    virtual int start(int mapsize_x, int mapsize_y) = 0;
    virtual void stop() = 0;

    virtual void is_dirty(List *dirty_list) = 0;
    virtual void render(double camheight, Electron *center, double offset_x, double offset_y) = 0; // renders the playfield

    enum
    {
      RENDER_MODE_NORMAL,
      RENDER_MODE_MAPEDIT
    } _render_modes;
    
    void render_mode(int mode);
    virtual void draw_frame() = 0; // updates the screen, can also be called without a prior 'render' then only the console will be updated
    void advance_logic();
    virtual void screenshot(char *comment) = 0; // saves a screenshot to disc
    void cons_printf(int color, char const *format, ...); // formatted output
    void cons_print(int color, char const *string); // un formatted output (faster)
    void cons_backspace();
    void cons_set_smooth_scroll(int smooth);
    void cons_scroll_back(int lines);

    virtual void show_electron(Electron *) = 0; // should overlay a representation of the electron( and it's parent & children) over the map, calling it with NULL should stop the overlaying
    virtual void cons_pgup() = 0;
    virtual void cons_pgdn() = 0;
    
    int cons_getline(); // returns the current line of the console
    int cons_getcol(); // returns curren color of console
    int cons_getcolumn(); // returns curren column of console
    virtual int cons_width() = 0; // returns the current width of the console in characters,
                                  // depending on which font is selected and the width of
                                  // the bitmap it is rendered to
    int cons_height();
    
    void set_map_height(int min_mapheight, int max_worldheight);
    
    virtual void cons_resize(int amount) = 0; // changes the amount of screenspace the console occupies
    int cons_select_stream(int s);
    int cons_get_stream(); //returns currently slected stream
    void cons_clear();
    virtual void cons_switch_font() = 0;
    int cons_bgcol;
    int cons_wwrap; // word wrap, TRUE or FALSE

    
    int frame;


    // for KAZAM's, ZOOoOoOoOM's, BENG's etc.
    // overlays text on the rendered image
    // the style depends on the renderer, but style 0 is guaranteed to
    // be somewhat neutral and legible ;-)
    // the string may not be deleted until after duration frames
    virtual void overlay_text(char *text, int duration, int style = 0) = 0;
    // the bitmap should be overlayed the next time draw_frame() is called
    virtual void overlay_bitmap(BITMAP *bmp) = 0;


    // effects
    enum
    {
      EFFECT_LASER
    } renderer_effects;

    virtual void effect(int effect, double fx, double fy, double tx, double ty) = 0;

    virtual void show_mouse(int show);

    int lighting_method;
    int speedblur;
    int nausea_level;
    int filtering;

    virtual void cursor(int x, int y);
    virtual void block(int fx, int fy, int tx, int ty);

protected:
   virtual void update_logic() = 0; // updates renderer logic
    virtual void cons_update_logic() = 0; // updates console rendering logic
    void cons_setup(int w, int h,int num_streams);
    void cons_cleanup();

    int _render_mode;

    int cons_numstreams;
    int cons_stream_offset; // offset of the current selected stream in the 'videomemory'
    int cons_curstream;   // currently displayed stream
    char *cons_vidmem; // the 'video memory of this console'
    char **cons_lines; // pointers to the indiviual lines of this vidmem
    int cons_h,cons_w;
    int *cons_x,*cons_y; //cursor position
    double *cons_curline; // the current bottomline of the screen
    int *cons_color;
    int cons_smooth_scroll;
    void cons_mark_end();
    int cons_gray;
    int cons_white;
    void cons_newline(int color);

    int *cons_requested_curline;


    Electron *centered;


    int min_map_height;
    int max_world_height;

    char const *datafile_name;
    
};

extern Renderer *renderer;


#endif
