/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#define RECT_SIZE 10

void print_lattice(BITMAP *onto, Lattice *l)
{
    Atom *a;
    int nr_players;
    
    for (int y = 0; y < l->get_h(); y++)
    {
	for (int x = 0; x < l->get_w(); x++)
	{
	    a = l->get(x, y);
	    
	    if (a)
	    {
		// draw a rectangle

		rect(onto,
		     RECT_SIZE * x, RECT_SIZE * y,
		     RECT_SIZE * (x + 1), RECT_SIZE * (y + 1),
		     makecol(255, 255, 0));

		nr_players = a->get(LIST_PLAYER).size();

		textprintf(onto, font,  
			   RECT_SIZE * x, RECT_SIZE * y,
			   RECT_SIZE * (x + 1), RECT_SIZE * (y + 1),
			   makecol(255, 0, 0),
			   "%d",
			   nr_players);
	    }
	}
    }
}
