/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include "funcs.h"
#include "vars.h"
#include "client/client.h"
#include "client/renderer/renderer.h"

typedef struct VAR
{
   char *var;
   int val;
   int system;
} VAR;


static VAR *variables;
int num_vars;
int max_num_vars;


void vars_init()
{
   variables = NULL;
   num_vars = max_num_vars = 0;
}

void vars_exit()
{

 //! clean up
}


static int find_var(char const *string)
{
   for (int i=0;i<num_vars;i++)
   {
      if (!strncmp(string, variables[i].var, strlen(string)))
      {
         return i;
      }
   
   }
   return -1;
}

static int find_var_exact(char const *string)
{
   for (int i=0;i<num_vars;i++)
   {
      if (!strcmp(string, variables[i].var))
      {
         return i;
      }
   
   }

   return -1;
}

// returns TRUE if it found it, filling val with the value
int checkvar(char *string, int *val)
{

   if (checkfunc(string,val))
       return TRUE;

   int v = find_var_exact(string);

   if (v < 0)
       v = find_var(string);

   if (v >=0)
   {
      if (val)
         *val = variables[v].val;

      return TRUE;
   }
   return FALSE;
}


int add_var(char const *var, int value)
{

   int v = find_var_exact(var);


   if (v >=0)
   {
        if (variables[v].system)
        {
            message("cannot redefine built in variable %s", var);
            return num_vars;
        }
        
        variables[v].val = value;
        return num_vars;
   }


   num_vars++;
   VAR *tmp;

   if (num_vars> max_num_vars)
   {
      max_num_vars+=10;

      tmp = (VAR *)realloc(variables, max_num_vars * sizeof(VAR));
      if (!tmp)
      {
         warning("not enough memory to add variables");
         max_num_vars-=10;
         num_vars--;
         return num_vars;
      }
      variables = tmp;
   }

   variables[num_vars-1].var = sstrdup(var);
   variables[num_vars-1].val = value;
   variables[num_vars-1].system = FALSE;

   return num_vars;
}

int add_sys_var(char const *var, int value)
{

   int v = find_var_exact(var);

   if (v >=0)
   {
        if (variables[v].system)
        {
            fatal("add_sys_var:cannot redefine built in variable %s", var);
            return num_vars;
        }
        
        variables[v].val = value;
        return num_vars;
   }


   num_vars++;
   VAR *tmp;

   if (num_vars> max_num_vars)
   {
      max_num_vars+=10;

      tmp = (VAR *)realloc(variables, max_num_vars * sizeof(VAR));
      if (!tmp)
      {
         fatal("add_sys_var: not enough memory to add variables");
         max_num_vars-=10;
         num_vars--;
         return num_vars;
      }
      variables = tmp;
   }

   variables[num_vars-1].var = sstrdup(var);
   variables[num_vars-1].val = value;
   variables[num_vars-1].system = TRUE;

   return num_vars;
}



void print_var(char *var)
{
   if (!var)
   {
      renderer->cons_printf(lightblue,"user defined variables:\n");
      for (int i=0;i<num_vars;i++)
      {
         if (!variables[i].system)
            renderer->cons_printf(lightblue," %s: %d\n", variables[i].var,variables[i].val);
      }
      renderer->cons_printf(lightblue,"built in variables:\n");
      for (int i=0;i<num_vars;i++)
      {
         if (variables[i].system)
            renderer->cons_printf(lightblue," %s: %d\n", variables[i].var,variables[i].val);
      }

      print_func(NULL);
      return;
   
   }


   if (print_func(var))
       return;

   int v = find_var_exact(var);

   if (v < 0)
       v = find_var(var);

   if (v < 0)
       warning("no such variable: %s", var);
   else
       renderer->cons_printf(lightblue," %s: %d\n", variables[v].var,variables[v].val);
   
}

