/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#ifndef _PARSHLPR_H_
#define _PARSHLPR_H_

#include "client/client.h"

extern void look(int id);
extern void inventory(int id);

extern void pickup(int id);
extern void drop(int id);

extern void put(int to_put, int put_in);

extern void do_enter(int id);
extern void do_exit();


extern char *trim(char *cmd); // cuts off trailing and leading spaces

extern void bind_key();
extern void unbind_key();

// finds the first occurence of 'find' in 'in', return null when not found
// parts enclosed by "'s will not be searched
extern char *find_separator(char *in, char find);

extern void browse(Atom *a, void (*callback)(int result)); // lets the user choose an electron from everything in the current tile
extern void target(Electron *start, void (*callback)(int x, int y)); // lets the user pick a x,y pos and calls callback with it

#endif
