/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "client/keys.h"
#include "parshlpr.h"
#include "client/client.h"
#include "client/commbuf.h"
#include "client/controls.h"
#include "client/renderer/renderer.h"
#include "parse.h"
#include <ctype.h>
#include <string.h>

static int elshow_callback(int k, int shft)
{
   renderer->show_electron(NULL);
   controls_state = CONTROLS_STATE_WAITFORCOMMAND;
   return 0;
}


void look(int id)
{
   Electron *e;

   if (id <= 0)
       e = me->parent;
   else
       e = find_with_id(storage,id);

   if (!e)
   {
      message("Object %d doesn't exist",id);
      return;
   }
   
   if (e->has_hmd())
       message("You are looking at a %s (id = %d, health = %g %% location = %d, %d)", e->type_name, e->actor_id, e->get_h() / 10.0,e->gx(),e->gy());
   else
       message("You are looking at a %s (id = %d, location = %d, %d)", e->type_name, e->actor_id, e->gx(),e->gy());
       
   message("inside it is:");
   if(list_inv(e))
       message("nothing");


   renderer->show_electron(e);
   controls_state = CONTROLS_STATE_WAITFORKEY;
   waitkey_callback = elshow_callback;
   
}

void inventory(int id)
{
   Electron *e;
   
   if (id <= 0)
       e = me;
   else
       e = find_with_id(storage,id);

   if (!e)
   {
      message("Object %d doesn't exist",id);
      return;
   }
   list_inv(e);

}


void pickup(int id)
{
   Electron *e;

   if (!id)
   {
      message("cannot find such an Object");
      return;
   }

   e = find_with_id(storage,id); //! should use currrent location instead of storage
   if (!e)
   {
      message("Object %d doesn't exist",id);
      return;
   }
   message("picking up %d (%s)", e->actor_id, e->type_name);
   cbuf_add_command(C_PICKUP, 0, e->actor_type, e->actor_id);
}

void drop(int id)
{
   Electron *e;

   if (!id)
   {
      message("cannot find such an Object");
      return;
   }
   
   e = find_with_id(storage,id); //! should use currrent location instead of storage

   if (!e)
   {
      message("Object %d doesn't exist",id);
      return;
   }

   message("dropping %d (%s)", e->actor_id, e->type_name);
   cbuf_add_command(C_DROP, 0, e->actor_type, e->actor_id);
}


void put(int to_put, int put_in)
{
   Electron *e, *in;

   if (!to_put || !put_in)
   {
      message("cannot find one of those objects");
      return;
   }

   
   e = find_with_id(storage, to_put); //! should use currrent location instead of storage

   if (!e)
   {
      message("Object %d doesn't exist",to_put);
      return;
   }

   in = find_with_id(storage, put_in);//! should use currrent location instead of storage

   if (!in)
   {
      message("Object %d doesn't exist",put_in);
      return;
   }

   
   cbuf_add_command(C_PUT,0, in->actor_type, in->actor_id,e->actor_type, e->actor_id);
}



void do_enter(int id)
{
   Electron *e;

   if (!id)
   {
      message("cannot find that vehicle");
      return;
   }

   
   if (id <0)
       e = find_vehicle();
   else
       e = find_with_id(storage,id); //! should use currrent location instead of storage

   if (!e)
   {
      message("Object %d doesn't exist",id);
      return;
   }

   message("entering vehicle %d (%s)", e->actor_id, e->type_name);
   cbuf_add_command(C_ENTER,0, e->actor_type, e->actor_id);
       
}

void do_exit()
{
   message("exit");
   cbuf_add_command(C_EXIT);
}


char *trim(char *cmd)
{
//   return cmd;


   char *tail;
   
   while(*cmd && isspace(*cmd))
      cmd++;

   tail = cmd + strlen(cmd) - 1;

   while(tail > cmd && isspace(*tail))
   {
      *tail = 0;
      tail--;
   }

   return cmd;

}

static int key_to_bind, keyshifts_to_bind;

static int bind_key_stringcallback()
{
   add_key(key_to_bind, keyshifts_to_bind, command_buffer);
   print_key(key_to_bind, keyshifts_to_bind);
   controls_state = CONTROLS_STATE_WAITFORCOMMAND;

   command_buffer[0] = 0;
   command_pos = 0;
   
   return 0;
}

static int bind_key_keycallback(int k, int shft)
{
   key_to_bind = k;
   keyshifts_to_bind = shft;
   controls_state = CONTROLS_STATE_WAITFORSTRING;
   waitstring_callback = bind_key_stringcallback;
   message("enter a command to bind to this key");
   return 0;
}

static int unbind_key_keycallback(int k, int shft)
{
   key_to_bind = k;
   keyshifts_to_bind = shft;
   controls_state = CONTROLS_STATE_WAITFORCOMMAND;

   del_key(k,shft);
   no_bound_keys = FALSE;
   return 0;
}


void bind_key()
{
   clear_keybuf();
   message("press a key...");
   controls_state = CONTROLS_STATE_WAITFORKEY;
   waitkey_callback = bind_key_keycallback;
}

void unbind_key()
{
   clear_keybuf();
   message("press a key...");
   controls_state = CONTROLS_STATE_WAITFORKEY;
   waitkey_callback = unbind_key_keycallback;
   no_bound_keys = TRUE; // make sure the bound keys are not evaluated
}


// finds the first occurence of 'find' in 'in', return null when not found
// parts enclosed by "'s will not be searched

char *find_separator(char *in, char fnd)
{
   while(*in)
   {
      if (*in == fnd)
         return in;
         
      if (*in == '"')
      {
         while(*(++in) && (*in != '"')); // first increase 'in' then compare it's (inhoud) with NULL and '"'

         if (*in)    // if (*in) then we are at a "
             in++;
         else
         {
             warning("unmatched \"");
             return NULL;
         }
      }
      else
      {
         in++;
      }
   }

   return NULL;
}




static Electron *browse_curparent;
static Electron *browse_curselected;
static int inv_idx;

static void (*browser_callback)(int result);


static int browsing_callback(int k, int shft)
{
   List *l;
   
   switch((k >> 8))
   {
      case KEY_UP:
       if (browse_curparent->parent)
       {
           browse_curselected = browse_curparent;
           browse_curparent = browse_curparent->parent;

           selection->replace(browse_curselected);

           ASSERT(browse_curparent->inv());

           inv_idx = find_place_in_list(browse_curparent->inv(),browse_curselected);
           renderer->show_electron(browse_curparent);
       }
       break;
      case KEY_RIGHT:
        inv_idx +=2;
        //fall through
      case KEY_LEFT:
        inv_idx--;
        
        l = browse_curparent->inv();


        if (inv_idx <0)
            inv_idx += l->size();

        inv_idx %= l->size();

        browse_curselected = (Electron *)get_from_list_idx(l, inv_idx);

        ASSERT(browse_curselected);
        selection->replace(browse_curselected);
        
        break;
      case KEY_DOWN:
       l = browse_curselected->inv();
      
       if (l && l->size())
       {
           browse_curparent = browse_curselected;
           inv_idx = 0;
           l->reset();
           browse_curselected = (Electron *)l->get();

           ASSERT(browse_curselected);

           selection->replace(browse_curselected);
           renderer->show_electron(browse_curparent);
       }
       break;
      case KEY_ENTER:
       ASSERT(browser_callback);
       ASSERT(browse_curselected);
       controls_state = CONTROLS_STATE_WAITFORCOMMAND;
       block_arrow_keys = FALSE;
       selection->clear();
       browser_callback(browse_curselected->actor_id);
       renderer->show_electron(NULL);
       break;
      case KEY_ESC:
       ASSERT(browser_callback);
       ASSERT(browse_curselected);
       controls_state = CONTROLS_STATE_WAITFORCOMMAND;
       block_arrow_keys = FALSE;
       selection->clear();
       browser_callback(-1);
       renderer->show_electron(NULL);
       break;
   }

   return 0;
}



void browse(Atom *a, void (*callback)(int result))
{
   List *inv;

   browser_callback = callback;
   block_arrow_keys = TRUE;

   if (!a)
       return;

   clear_keybuf();


   browse_curparent = a->top_level_object;

   inv = browse_curparent->inv();

   if (!(inv))
   {
      message(" no objects in this room");
      return;
   }

   inv->reset();

   browse_curselected = (Electron *)inv->get();
   inv_idx = 0;

   if (!browse_curselected)
   {
      message(" no objects in this room");
      return;
   }

   controls_state = CONTROLS_STATE_WAITFORKEY;
   waitkey_callback = browsing_callback;

   selection->replace(browse_curselected);
   renderer->show_electron(browse_curparent);

}



static void (*target_callback)(int x, int y);

static int targeting_callback(int k, int shft)
{
    switch((k >> 8))
    {
      case KEY_UP:
       cursor_y--;
       if (cursor_y < 0)
            cursor_y = 0;
       break;
      case KEY_RIGHT:
       if (cursor_x < lattice->get_w()  - 1)
           cursor_x++;
       break;
      case KEY_LEFT:
        cursor_x--;
       if (cursor_x < 0)
            cursor_x = 0;
       break;
      case KEY_DOWN:
       if (cursor_y < lattice->get_h()  - 1)
           cursor_y++;
       break;
      case KEY_ENTER:
//       ASSERT(target_callback);
       controls_state = CONTROLS_STATE_WAITFORCOMMAND;
       block_arrow_keys = FALSE;
       if (target_callback)
           target_callback(cursor_x, cursor_y);
       show_cursor = FALSE;
       break;
      case KEY_ESC:
       controls_state = CONTROLS_STATE_WAITFORCOMMAND;
       block_arrow_keys = FALSE;
       show_cursor = FALSE;
       break;
    }

    return 0;
}


void target(Electron *start, void (*callback)(int x, int y))
{

   target_callback = callback;
   block_arrow_keys = TRUE;

   if (!start)
       return;

   clear_keybuf();

   controls_state = CONTROLS_STATE_WAITFORKEY;
   waitkey_callback = targeting_callback;


   show_cursor = TRUE;
   cursor_x = start->gx();
   cursor_y = start->gy();
}


