/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include "history.h"
#include "parshlpr.h"
#include "client/client.h"
#include "client/renderer/renderer.h"


#define HIST_BUFLEN 1024
#define HIST_LEN 20


static char history[HIST_LEN][HIST_BUFLEN];
static int cur_histpos;


void hist_init()
{
   for (int i=0;i<HIST_LEN;i++)
   {
       for (int j=0;j<HIST_BUFLEN;j++)
           history[i][j] = 0;
   }
   cur_histpos = 0;
}

void hist_exit()
{
}

void hist_print()
{
   for (int i=HIST_LEN - 1;i>=0;i--)
   {
            renderer->cons_printf(lightblue," %d: %s\n", i, history[(cur_histpos - i + HIST_LEN) % HIST_LEN]);
   }
}

void history_add(char *command)
{
   cur_histpos++;
   cur_histpos%= HIST_LEN;
   sstrncpy(history[cur_histpos], command, HIST_BUFLEN);
}

void hist_find(char *cmd)
{
   int found;
   
   if (strlen(cmd) == 1)
   {
      sstrncpy(cmd,history[cur_histpos], 1024); //!!!! I need to know the length of the command buffer here
      return;
   }

   found  = cmd[1] - '0';
   
   if (found >= 0 && found <10)
   {
      found = strtol(cmd+1,NULL, 10);
      
      found = cur_histpos - found;
      found += HIST_LEN;
      found %= HIST_LEN;
      sstrncpy(cmd,history[found], 1024); //!!!! I need to know the length of the command buffer here
      return;
   }

   for(int i=0;i<HIST_LEN;i++)
   {
      found = cur_histpos - i;
      found += HIST_LEN;
      found %= HIST_LEN;
      if (!strncmp(cmd+1, history[found], strlen(cmd+1)))
      {
         sstrncpy(cmd,history[found], 1024);//!!!! I need to know the length of the command buffer here
         return;
      }
   }

   cmd[0] = 0;
   
   return;
}



