/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include "client/client.h"
#include "funcs.h"
#include "client/renderer/renderer.h"

typedef struct FUNC
{
   char *name;
   int (*func)();
   char *help;
} FUNC;


int me_actor_id()
{
   return me->actor_id;
}


int vehicle_actor_id()
{
   Electron *veh = find_vehicle();


   if (veh)
   {
      return veh->actor_id;
   }

//   message("could not find a vehicle ");

   return 0;
}

int camera_height_minus_one()
{
   return (int)(requested_camheight - 1.1);
}

int camera_height_plus_one()
{
   return (int)(requested_camheight + 1.1);
}


static FUNC funcs[] =
{
   {"me",me_actor_id, "gives the id of the player"},
   {"vehicle", vehicle_actor_id, "gives the id of the first vehicle found at the current location"},
   {"in", camera_height_minus_one, "gives the current camera height minus one, for 'zoom in'"},
   {"out", camera_height_plus_one, "gives the current camera height plus one, for 'zoom out'"},
   {NULL,NULL,NULL}
};


void funcs_init()
{
}

void funcs_exit()
{
}


static int find_func(char *string)
{
   for (int i=0;funcs[i].name;i++)
   {
      if (!strncmp(string, funcs[i].name, strlen(string)))
      {
         return i;
      }
   
   }
   return -1;
}

int find_func_exact(char const *string)
{
   for (int i=0;funcs[i].name;i++)
   {
      if (!strcmp(string, funcs[i].name))
      {
         return i;
      }
   
   }

   return -1;
}

// returns TRUE if it found it, filling val with the value
int checkfunc(char *string, int *val)
{
   int v = find_func_exact(string);

   if (v < 0)
       v = find_func(string);

   if (v >=0)
   {
      if (val)
         *val = funcs[v].func();

      return TRUE;
   }
   return FALSE;
}




int print_func(char *func)
{
   if (!func)
   {
      for (int i=0;funcs[i].name;i++)
      {
         renderer->cons_printf(lightblue," %s : %d \n", funcs[i].name, funcs[i].func());
      }
      return FALSE;
   
   }



   int v = find_func_exact(func);

   if (v < 0)
       v = find_func(func);

   if (v < 0)
   {
      return FALSE;
   }
   else
       renderer->cons_printf(lightblue," %s: %s\n", funcs[v].name,funcs[v].help);

   return TRUE;
}


