/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
// commands for the parser, take care that all tables match eachother

/* this file uses some nasty preprocessor tricks to have the headerfile part
 * and code part in one file for easy editing
 * if _CMD_INCLUDE_CODE_ is definede the code part is used, else the headerfile part is.
 */

#ifndef _CMD_INCLUDE_CODE_

/* add new commands to this enum */
enum PARSER_COMMANDS
{
   P_NORTH = 0,
   P_SOUTH,
   P_WEST,
   P_EAST,
   P_DO_COMMAND,
   P_HELP,
   P_LOOK,
   P_INV,
   P_PICKUP,
   P_DROP,
   P_PUT,
   P_ENTER,
   P_EXIT,
   P_ALIAS,
   P_UNALIAS,
   P_SET,
   P_SHOW,
   P_SETNUMVAR,
   P_GETNUMVAR,
   P_GETSTRINGVAR,
   P_HISTORY,
   P_BIND,
   P_UNBIND,
   P_QUIT,
   P_SCREENSHOT,
   P_ZOOM,
   P_DUMPLIST,
   P_FPS,
   P_SHUTDOWN_SERVER,
   P_SWITCHFONT,
   P_SHOOT,
   P_START_TAG_GAME,
   P_START_TWOTEAM_GAME,
   P_DEBUG,
   P_LAST
} ;

typedef struct PARSER_CMD
{
   char *command;
   char *help;
   int num_args;
   int num_needed_args;
   char *type_args;
} PARSER_CMD;

extern PARSER_CMD parser_commands[];

extern void add_system_aliases();

#else // _CMD_INCLUDE_CODE_

#undef  _CMD_INCLUDE_CODE_
#include "cmds.h"
#define _CMD_INCLUDE_CODE_


/* add new commands here, ther order DOES matter, and must match the above enum */
PARSER_CMD parser_commands[] =
{
 {
   "north",  // command
    NULL,    // help
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "south",  // command
    NULL,    // help
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "west",  // command
    NULL,    // help
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "east",  // command
    NULL,    // help
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "do_command",  // command
   " (debug) send a command packet to the server. Takes 7 arguments: the first is the"
   " command, and the next are it's 5 arguments, omitted arguments are passed as 0."
   " if the last argument is nonzero, only the first half of the packet is send to the"
   " server, to test it's ability to cope with half packets( expect to be thrown out.)",
    7,       // num_args
    1,       // num_needed_args
    "nnnnnn"       // type_args
 },
 {
   "help",  // command
    NULL,    // help
    1,       // num_args
    0,       // num_needed_args
    "s"       // type_args
 },
 {
   "look",  // command
   " lists the items you can pickup, you can optionally specify the id of an Object to look in",
    1,       // num_args
    0,       // num_needed_args
    "n"       // type_args
 },
 {
   "inventory",  // command
   " lists your inventory, you can optionally specify the id of another Object to look in.",
    1,       // num_args
    0,       // num_needed_args
    "n"       // type_args
 },
 {
   "pickup",
   NULL,
   1,
   0,
   "n"
 },
 {
   "drop",
   NULL,
   1,
   1,
   "n"
 },
 {
   "put",
   " takes 2 arguments, puts the firsta Object in the second, both must be in you inventory",
   2,
   2,
   "nn"
 },
 {
   "enter",
   NULL,
   1,
   0,
   "n"
 },
 {
   "exit",
   NULL,
   0,
   0,
   "n"
 },
 {
   "alias",
   "Defines a new command, the command can consist of several commands separated "
   "with ;.The symbols %0 to %9 can be used to specify arguments. Alias without arguments"
   " shows all currently defined aliases.",
   2,
   0,
   "ss"
 },
 {
   "unalias",
   " Removes a previously defined alias.",
   1,
   1,
   "s"
 },
 {
   "set",
   "Defines a new variable. variables can be used everywhere a number can be used. Example"
   " 'set my_motorcycle 351' sets the value of my_motorcyckle to 351, so that you can say "
   " 'enter my_motorcycle'. set without arguments shows all currently defined variables.",
   2,
   0,
   "sn"
 },
 {
   "show",  // command
   " Shows the configuration , or the detected hardware. possible arguments are 'config' , 'system', 'keybindings' and 'version'",    // help
    1,       // num_args
    1,       // num_needed_args
    "n"       // type_args
 },
 {
   "set_numvar",  // command
   " (debug) Sets a numerical variable of an Object,takes 3 arguments, an actor_id the variable number and the new value",    // help
    3,       // num_args
    3,       // num_needed_args
    "nnn"       // type_args
 },
 {
   "get_numvar",  // command
   " (debug) Prints a numerical variable of an Object,takes 2 arguments, an actor_id and the variable number",    // help
    2,       // num_args
    2,       // num_needed_args
    "nn"       // type_args
 },
 {
   "get_stringvar",  // command
   " (debug) Prints a string variable of an Object,takes 2 arguments, an actor_id and the variable number",    // help
    2,       // num_args
    2,       // num_needed_args
    "nn"       // type_args
 },
 {
   "history",  // command
   " shows the history of typed commands ",    // help
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "bind-key",  // command
   " bind-key "
   "will ask you to press a key, and then a command to bind to that key",
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "unbind-key",  // command
   " unbind-key "
   "will ask you to press a key, and remove any previously bound commands from that key",
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "QUIT",  // command
   "will disconnect you from the server and quit the game",
    0,       // num_args
    0,       // num_needed_args
    ""       // type_args
 },
 {
   "screenshot [comment]",  // command
   " screenshot  will save a screenshot to disk, optionally printing a comment on it.",
    1,       // num_args
    0,       // num_needed_args
    "s"       // type_args
 },
 {
   "zoom",  // command
   " 'zoom in' or 'zoom out' will zoom in the camera one down or up, "
   " 'zoom <height>' will zoom the camera to the selected height.",
   1,
   1,
   "n"
 },
 {
   "dump_list_stats",
   " (debug) dumps lots of debug info to the console",
   0,
   0,
   ""
 },
 {
   "fps",
   " (debug) prints the drawn frames per second and some avareages",
   0,
   0,
   ""
 },
 {
   "shutdown_server",
   " sends a shutdown request to the server (if it really shuts down depends on "
   " you privileges on the server",
   0,
   0,
   ""
 },
 {
   "font",
   " switches between wide and narrow fonts ",
   0,
   0,
   ""
 },
 {
   "shoot",
   " 'shoot <x> <y>' shoots at a coordinate, 'shoot <player>' shoots at a player. ",
   2,
   0,
   "nn"
 },
 {
   "start_tag_game",
   "starts a tag game (debugging only)",
   0,
   0,
   ""
 },
 {
     "start_twoteam_game",
     "starts a two-team game (debugging only)",
     0,
     0,
     ""
 },
 {
     "debug <x>",
     "runs debugging command x",
     1,
     0,
     "n"
 }
};


/* system aliases are commands that are implemented as aliases, but for the user look like
 * normal commands (they have help, cannot be overridden etc)
 */
void add_system_aliases()
{
   add_system_alias("turn", "d 8 %0", "turns in the given direction (north east south west)");
   add_system_alias("throttle", "set_numvar lightcycle 3 %0", "sets the throttle of a lightcycle");
}

#endif // _CMD_INCLUDE_CODE_

