/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "client.h"
#include <stdlib.h>
#include <string.h>
#include "keys.h"
#include "parser/parse.h"
#include "keynames.h"

int no_bound_keys = FALSE;

typedef struct KEYCMD
{
   int key;
   int shifts;
   char *command;
} KEYCMD;


static KEYCMD *keys = NULL;
static int nr_keys = 0;
static int max_nr_keys = 0;


static char *kname(int k)
{
   if ((k >> 8 )< max_keys)
   {
      return key_names[k >> 8];
   }
   return "(unknown key)";
}

static int find_key(int k, int kshft)
{
   for (int i=0;i<nr_keys;i++)
   {
      if ((keys[i].key == k) && (keys[i].shifts == kshft))
          return i;
   }

   return -1;

}

void add_key(int k, int kshft, char const *command)
{
   void * tmp;

   int found = find_key(k, kshft);

   if (!kshft && (
                   (k >>8) == KEY_ENTER
                   || (( k>>8) >= KEY_0 && ( k>>8) <= KEY_9)
                   || (( k>>8) >= KEY_A && ( k>>8) <= KEY_A)
                   )
      )
   {
      message("cannot redfine key %s",kname(k));
      return;
   }

   if (found >=0)
   {
      free(keys[found].command);
      keys[found].command = sstrdup(command);
      keys[found].key = k;
      keys[found].shifts = kshft;

      warning("redefining key %d %d to %s",k, kshft, command);
      return;
   }

   
   nr_keys++;
   if (nr_keys > max_nr_keys)
   {
      max_nr_keys +=10;
      tmp = realloc(keys, max_nr_keys * sizeof(KEYCMD));
      if (!tmp)
      {
         warning("not enough memory to add keybinding");
         nr_keys--;
         return;
      }
      keys = (KEYCMD *)tmp;
   }


   keys[nr_keys-1].key = k;
   keys[nr_keys-1].shifts = kshft;
   keys[nr_keys-1].command = sstrdup(command);
   
}


void del_key(int k, int kshft)
{
    int found = find_key(k, kshft);
    
    if (found >=0)
    {
         message("deleting keybinding for key %d, %d (%s)", k, kshft, keys[found].command);
         free(keys[found].command);
         nr_keys--;
         for (int j=found; j<nr_keys;j++)
         {
            keys[j] = keys[j+1];
         }
    }

}


static void pkey(int i)
{
   char buf[1024];

   sstrncpy(buf, "keybinding for key ", 1024);

   if (keys[i].shifts & KB_SHIFT_FLAG)
      sstrncat(buf, "SHIFT-", 1024);
      
   if (keys[i].shifts & KB_CTRL_FLAG)
      sstrncat(buf, "CTRL-", 1024);

   if (keys[i].shifts & KB_ALT_FLAG)
         sstrncat(buf, "ALT-", 1024);

   sstrncat(buf,kname(keys[i].key), 1024);

      
   message("%s : '%s'", buf, keys[i].command);
}

void print_key(int k, int shft)
{
   int found;
   if (k < 0)
   {
      for (int i=0;i<nr_keys;i++)
      {
         pkey(i);
      }
   }
   else
   {
      found = find_key(k, shft);
      if (found >= 0)
         pkey(found);
      else
         message("key %d, %d unbound", k, shft);
   }
}

int check_key(int k, int kshft)
{
   if (no_bound_keys)
       return FALSE;
       
   int found = find_key(k, kshft);

   if (found < 0)
       return FALSE;

   static char savebuffer[MAX_COMMAND_LENGTH];
   int save_command_pos = command_pos;

   // save current content of the command buffer
   sstrncpy(savebuffer, command_buffer, MAX_COMMAND_LENGTH);
   
   sstrncpy(command_buffer, keys[found].command, MAX_COMMAND_LENGTH);
   parse();
   
   // restore content of the command buffer
   sstrncpy(command_buffer, savebuffer, MAX_COMMAND_LENGTH);
   command_pos = save_command_pos;

   return TRUE;

}

extern void init_keys()
{
   char buf[100];
   
   int nr = get_config_int("keybindings","nr_keybindings",0);
   if (!nr)
       return;
       
   int k, s;
   char const *cmd;

   for (int i=0;i<nr;i++)
   {
      ssprintf(buf, 100,"key%d",i);
      k = get_config_int("keybindings", buf, -1);
      ssprintf(buf, 100,"shifts%d",i);
      s = get_config_int("keybindings", buf, -1);
      ssprintf(buf, 100,"cmd%d",i);
      cmd = get_config_string("keybindings", buf, "unreadable");

      if (k >=0 && s >=0 && strcmp(cmd, "unreadable"))
         add_key(k,s,cmd);
      else
         warning("error reading keybinding %d from configfile",i);
   }
   
}

extern void exit_keys()
{
   char buf[100];
   set_config_int("keybindings","nr_keybindings",nr_keys);
   
   for (int i=0;i<nr_keys;i++)
   {
      ssprintf(buf, 100,"key%d",i);
      set_config_int("keybindings", buf, keys[i].key);
      ssprintf(buf, 100,"shifts%d",i);
      set_config_int("keybindings", buf, keys[i].shifts);
      ssprintf(buf, 100,"cmd%d",i);
      set_config_string("keybindings", buf, keys[i].command);

   }

}


