/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        inout.cc
 *
 *        functions for entering and leaving vehicles and the like
 */

#include "inout.h"

void do_drop(Packet_command const *pc)
{
    Electron *dropping;
    Electron *to_drop;

    int atype = pc->arg1;
    int aid =pc->larg2();



    to_drop =  storage->find(atype,aid);

    if (!to_drop)
    {
      severe("Cannot drop Object %d type %d because it doesn't exist",  pc->arg2,pc->arg1);
      return;
    }

    dropping = find_ancestor(to_drop, pc->actor_id);



    if (!dropping)
    {
        dropping = storage->find(pc->actor_type, pc->actor_id);

        if (!dropping)
        {
           severe("Object %d (type %d) cannot drop anything because it doesn't exist", pc->actor_id, pc->actor_type);
        }
        else
        {
           warning("Object %d (%s) cannot drop Object %d (%s), because it is not in it's inventory",
                           pc->actor_id, dropping->type_name,to_drop->actor_id, to_drop->type_name);
        }
    }

#ifdef DEBUGMODE
//    warning("%d (%s) drops %d (%s)",dropping->actor_id, dropping->type_name, to_drop->actor_id, to_drop->type_name);
#endif
    // check if the parent will receive the Object
//    if (!parent->can_be_entered(to_drop))
//        return;
    
    // drop the Object (only if we are really carrying it)
    dropping->inv_drop(to_drop);

    if (to_drop == toplevel_mover || dropping == toplevel_mover)
    {
         ASSERT(me);
         toplevel_mover = find_toplevel_vehicle(me);
    }


}

void do_pickup(Packet_command const *pc)
{
    Electron *to_pickup;

    Electron *picking_up = storage->find(pc->actor_type, pc->actor_id);

    int atype = pc->arg1;
    int aid =pc->larg2();

    if (!picking_up)
    {
        severe("Object %d (type %d) cannot pick anything up because it doesn't exist",
                       pc->actor_id, pc->actor_type);
        return;
    }
    
    Electron *parent = picking_up->parent;
    Atom *a = picking_up->get_atom();
    
    ASSERT(a);


    if (!parent)
    {
      severe("Object %d (%s) cannot pick anything up because it has no parent Object",
                     picking_up->actor_id, picking_up->type_name);
      return;
    }


    // find the item to pickup
    to_pickup = a->find(atype,aid);
    
    // see if the item is in our parents inventory
    if (!to_pickup)
    {
        warning("%d (%s) cannot pickup %d (%d) because it cannot find it at that atom",
                   picking_up->actor_id, picking_up->type_name,
                   aid, atype);
        return;

    }
    
    if (!parent->inv_contains(to_pickup))
    {
        warning("%d (%s) cannot pickup %d (%s) because it is not in it's parent's inventory",
                   picking_up->actor_id, picking_up->type_name,
                   pc->arg1, to_pickup->type_name);
        return;
    }
#ifdef DEBUGMODE
//    warning("%d (%s) picks up %d (%s)",picking_up->actor_id, picking_up->type_name, to_pickup->actor_id, to_pickup->type_name);
#endif

    parent->inv_del(to_pickup);
    picking_up->inv_add(to_pickup);

    if (to_pickup == toplevel_mover || picking_up == toplevel_mover)
    {
         ASSERT(me);
         toplevel_mover = find_toplevel_vehicle(me);
    }


}


 
