/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <signal.h>
#include <stdio.h>
#include "renderer/renderer.h"
#include "srender/srend.h"
#include "renderer/renderer_ppe/renderer_ppe.h"
#include "client.h"
#include "init.h"
#include "clfrlist.h"
#include "dirty.h"
#include "cmdline.h"
#include "configfile.h"

#include "effects.h"
#include "parser/parse.h"
#include "extradat.h"
#include "keys.h"
static void gtimer()
{
    gtime++;
    tickcount++;
}
END_OF_FUNCTION(gtimer);

static void gtimer10()
{
    gtime10++;
}
END_OF_FUNCTION(gtimer);

void init(int argc, char **argv, int mapeditor = FALSE)
{
    static char gfxdata_name[1024], snddata_name[1024];

    int stretch;
    int playfield_w;
    int cons_w;

    // set both stdout& stderr to line buffered
    setvbuf(stdout,NULL, _IOLBF, BUFSIZ); 
    setvbuf(stderr,NULL, _IOLBF, BUFSIZ);

    /* setup allegro */
    allegro_init();



    init_common(CLIENT_FREELIST_LAST - COMMON_FREELIST_LAST);


    init_config();

    if (gfx_s_w == gfx_w)
        gfx_s_w = 0;

    install_timer();
    install_keyboard();
//    set_keyboard_rate(200,180);

    LOCK_FUNCTION(gtimer);
    LOCK_FUNCTION(gtimer10);
    LOCK_VARIABLE(tickcount);
    LOCK_VARIABLE(gtime)
    LOCK_VARIABLE(gtime10)
    
    gtime = 0;
    install_int(gtimer, 10);
    gtime10 = 0;
    install_int(gtimer10, 100);
    install_mouse();

    allegro_message(logo);

    load_config();

    parse_cmdline(argc, argv, mapeditor);
   

    
    /* ignore SIGPIPE, we will see if a connection is closed easily enough
     * and SIGPIPE rudely thows us out
     */
    signal(SIGPIPE, SIG_IGN);
    

    set_color_depth(colordepth);
    if (set_gfx_mode(gfx_card,gfx_w,gfx_h, 0, 0))
        fatal("error setting gfx mode: %s", allegro_error);

    my_generate_332_palette(desktop_palette);

    if (colordepth == 8)
    {
       desktop_palette[0].r = desktop_palette[0].g = desktop_palette[0].b = 0;
       set_palette(desktop_palette);
       clear_to_color(screen, makecol(0,50,0));
       desktop_palette[0].r = desktop_palette[0].b = 63;
       set_palette(desktop_palette);
       
       rgb_map = (RGB_MAP *)malloc(sizeof (RGB_MAP));

        if (!rgb_map)
           fatal("could not allocate RGB mapping table");

        create_rgb_table(rgb_map, desktop_palette, NULL);
    }
    else
       select_palette(desktop_palette);
    
    clear_to_color(screen, makecol(0,50,0));

    red = makecol(255,0,0);
    green = makecol(0,255,0);
    yellow = makecol(255,255,0);
    blue = makecol(0,0,255);
    lightblue = makecol(100,100,255);
    white = makecol(255,255,255);
    orange = makecol(255,100,0);
    cyan = makecol(0,255,255);

    BITMAP *text = create_bitmap(text_length(font, "Loading Data...") + 4, text_height(font) + 4);
    BITMAP *scbuf = create_bitmap(SCREEN_W, SCREEN_H);

    if (text && scbuf)
    {
      clear_to_color(text, makecol(0,50,0));
      text_mode(-1);
      textout_centre(text, font, "Loading Data...",text->w/2,2,makecol(100,0,0));
      stretch_balls(text, scbuf, 0,0, SCREEN_W, SCREEN_H);
  //    stretch_smooth(text, scbuf, 0,0, SCREEN_W, SCREEN_H);
      blit(scbuf,screen,0,0,0,0,SCREEN_W, SCREEN_H);
      
    }
    if (text)
      destroy_bitmap(text);
    if (scbuf)
      destroy_bitmap(scbuf);

    playfield_w = SCREEN_W;
    stretch = FALSE;
    if (gfx_s_w)
    {
        stretch = TRUE;
        playfield_w = gfx_s_w;
    }
    
    cons_w = console_transparancy ? gfx_s_w /4 : gfx_w/4;

    if (!cons_w)
        cons_w = gfx_w/4; // in case gfx_s_w == 0
    if (cmd_gfxdata_name)
    {
        renderer = new Renderer_ppe(playfield_w, cons_w , 400, C_STREAM_LAST , stretch, console_transparancy, cmd_gfxdata_name);
    }
    else
    {
        ssprintf(gfxdata_name, 1024, "%s/data/gfx.dat", get_electron_home());
        renderer = new Renderer_ppe(playfield_w, cons_w , 400, C_STREAM_LAST , stretch, console_transparancy, gfxdata_name);
    }
    if (cons_w < 160)
       renderer->cons_switch_font();

    clear_to_color(screen, makecol(0,0,100));


    renderer->lighting_method = lighting_method;
    renderer->speedblur = speedblur;
    renderer->nausea_level = nausea_level;
    renderer->filtering = filtering;

    if (cmd_snddata_name)
    {
        srenderer = new Sound_renderer(cmd_snddata_name);;
    }
    else
    {
        ssprintf(snddata_name, 1024, "%s/data/sound.dat", get_electron_home());
        srenderer = new Sound_renderer(snddata_name);;
    }


//    SAMPLE *s = load_wav("data/aa.wav");

//    srenderer->one_shot_effect(100,3,3,s);


    sys = new_actor<CSystem>(0);
    storage->lowlevel_add(sys);


    init_dirtylist();

    garbagelist = new List;

    message("Welcome to Electron...", GAME_VERSION_STRING);

    print_version();

    print_config();

    parser_init();

    dummy_player = (CPlayer *)get_electron_from_type(ACTOR_PLAYER, -1);
    if (!dummy_player->extra_data)
        dummy_player->extra_data = new Display_data(dummy_player);

    if (!dummy_player)
    {
      fatal("out of memory creating dummy player Object");
    }

    me = dummy_player;
    init_keys();

    selection = new Selection();

}



void shutdown()
{
    
//    fprintf(stderr,"SHUTDOWN\n");
    delete selection;

    exit_keys();


    parser_exit();


    going_down = TRUE;


    delete_objects(garbagelist); // just in case something is left in (it shouldn't)
    
    delete garbagelist;

    garbagelist = NULL;
    
    shutdown_dirtylist();

//    fprintf(stderr,"SHUTDOWN lattice\n");

    if (lattice)
        delete lattice;

    lattice = NULL;

    delete srenderer;
    
    delete renderer;
    renderer = NULL;

    save_config();
    

//    fprintf(stderr,"done\n");
//    fprintf(stderr,"shutdown common\n");

    shutdown_common();

    allegro_exit();
}
