/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

#include "gameloop.h"
#include "comm.h"
#include "client.h"
#include "controls.h"
#include "dirty.h"
#include "extradat.h"
#include "stser.h"
#include "renderer/renderer.h"
#include "srender/srend.h"

// checks if an electron should be deleted
static int should_be_deleted(Object *o)
{
   Electron *e = (Electron *)o;

   if ((e->actor_type != ACTOR_SYSTEM) && e->gx() == -1 && e->gy() == -1)
      return List::FILTER_MOVE;

   return List::FILTER_LEAVE;

}
// dumps all objects in an atom with postion -1,-1
// into a garbagelist and shreds that
static void garbage_collect(Atom *a)
{


   for (int i=0;i<LIST_LAST;i++)
   {
      a->get(i)->filter(should_be_deleted, garbagelist);
   }

   delete_objects(garbagelist);

}


static void keepup_logic()
{
    unsigned time_elapsed;
    Display_data *d;
    double speed_addheight=0;

    time_elapsed = tickcount;
    tickcount = 0;

    if (time_elapsed >  100)
    {
        time_elapsed = 100;
        renderer->cons_set_smooth_scroll(FALSE);
        warning("cannot keep up framerate");
        renderer->cons_set_smooth_scroll(TRUE);
    }

    while(time_elapsed--)
    {
	renderer->advance_logic();
	ser_stdin_stdout();

        if (show_cursor)
        {
            requested_cam_off_x = cursor_x - me->gx();
            requested_cam_off_y = cursor_y - me->gy();
        }
	cam_off_x += (requested_cam_off_x - cam_off_x) / 50;
	cam_off_y += (requested_cam_off_y - cam_off_y) / 50;
    
	if (me)
	{
	    d = (Display_data *)(find_toplevel_vehicle(me)->extra_data);
	    speed_addheight *= .99;
	    speed_addheight = MAX(speed_addheight,d->speed * 60);
          
	    camheight += (speed_addheight + requested_camheight - camheight) / 30;
	}
	else
	{
	    camheight += (requested_camheight - camheight) / 30;
	}
	//            message("speed %g  ",speed);

	if (me)
	    srenderer->render_sounds(me->gx(), me->gy(), (int)camheight);
    }
}

int mainloop()
{
    unsigned int total_frames = 0, onesec_frames = 0, fivesec_frames = 0;
    unsigned int onesec,fivesec;
    
    playing = TRUE;
    gtime = tickcount = gtime10 = 0;
    onesec = 100;
    fivesec = 500;


    camheight = 199;
    renderer->cons_set_smooth_scroll(TRUE);
    renderer->set_map_height(190, 195);
    controls_state = CONTROLS_STATE_WAITFORCOMMAND;

    walk_frame = 0; // used to adapt repeat rate of arrow keys to the vehicle you use
    
    while (playing)
    {
//        message("TOP LOOP %d", gtime);

        if (me)
        {
            handle_user_input();
        }
        else // when 'me' is still NULL after 30 secs, give up
        {
            if (gtime > 3000000)
               playing = FALSE;
        }



        handle_comms();

        
        if (lattice)
        {
            flush_dirtylist();
            
//            clear(playfield);
            if (me)
            {
                if (show_cursor)
                    renderer->cursor(cursor_x,cursor_y);
                else
                    renderer->cursor(-1, -1);
                
                renderer->render(camheight, me,  cam_off_x, cam_off_y);
            }
        }

        // the renderer has dealt with all deleted objects,
        // so now filter them from the storage atom and delete them
        if (collect_garbage)
           garbage_collect(storage);

        
         renderer->draw_frame();
         total_frames++;
         onesec_frames++;
         fivesec_frames++;
         avfpscount = total_frames * 100.0 / gtime;

         if (gtime > onesec)
         {
            fpscount = onesec_frames;
            onesec_frames = 0;
            onesec = gtime + 100;
         }
         if (gtime > fivesec)
         {
            smoothfpscount = fivesec_frames/5.0;
            fivesec_frames = 0;
            fivesec = gtime + 500;

         }
         keepup_logic();
    }
    renderer->set_map_height(199, 199);
    renderer->cons_set_smooth_scroll(FALSE);
    me = NULL;
    return 0;
}
