/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

#ifndef _EXTRADAT_H_
#define _EXTRADAT_H_

#include "client.h"

class Display_data
 : public Object
{
    public:

    Display_data(Electron *owner);

    void set(Electron *owner);
    void event_go_from_to(int xs, int ys,int xe, int ye, int time);
    void event_turn(int dir, int time);
    
    /* the electron coordinates are meaningless to the display
     * system, since they are set instantaneously on a move command
     */
    double xe,ye;  // end coordinates (in tiles)
    double dx,dy;  // stepsize
    double mvx,mvy; // mean velocities calculated from dx,dy
    double xc,yc;  //  current coordinates in tiles
    
    double angle; // angle 0-255
    double d_angle;
    double angle_end;
    
    int  frame_end;

    int state; // which state is the Object in (walking standig etc)

    int is_active;

    int selected; // if TRUE, the renderer will do somehting to show this object is selected (only works for dynamic objects in ppe renderer)

    int Event;
    double speed;

    void *renderer_object;
    
    private:
    Electron *owner;
 
};


#endif
