/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

#include "extradat.h"
#include "clfrlist.h"
#include "renderer/renderer.h"

Display_data::Display_data(Electron *_owner)
{
    set(_owner);
}

void Display_data::set(Electron *_owner)
{
    owner = _owner;
    is_active = 0;
    angle = 0;
    angle_end = 0;
    d_angle = 0;
    speed = 0;
    dx = dy = 0;
    mvx = mvy = 0;
    xc = xe = owner->gx();
    yc = ye = owner->gy();
    selected = 0;
    renderer_object = NULL;
}

void Display_data::event_go_from_to(int _xs, int _ys,int _xe, int _ye, int time)
{

    double xs, ys;


    if (_xs == -1) //? moet beter
    {
        _xs = _xe;
        _ys = _ye;
    }

    if (is_active)
    {
      xs = xc;
      ys = yc;
    }
    else
    {
      xc = xs = _xs;
      yc = ys = _ys;
    }

    xe = _xe;
    ye = _ye;

    if (!time) // for time 0 don'tr interpolate
    {
        dy = dx = 0;
        speed = 0;
        angle = angle_end;
        xc = xe;
        yc = ye;
      
    }
    else
    {
    
    
        time += 5; // always make it slightly longer, to compensate network lag
                   //! moet instelbaar worden
        if (time < 1)
           time = 1; //? just to be sure
           
        if (_xs != -1 && _xe != -1) //? I only check for x==-1, not also y==-1
        {
            dx = (xe - xs) / time;
            dy = (ye - ys) / time;
            speed = dx * dx + dy * dy;
    
    //        warning(" dx %g dy %g",dx,dy);
    
            angle_end = angle = fixtoi(fatan2(ftofix(dx), ftofix(-dy)));
            d_angle = 0;
            is_active = -1;
            
        }
        else
        {
            speed = 0;
            dx = dy = 0;
            angle = 0;
            d_angle = 0;
            is_active = 0;
            mvx = mvy = 0;
            xc = xe;
            yc = ye;
        }
    
    
           

    }
    frame_end = renderer->frame + time;
}

void Display_data::event_turn(int dir, int time)
{
   int angles_from_dir[] = {0, 64,128,192,0};
   xc = xe;
   yc = ye;
   dx = dy = 0;

   dir %= 4;

   angle_end = angles_from_dir[dir];
   time += 2; // always make it slightly longer, to compensate network lag

   d_angle = (angle_end - angle) / time;

   
   speed = 0;
   frame_end = renderer->frame + time;
   is_active = -1;
}


