/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "effects.h"








/* ridiculously slow */
void stretch_smooth(BITMAP *src, BITMAP *dst, int x,int y, int w, int h)
{
 double scale_x = (double)w /(src->w-1);
 double scale_y = (double)h /(src->h-1);
 V3D_f v[4];
 int c;
 
 if (scale_x < 1 || scale_y <1)
 {
   stretch_blit(src,dst,0,0,src->w,src->h,x,y,w,h);
   return;
 }

// if (bitmap_color_depth(screen) == 8)
// {
/*
   for (int j=0;j<src->h-1;j++)
   {
     for (int i=0;i<src->w-1;i++)
     {
        v[0].x = i * scale_x + x;
        v[0].y = j * scale_y + y;
        v[0].c = getpixel(src,i,j);
        
        v[1].x = (i+1) * scale_x + x;
        v[1].y = j * scale_y + y;
        v[1].c = getpixel(src,i+1,j);
        
        v[2].x = (i+1) * scale_x + x;
        v[2].y = (j+1) * scale_y + y;
        v[2].c = getpixel(src,i+1,j+1);
  
        v[3].x = i * scale_x + x;
        v[3].y = (j+1) * scale_y + y;
        v[3].c = getpixel(src,i,j+1);
  
        quad3d_f(dst, POLYTYPE_GCOL, NULL,v, v+1, v+2, v+3);
     }
   }
 }
 else
 {  */
   for (int j=0;j<src->h-1;j++)
   {
     for (int i=0;i<src->w-1;i++)
     {
        v[0].x = i * scale_x + x;
        v[0].y = j * scale_y + y;
        c = getpixel(src,i,j);
        v[0].c = (getr(c) << 16) + (getg(c) << 8) + getb(c);
        
        v[1].x = (i+1) * scale_x + x;
        v[1].y = j * scale_y + y;
        c = getpixel(src,i+1,j);
        v[1].c = (getr(c) << 16) + (getg(c) << 8) + getb(c);
        
        v[2].x = (i+1) * scale_x + x;
        v[2].y = (j+1) * scale_y + y;
        c = getpixel(src,i+1,j+1);
        v[2].c = (getr(c) << 16) + (getg(c) << 8) + getb(c);
  
        v[3].x = i * scale_x + x;
        v[3].y = (j+1) * scale_y + y;
        c = getpixel(src,i,j+1);
        v[3].c = (getr(c) << 16) + (getg(c) << 8) + getb(c);
  
        quad3d_f(dst, POLYTYPE_GRGB, NULL,v, v+1, v+2, v+3);
     }
   }
/* }*/
}


void stretch_balls(BITMAP *src, BITMAP *dst, int x,int y, int w, int h)
{
   double scale_x = (double)w /(src->w);
   double scale_y = (double)h /(src->h);
   int c;

   for (int j=0;j<src->h;j++)
   {
       for (int i=0;i<src->w;i++)
       {
           c= getpixel(src,i,j);
           ellipsefill(dst,  x + (int)(i * scale_x), y + (int)(j*scale_y), (int )scale_x,(int)scale_y,c);
       }
   }
}

void stretch_balls_mask(BITMAP *src, BITMAP *dst, int x,int y, int w, int h)
{
   double scale_x = (double)w /(src->w);
   double scale_y = (double)h /(src->h);
   int c;

   for (int j=0;j<src->h;j++)
   {
       for (int i=0;i<src->w;i++)
       {
           c= getpixel(src,i,j);
           if (c != bitmap_mask_color(src))
              ellipsefill(dst,  x + (int)(i * scale_x), y + (int)(j*scale_y), (int )scale_x/2,(int)scale_y/2,c);
       }
   }
}
