/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "dirty.h"
#include "renderer/renderer.h"
#include "extradat.h"


static List *dirty_list = NULL;

void init_dirtylist()
{
   dirty_list = new List;
   #ifdef LISTDEBUG
     dirty_list->double_push_allowed = -1;
   #endif
   
}

void shutdown_dirtylist()
{
   delete dirty_list;
}

void flush_dirtylist()
{
   renderer->is_dirty(dirty_list);
}


void add_to_dirtylist(Electron *e, Packet_command const *p)
{
   Display_data *d = (Display_data *)e->extra_data;;
   Electron *lijdend_voorwerp;
   int command = -1;;

   ASSERT(d);

   if (p)
      command = p->command;
      
   if (!p)
      return; //!! info packets not yet supported by display
      
   Atom *a = e->get_atom();


   d->renderer_object = NULL; // will be reset for static objects



//   ASSERT(a);
   if (!a)
   {
//      severe("add_to_dirtylist: %d (%s) has no atom",e->actor_id, e->type_name);
      a = storage; // if it has just been taken out it has no valid atom: take storage
   }

   switch(command)
   {
      case COMMAND_FROM_TO:
       d->event_go_from_to(p->arg1, p->arg2,p->arg3, p->arg4, p->arg5);
       break;

      case COMMAND_PICKUP:
       lijdend_voorwerp = a->find(p->arg1, p->larg2());
       if (!lijdend_voorwerp)
       {
         warning("pickup: could not find Object %d, %d", p->arg1, p->larg2());
         return;
       }
       #ifdef DEBUGMODE
       else
       {
  //       warning("pickup %d %d, %s", p->arg1,p->larg2(),lijdend_voorwerp->type_name);
       }
       #endif
       d = (Display_data *)lijdend_voorwerp->extra_data;
       d->event_go_from_to(-1, -1,-1, -1, 0);
       dirty_list->push(lijdend_voorwerp);

       break;
      case COMMAND_DROP:
      
       lijdend_voorwerp = a->find(p->arg1, p->larg2());
       if (!lijdend_voorwerp)
       {
         warning("drop: could not find Object %d, %d !!!!!!!!!!!!!!!!!!", p->arg1, p->larg2());
         return;
       }
       #ifdef DEBUGMODE
       else
       {
//         warning("drop %d %d, %s", p->arg1,p->larg2(),lijdend_voorwerp->type_name);
       }
       #endif

         //! now *only* objects whose parent is the top_level_object are visible,
         // this is a bit simplistic if we want to do things like ferries/elevators
       if (lijdend_voorwerp->parent == lijdend_voorwerp->get_atom()->top_level_object)
       {
         d = (Display_data *)lijdend_voorwerp->extra_data;

       
         d->event_go_from_to(-1, -1,e->gx(), e->gy(), 0);
         dirty_list->push(lijdend_voorwerp);
       }
       break;
      case COMMAND_TURN:
       d->event_turn(p->arg1,p->arg5);
       break;
      default:
       warning("ignoring unimplemented command for display function");
       break;
   }

   dirty_list->push(e);
   // notify the Object of the change in state
   e->change_state();
   
}
