/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

#include "controls.h"
#include "commbuf.h"
#include "renderer/renderer.h"
#include "common/actors/lightcycle.h"
#include "parser/parse.h"
#include "keys.h"


static int last_cons_line; // the console line on which a command was started

int (*waitkey_callback)(int key, int key_shift) = NULL;
int (*waitstring_callback)() = NULL;

int controls_state = 0;

Electron *find_key()
{
    int x = me->gx();
    int y = me->gy();

    Atom *a = lattice->get(x, y);
    ASSERT(a);



    return (Electron *)((a->get(LIST_KEY))->get_head());
}


static void console_echo_command()
{
    if (
         (!renderer->cons_get_stream()) // only done for stream 0
         &&
         (last_cons_line != renderer->cons_getline())
       )
    {
          cons_startline();
          renderer->cons_print(yellow, prompt());
          renderer->cons_print(yellow, command_buffer);

    }

    last_cons_line = renderer->cons_getline();
}


static void arrow_keys()
{

    if (block_arrow_keys)
        return;
        
    if (gtime > walk_frame && !(key_shifts & KB_CTRL_FLAG) && !(key_shifts & KB_ALT_FLAG))
    {
        if (key[KEY_UP])
        {
           for (int i=0;i<command_pos;i++)
               renderer->cons_backspace();
           renderer->cons_print(yellow, "north\n");
           cbuf_add_command(C_MOVEPLAYER, DIR_N);
           walk_frame = gtime + 10;
//           warning("kpressed setting wf to %d (gtime %d) mover %d(%s)", walk_frame, gtime, toplevel_mover ? toplevel_mover->actor_id : 0, toplevel_mover ? toplevel_mover->type_name : "null");
        }
        else if (key[KEY_DOWN])
        {
           for (int i=0;i<command_pos;i++)
               renderer->cons_backspace();
           renderer->cons_print(yellow, "south\n");
           cbuf_add_command(C_MOVEPLAYER, DIR_S);
           walk_frame = gtime + 10;
//           warning("kpressed setting wf to %d (gtime %d) mover %d(%s)", walk_frame, gtime, toplevel_mover ? toplevel_mover->actor_id : 0, toplevel_mover ? toplevel_mover->type_name : "null");
        }
        else if (key[KEY_RIGHT])
        {
           for (int i=0;i<command_pos;i++)
               renderer->cons_backspace();
           renderer->cons_print(yellow, "east\n");
           cbuf_add_command(C_MOVEPLAYER, DIR_E);
           walk_frame = gtime + 10;
//           warning("kpressed setting wf to %d (gtime %d) mover %d(%s)", walk_frame, gtime, toplevel_mover ? toplevel_mover->actor_id : 0, toplevel_mover ? toplevel_mover->type_name : "null");
        }
        else if (key[KEY_LEFT])
        {
           for (int i=0;i<command_pos;i++)
               renderer->cons_backspace();
           renderer->cons_print(yellow, "west\n");
           cbuf_add_command(C_MOVEPLAYER, DIR_W);
           walk_frame = gtime + 10;
//           warning("kpressed setting wf to %d (gtime %d) mover %d(%s)", walk_frame, gtime, toplevel_mover ? toplevel_mover->actor_id : 0, toplevel_mover ? toplevel_mover->type_name : "null");
        }
    }

}


static void check_stream_switch(int s)
{
    static char ovtext_for_switch_message[100];
    
    if ((key_shifts & KB_ALT_FLAG) && (s - KEY_1) >= 0 && (s - KEY_1) <=8)
    {
        renderer->cons_select_stream((s - KEY_1));
        if (renderer->cons_get_stream() == (s - KEY_1))
        {
//                    cons_startline();
            ssprintf(ovtext_for_switch_message, 100,"switched to stream %d",(s - KEY_1));
            renderer->overlay_text(ovtext_for_switch_message, 100);
        }
    }
}


// CTRL-U , ENTER, BACKSPACE
static void editing_keys(int s)
{
   if ((key_shifts & KB_CTRL_FLAG))
   {
      switch(s)
      {
         case KEY_U:
          while(command_pos)
          {
           command_pos--;
           command_buffer[command_pos] = 0;
           renderer->cons_backspace();
          }
         break;
        default:
         break;
      }
   }
   
   if (s == KEY_BACKSPACE)
   {
   
       if (command_pos)
       {
           command_pos--;
           command_buffer[command_pos] = 0;
           renderer->cons_backspace();
       }
       return;
   }

   if (s == KEY_ENTER)
   {
       command_buffer[command_pos] = 0;
       renderer->cons_printf(yellow,"\n");

       // unless redefined by the callback, the state is always set back to
       // waitforcommand
       controls_state = CONTROLS_STATE_WAITFORCOMMAND;
       waitstring_callback();
       
       return;
   }
}

static void camera_keys(int s)
{
   
   switch(s)
   {
       case KEY_UP:
   //             message("north %d", gtime);
        if ((key_shifts & KB_CTRL_FLAG))
        {
            requested_cam_off_y-=.5;
        }
        break;
       case KEY_DOWN:
        if ((key_shifts & KB_CTRL_FLAG))
        {
            requested_cam_off_y+=.5;
        }
        break;
       case KEY_LEFT:
        if ((key_shifts & KB_CTRL_FLAG))
        {
            requested_cam_off_x-=.5;
        }
        break;
       case KEY_RIGHT:
        if ((key_shifts & KB_CTRL_FLAG))
        {
            requested_cam_off_x+=.5;
        }
        break;
   
       case KEY_PGUP:
        if ((key_shifts & KB_CTRL_FLAG))
            renderer->cons_resize(10);
        else
            renderer->cons_pgup();
        break;
       case KEY_PGDN:
        if ((key_shifts & KB_CTRL_FLAG))
            renderer->cons_resize(-10);
        else
            renderer->cons_pgdn();
        break;
       
   }

}

static void prepare_process_input()
{
    // if scrolling has interfered with our half typed command, reprint it
    console_echo_command();

    // reset camera offset to 0
    if (!(key_shifts & KB_CTRL_FLAG))
    {
        requested_cam_off_x = requested_cam_off_y = 0;
    }

    // arrow keys are checked with a variable repeat rate
    // depending on the vehicle
    arrow_keys();

}

static void process_stringwait_input(int a, int s)
{
    static char charbuf[2] = {0,0};

    if ((a< ' ') || (key_shifts & KB_CTRL_FLAG) || (key_shifts & KB_ALT_FLAG))
    {
         editing_keys(s);
    }
    else
    {
         if (command_pos >= MAX_COMMAND_LENGTH - 1)
               return;
        
         command_buffer[command_pos] = a;
         command_pos++;
         command_buffer[command_pos] = 0;
        
         /* a is an ascii char here */
         charbuf[0] = a;
         renderer->cons_print(yellow,charbuf);
    }


    return;

}



void handle_user_input()
{
    int k,  a, s;

    prepare_process_input();

    // process all pressed keys
    while(keypressed())
    {
        k = readkey();
        a = k & 0xFF; // ascii value
        s = k >> 8;   // scancode

        check_stream_switch(s);
        camera_keys(s);
    
         
        switch(controls_state)
        {
            case CONTROLS_STATE_WAITFORKEY:
               ASSERT(waitkey_callback);
               waitkey_callback(k, key_shifts);
               playing = TRUE; // make sure we never quit the game in the middle of something
            break;
            case CONTROLS_STATE_WAITFORSTRING:
               ASSERT(waitstring_callback);
               process_stringwait_input(a, s);
               break;
            default:
            //fallthrough
            case CONTROLS_STATE_WAITFORCOMMAND:
               // check bound keys
               if (check_key(k, key_shifts))
                  continue;
               
               waitstring_callback = parse;
               process_stringwait_input(a, s);
            break;
        }
    }
}

