/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "config.h"
#include "client.h"
#include "choose.h"


void save_config()
{
   char buffer[100];
   set_config_int("preferences","resolution", gfx_w);
   set_config_int("preferences","perspective", perspective_fact);
   set_config_int("preferences","scaled_res", gfx_s_w);
   set_config_int("preferences","lighting_method", lighting_method);
   set_config_int("preferences","colordepth", colordepth);
   set_config_int("preferences","console_transparancy", console_transparancy);
   set_config_int("preferences","filter", filtering);
   set_config_int("hosts","number_of_hosts",number_hosts);
   set_config_int("hosts","last_used",selected_server );
   set_config_int("preferences","speedblur", speedblur);
   set_config_int("preferences","nausea_level", nausea_level);
   for (int i=0;i<number_hosts;i++)
   {
      sprintf(buffer,"hostname%d",i);
      set_config_string("hosts",buffer, hostnames[i]);
      free(hostnames[i]);
      
      sprintf(buffer,"port%d",i);
      set_config_int("hosts",buffer, ports[i]);
   }

   number_hosts = 0;
   
}

void load_config()
{
   char buffer[100];
   set_config_file("electron.cfg");

   gfx_w = get_config_int("preferences","resolution",640);
   gfx_h = gfx_w * 3 / 4;
   perspective_fact = get_config_int("preferences","perspective", 2);
   gfx_s_w = get_config_int("preferences","scaled_res", 0);
   console_transparancy = get_config_int("preferences","console_transparancy", 0);
   speedblur = get_config_int("preferences","speedblur", 0);

   colordepth = get_config_int("preferences","colordepth", 16);
   filtering = get_config_int("preferences","filter", 0);
   nausea_level = get_config_int("preferences","nausea_level", 1);
   lighting_method = get_config_int("preferences","lighting_method", 0);
   if (lighting_method > 1 || lighting_method < 0) //? moet beter
       fatal("unkown lighting method");


   number_hosts = get_config_int("hosts","number_of_hosts",0);

   number_hosts = MIN(number_hosts, MAX_REMEMBERED_HOSTS);

   selected_server = get_config_int("hosts","last_used",0);
   
   for (int i=0;i < number_hosts;i++)
   {
      sprintf(buffer,"hostname%d",i);
      hostnames[i] = sstrdup(get_config_string("hosts",buffer, "unknown"));
      sprintf(buffer,"port%d",i);
      ports[i] = get_config_int("hosts",buffer, 5000);
   }

}


void print_config()
{
   char *lighting_methods[] = {"off", "vertex"};

   if (lighting_method > (int)(sizeof(lighting_methods)/ sizeof(char *)))
      fatal("unkown lighting method");

   message("configuration:");
   message(" display resolution: %d x %d", gfx_w, gfx_h);
   if (gfx_s_w)
   {
      if (!console_transparancy)
         message("  internal rendering resolution: %d x %d", gfx_s_w , gfx_s_w * 380 / 640);
      else
         message("  internal rendering resolution: %d x %d", gfx_s_w , gfx_s_w * 480 / 640);
   }
   message(" color depth: %d bits per pixel", colordepth);
   message(" lighting method : %s", lighting_methods[lighting_method]);
   message(" console transparancy: %d percent", console_transparancy * 100 / 255);
   if (console_transparancy && console_transparancy < 255)
   {
      if (speedblur)
          message(" speed blur: on");
      else
          message(" speed blur: off");
   }
   else
       message(" speed blur: not possible");

   message(" used datafile: %s", datafile_name);
   message("");

}
