/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
 /* communications buffer, an array of commands to send in the next
  * communication step, typed/calculated commands for the server are collected in this
  * buffer and sent at the next communication step
  * the actual packets to send are determined in the outgoing() function
  */

#ifndef _COMMBUFF_H_
#define _COMMBUFF_H_

#include "client.h"
#define MAX_COMMANDS 100

enum COMMANDS_TO_SEND
{
    C_MOVEPLAYER, //move player in direction (n,e,s,w) (Object is ignored)
    C_TURNPLAYER, //move player in direction (n,e,s,w) (Object is ignored)
    C_MOVETO,     // move any Object to another location
    C_ENTER,      // Object is set to the id to enter, arg to it's type
    C_EXIT,       // exits the current vehicle, Object=id, arg=type
    C_PICKUP,
    C_DROP,
    C_PUT,         // actor_type/id used for picking_up, var_id,x for to_pickup
    C_SENDSTRING,  // send string to server to broadcast to all other players
    C_NUMPACK,     // send generic Packet_info_num
    C_STRINGPACK,     // send generic Packet_info_num
    C_VECTPACK,     // send generic Packet_info_num
    C_COMMANDPACK,     // send generic Packet_command
    C_LAST
};



typedef struct CLIENT_COMMAND
{
    int command;   // what to do
    int actor_type; // 2 args to indicate objects other than the player itself
    int actor_id; //
    int a;      // extra argument for whatever
    int var_id;
    int x, y;     // coordinate arguments
    char *string;
    int c,a1,a2,a3,a4,a5; // command packet arguments
    int bugserver;
} CLIENT_COMMAND;


extern CLIENT_COMMAND *commbuf;
extern CLIENT_COMMAND commbuf1[MAX_COMMANDS];
extern CLIENT_COMMAND commbuf2[MAX_COMMANDS];
extern int nr_commands_in_buffer;
extern int nr_commands_in_buffer_last_time;
extern Packet *bouncepacket;

extern void cbuf_add_command(int command, int a = 0, int actor_type = -1,int actor_id = -1, int var_id = 0,int x = 0, int y = 0, char *string = NULL, int bugserver = 0 );
extern void cbuf_add_generic_commandpacket(int command,int actor_type = -1,int actor_id = -1,int a1=0, int a2=0, int a3=0, int a4=0, int a5=0,int bugserver = 0 );
extern void cbuf_add_generic_numpacket(int actor_type,int actor_id,int var_id,int var_value,int bugserver = 0 );
extern void cbuf_add_generic_stringpacket(int actor_type,int actor_id,int var_id,char *var_value,int bugserver = 0 );
#endif

