/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
 /* communications buffer, an array of commands to send in the next
  * communication step, typed/calculated commands for the server are collected in this
  * buffer and sent at the next
  */

#include "commbuf.h"

CLIENT_COMMAND commbuf1[MAX_COMMANDS];
CLIENT_COMMAND commbuf2[MAX_COMMANDS];
CLIENT_COMMAND *commbuf = commbuf1;
int nr_commands_in_buffer = 0;
int nr_commands_in_buffer_last_time = 0;

Packet *bouncepacket = NULL;


void cbuf_add_command(int command, int a = 0, int actor_type = -1,int actor_id = -1, int var_id = 0,int x = 0, int y = 0, char *string = NULL, int bugserver )
{
    if (nr_commands_in_buffer >= MAX_COMMANDS)
    {
       warning("command buffer full");
       return;
    }

    if (actor_type == -1 && actor_id == -1)
    {
      actor_type = me->actor_type;
      actor_id = me->actor_id;
    }
    
    commbuf[nr_commands_in_buffer].actor_id = actor_id;
    commbuf[nr_commands_in_buffer].actor_type = actor_type;
    commbuf[nr_commands_in_buffer].command = command;
    commbuf[nr_commands_in_buffer].var_id = var_id;
    commbuf[nr_commands_in_buffer].a = a;
    commbuf[nr_commands_in_buffer].x = x;
    commbuf[nr_commands_in_buffer].y = y;
    commbuf[nr_commands_in_buffer].string = string;
    commbuf[nr_commands_in_buffer].bugserver = bugserver;
    nr_commands_in_buffer++;
}

extern void cbuf_add_generic_numpacket(int actor_type,int actor_id,int var_id,int var_value, int bugserver)
{
    if (nr_commands_in_buffer >= MAX_COMMANDS)
    {
       warning("command buffer full");
       return;
    }

    if (actor_type == -1 && actor_id == -1)
    {
      actor_type = me->actor_type;
      actor_id = me->actor_id;
    }

    commbuf[nr_commands_in_buffer].command = C_NUMPACK;
    commbuf[nr_commands_in_buffer].actor_id = actor_id;
    commbuf[nr_commands_in_buffer].actor_type = actor_type;
    commbuf[nr_commands_in_buffer].var_id = var_id;
    commbuf[nr_commands_in_buffer].a = var_value;
    commbuf[nr_commands_in_buffer].bugserver = bugserver;
    
    nr_commands_in_buffer++;

}

void cbuf_add_generic_commandpacket(int command,int actor_type = -1,int actor_id = -1,int a1, int a2, int a3, int a4, int a5, int bugserver)
{
    if (nr_commands_in_buffer >= MAX_COMMANDS)
    {
       warning("command buffer full");
       return;
    }

    if (actor_type == -1 && actor_id == -1)
    {
      actor_type = me->actor_type;
      actor_id = me->actor_id;
    }
    
    commbuf[nr_commands_in_buffer].actor_id = actor_id;
    commbuf[nr_commands_in_buffer].actor_type = actor_type;
    commbuf[nr_commands_in_buffer].command = C_COMMANDPACK;
    commbuf[nr_commands_in_buffer].c = command;
    commbuf[nr_commands_in_buffer].a1 = a1;
    commbuf[nr_commands_in_buffer].a2 = a2;
    commbuf[nr_commands_in_buffer].a3 = a3;
    commbuf[nr_commands_in_buffer].a4 = a4;
    commbuf[nr_commands_in_buffer].a5 = a5;
    commbuf[nr_commands_in_buffer].bugserver = bugserver;

    nr_commands_in_buffer++;

}


extern void cbuf_add_generic_stringpacket(int actor_type,int actor_id,int var_id,char *var_value, int bugserver)
{
    if (nr_commands_in_buffer >= MAX_COMMANDS)
    {
       warning("command buffer full");
       return;
    }

    if (actor_type == -1 && actor_id == -1)
    {
      actor_type = me->actor_type;
      actor_id = me->actor_id;
    }

    commbuf[nr_commands_in_buffer].command = C_STRINGPACK;
    commbuf[nr_commands_in_buffer].actor_id = actor_id;
    commbuf[nr_commands_in_buffer].actor_type = actor_type;
    commbuf[nr_commands_in_buffer].var_id = var_id;
    commbuf[nr_commands_in_buffer].string = sstrdup(var_value);
    commbuf[nr_commands_in_buffer].bugserver = bugserver;
    
    nr_commands_in_buffer++;
}



