/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * all client-server communication, the connection is not known outside
 * this file.
 */

#include "renderer/renderer.h"
#include "client.h"
#include "comm.h"
#include "map.h"
#include "commbuf.h"
#include "dirty.h"
#include "extradat.h"
#include "inout.h"
#define TIMEOUT 1000 // timeout value for wait_packet, in centiseconds

static Plug *the_connection = NULL;

/*
 * wait (max 1 second) for an incoming packet
 */
 
static Packet const *wait_packet(Plug *c)
{
    Packet const *p;

    gtime = 0;
    while(!(p = read_packet_static(c)) && gtime < TIMEOUT );

    if (!p)
    {
       severe("Time out in wait_packet");
       return NULL;
    }
    if (p->err)
       fatal("Error in packet: %s", p->error);

    return p;

}


void testconnection(char *_servername, int _port)
{
    Packet const *p;
    int count=0;

    set_gfx_mode(GFX_TEXT,0,0,0,0);
    the_connection = new Plug(_servername, _port);

    if (!the_connection)
    {
        printf("no connection\n");
        exit(COMM_TRY_AGAIN);
    }

    if (the_connection->open())
    {
        severe("Could not open connection");
        exit(COMM_TRY_AGAIN);
    }
 


    printf("ok starting loop\n");

    while(!key[KEY_ESC])
    {
        printf("wait-----------\n");
        p = wait_packet(the_connection);

        printf("write+++++++++ \n");
        Packet_command::write_to(the_connection, 0, 0, 0,0,0,0,0);
        count++;
    }
    

    printf("%d packets pingponged\n",count);
}



/*
 * called from setup_connection, reads the
 * map stats
 */

static int setup_read_map_stats()
{

    Packet const *p;

    p =  wait_packet(the_connection);

//    warning("got stringpacket with mapname");

    if (!(Packet_info_string::expect(p, ACTOR_SYSTEM, SYS_VAR, System::MAP_NAME)))
       return FALSE;

    mapname = sstrdup(((Packet_info_string *)p)->get_string());
    message("mapname = %s", mapname);

    p =  wait_packet(the_connection);

//    warning("got packet with size");
//    print_packet(p);

    if (!(Packet_info_vect::expect(p, ACTOR_SYSTEM, SYS_VAR, System::MAP_SIZE)))
       return FALSE;

//    message("size = ok", mapname);

    Packet_info_vect *pv = (Packet_info_vect *)p;

    map_w = pv->var_x;
    map_h = pv->var_y;
//    start_renderer(pv->var_x, pv->var_y);

    message("Map:", mapname);
    message(" name: %s", mapname);
    message(" dimensions: %d x %d", map_w, map_h);


    return TRUE;


}

/*
 * tries to setup a connection to specified adress
 * handles all inital handshake with the server and asks confirmation from the
 * player to join the game
 * returns COMM_TRY_AGAIN whenever the connection  fails or the user cancels
 * and COMM_GOT_CONNECTION when it is successfully set up.
 */


int setup_connection(char *_servername, int _port)
{
    Packet const *p;
    char **player_names = NULL;
    int num_players;

    message("Contacting server at %s port %d", _servername, _port);
/*
    the_connection = new Plug(_servername, _port);


    if (the_connection->open())
    {
        severe("Could not open connection");
        return COMM_TRY_AGAIN;
    }

    the_connection->close();
    
    delete the_connection;
  */
    the_connection = new Plug(_servername, _port);
    if (the_connection->open())
    {
    
        severe("Could not open connection");
        return COMM_TRY_AGAIN;
    }

    connection_valid = TRUE;

    /* wait for lifesigns of server */
    message("Opened connection, wait for answer", _servername, _port);
    p = wait_packet(the_connection);
    

    if (bugserver == 1)
        abort();

    if (!Packet_info_num::expect(p, ACTOR_SYSTEM))
    {
        severe("Got illegal communication packet from the server");
        the_connection->close();
        connection_valid = FALSE;
        return COMM_TRY_AGAIN;
    }
    
    if (Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_MESSAGE, System::STC_I_AM_FULL_GET_LOST))
    {
        severe("Server is full");
        the_connection->close();
        connection_valid = FALSE;
        return COMM_TRY_AGAIN;
    }
    else if (!Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_VAR, System::VERSION_INT, COMM_VERSION_INT))
    {
        Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::WRONG_VERSION_NUMBER, 0);
        severe("Error reading the communication version number");
        the_connection->close();
        connection_valid = FALSE;
        return COMM_TRY_AGAIN;
    }

    
    /* send my version nr to server */
    Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_VAR, System::VERSION_INT, COMM_VERSION_INT);

    message("The server's version number is ok, waiting for numbert of players");

    if (bugserver == 2)
        abort();
    
    /* wait for answer */
    p = wait_packet(the_connection);


    if (!(Packet_info_num::expect(p, ACTOR_SYSTEM, SYS_VAR, System::NUM_PLAYERS)))
    {
       severe("error reading number of players from server");
       print_packet(p);
       severe("");
       the_connection->close();
        connection_valid = FALSE;
       return COMM_TRY_AGAIN;
    }

    num_players = ((Packet_info_num *)p)->var_value;


    if (num_players)
    {
       player_names = (char **)malloc(sizeof(char *) * num_players);
       
       if (!player_names)
       {
          the_connection->close();
          fatal("out of memory");
       }
       for (int i=0;i<num_players;i++)
       {
           p = wait_packet(the_connection);
           if (!(Packet_info_string::expect(p, ACTOR_SYSTEM, SYS_MESSAGE, System::STC_PLAYER_NAME)))
           {
              severe("expected to get playername %d from server (and didn't)", i);
              the_connection->close();
              connection_valid = FALSE;
              return COMM_TRY_AGAIN;
           }
           player_names[i] = sstrdup(((Packet_info_string *)p)->get_string());
       }
    }
    message("%d players in this game:", num_players);

    for (int i=0; i<num_players; i++)
    {
        message("player %d: %s", i+1, player_names[i]);
    }
    
    if (!setup_read_map_stats())
    {
        free(player_names);
        the_connection->close();
        connection_valid = FALSE;
        severe("error reading map stats");
        return COMM_TRY_AGAIN;
    }


    message("Do you want to join this game?");
    message("press y or n");


    if (bugserver == 3)
        abort();

//  int key = readkey();
    int key = KEY_Y << 8;

    if ((key >> 8) == KEY_Y)
    {
       Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::CTS_INTERESTED_YN, SYS_YES);
    }
    else
    {
       Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::CTS_INTERESTED_YN, SYS_NO);
       the_connection->close();
       connection_valid = FALSE;
       return COMM_TRY_AGAIN;
    }

    renderer->start(map_w, map_h);

    Packet_info_string::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::CTS_MY_NAME, random_name());
    
//    fatal("ok you're in");
    
    if (player_names)
    {
      for (int i = 0;i< num_players;i++)
          free(player_names[i]);
      
      free(player_names);
    }
    return COMM_GOT_CONNECTION;
    
}

void handle_system_packet(Packet const *p)
{
    const Packet_info_vect *pv;
    const Packet_info_num *pn;
    const   Packet_info_string *ps;
//    const Packet_command *pc;

   if (p->actor_id == SYS_MESSAGE)
   {
       if (Packet_info_num::expect(p))
       {
           pn = (Packet_info_num *)p;
   
           switch(pn->var_id)
           {
               case System::STC_YOU_ARE:
                   me = (Player *)(storage->find(ACTOR_PLAYER, pn->var_value));
                   if (!me)
                   {
                       severe("tried to set you (the player) to a non-existant Object");
                       me = dummy_player;

                   }
                   else if (!(me->actor_type == ACTOR_PLAYER))
                   {
                       severe("tried to set you (the player) to a non-player Object");
                   }

                   toplevel_mover = find_toplevel_vehicle(me);
                break;
               case System::HANGUP:
                 severe("The server just closed the connection (got System::HANGUP packet)");
                 playing = FALSE;
                break;
               case System::INVALID_PACKET:
                 severe("The server just accused us of sending an invalid packet, and closed\n"
                        "the connection. I dumped the last %d commands to lastcomm.bin (literal dump of commbuf array)",
                        nr_commands_in_buffer_last_time);
                        
                 {
                    FILE *dump = fopen("lastcomm.bin", "w");
                    if (dump)
                    {
                        fwrite(commbuf == commbuf1 ? commbuf2 : commbuf1, sizeof(CLIENT_COMMAND), nr_commands_in_buffer_last_time, dump);
                        fclose(dump);
                    }
                 }
                 
                 playing = FALSE;
                break;

               case System::PING_ARE_YOU_THERE:
                    if (bugserver == 5)
                        abort();
                    Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::PING_YES_IM_HERE, pn->var_value);
                    
                break;
               case System::STC_YER_DEAD:
                    message("You have just died...");
                break;

               default:
                break;
           }
   
       }
       else if (Packet_info_string::expect(p))
       {
           ps = (Packet_info_string *)p;
           switch(ps->var_id)
           {
               case System::STC_MESSAGE:
                cons_startline();
                renderer->cons_print(cyan, ps->get_string());
                break;

               default:
                break;
           }
       }
   }
   else
   {
       if (Packet_info_vect::expect(p, ACTOR_SYSTEM, SYS_VAR, System::MAP_SIZE))
       {
           pv = (Packet_info_vect *)p;
           setup_map(pv->var_x, pv->var_y);
       }
       if (p->get_type() != TYPE_COMMAND)
           set_electron_var(sys, p);
   }

}
/* called from handle_comms
 * handles all incoming communications from the server
 * reads all available packets from the net and stores variables/ carries out commands
 * it adds all objects it modifies to a dirty List for the display routines
 */

static void incoming()
{
//    const Packet_info_vect *pv;
//    const Packet_info_num *pn;
//  const   Packet_info_string *ps;
    const Packet_command *pc;
    Electron *about;
    const Packet *p;
    Atom *a;

//    message(" read_packet at %d", gtime);
    while((p = read_packet_static(the_connection)))
    {
//        print_packet(p);
//          message(" got packet at %d", gtime);

        // check for errors while reading
        if (p->err)
        {
            warning("incoming: error occurred in read_packet_static");
            warning("Packet::error : %s", Packet::error);
            severe("closing connection");
            connection_valid = FALSE;
            return;
        }
        
        if (p->actor_type == ACTOR_SYSTEM)
        {
            handle_system_packet(p);
            continue; /* use continue instead of else, to make indent level not toooo deep */
        } /* end of system messages */

        if (!lattice)
            fatal("don't have map yet");

        switch(p->get_type())
        {
            case TYPE_COMMAND:
             pc = (Packet_command *)p;
             switch(pc->command)
             {
                case COMMAND_FROM_TO:
//                 print_packet(p);

//                 the_console->printf(makecol(255,255,0), "got COMMAN_FROM_TO %d %d %d %d %d at %d\n", pc->arg1, pc->arg2, pc->arg3, pc->arg4, pc->arg5, gtime);
                 if (pc->arg1 == -1 && pc->arg2 == -1) /* new Object */
                 {

                     if (bugserver == 4)
                        abort();

                     about = get_electron_from_type(pc->actor_type, pc->actor_id);

                     if (!about)
                     {
                         warning("tried to create Object %d, type %d at (%d, %d) of the lattice", pc->actor_id, pc->actor_type, pc->arg3, pc->arg4 );
                         severe("but could not create such an Object");
                     }
                     else
                     {

                        if (!about->extra_data)
                            about->extra_data = new Display_data(about);
                            
                        storage->lowlevel_add(about);
                        if (about->is_group(GROUP_ROOM))
                           renderer->cons_print(green,"#");
                     }
//                     warning("creating Object %d (%s) at (%d, %d)", about->actor_id, about->type_name, pc->arg3, pc->arg4);
                 }
                 else if (pc->arg3== -1 && pc->arg4== -1)
                 {
                     a = lattice->get(pc->arg1, pc->arg2);
                     if (!a)
                     {
                         warning("there is no atom at position (%d, %d) of the lattice", pc->arg1, pc->arg2 );
                         about = NULL;
                     }
                     else
                         about = a->find(pc->actor_type, pc->actor_id);

                     if (!about)
                     {
                         about = storage->find(pc->actor_type, pc->actor_id);
                         if (about)
                         {
                            warning("tried to remove Object %d, type %s from(%d, %d) of the lattice", pc->actor_id, about->type_name, pc->arg1, pc->arg2 );
                            severe("but I found it on (%d,%d)", about->gx(), about->gy());
                         }
                         else
                         {
                            warning("tried to remove Object %d, type %d from(%d, %d) of the lattice", pc->actor_id, pc->actor_type, pc->arg1, pc->arg2 );
                            severe("but I don't know that Object at all!");
                         }
                     }

                     if (about)
                     {
//                         warning("deleting Object %d (%s) from %d, %d",about->actor_id,about->type_name,pc->arg1, pc->arg2);
                         lattice->remove(about, pc->arg1, pc->arg2);
                         storage->lowlevel_remove(about);

                         if (about == me)
                         {
                           message("you have been removed from the map, so the connection will close");
                           me = dummy_player;
                         }
                     }
                 }
                 else
                 {
                     a = lattice->get(pc->arg1, pc->arg2);
                     if (!a)
                     {
                         warning("there is no atom at position (%d, %d) of the lattice", pc->arg1, pc->arg2 );
                         about = NULL;
                     }
                     else
                         about = a->find(pc->actor_type, pc->actor_id);
                         
                     if (!about)
                     {
                         about = storage->find(pc->actor_type, pc->actor_id);
                         if (!about)
                         {
                            warning("tried to move Object %d of type %d from location (%d,%d)",  pc->actor_id, pc->actor_type,pc->arg1, pc->arg2);
                            severe("but I don't know that Object at all!");
                         }
                         else
                         {
                            warning("tried to move Object %d of type %s from location (%d,%d)", pc->actor_id, about->type_name ,pc->arg1, pc->arg2);
                            severe("But I found that on (%d, %d)", about->gx(), about->gy());
                         }
                     }
                     else
                         lattice->remove(about, pc->arg1, pc->arg2);

//                     warning("moving Object %d (%s) from (%d, %d) to (%d, %d) t = %d", about->actor_id, about->type_name, pc->arg1, pc->arg2, pc->arg3, pc->arg4, pc->arg5);

                 }
                 if (about && (!(pc->arg3== -1 && pc->arg4== -1) ))
                     lattice->add(about, pc->arg3, pc->arg4);
                 else
                     collect_garbage = TRUE;

                 if (about)
                 {
                     add_to_dirtylist(about, pc);
                     if (about == toplevel_mover)
                     {
                         walk_frame = gtime + pc->arg5 - 10;
//                         warning("toplevel_mover moved setting wf to %d (gtime %d)", walk_frame, gtime);
                     }
                 }
                     
                 break;
                case COMMAND_TO:
                case COMMAND_TO_PLAYER:
                case COMMAND_DIR:
                 severe("Got illegal packet from the server, the client should never get COMMAND_TO/COMMAND_TO_PLAYER/COMMAND_DIR packets");
                 
                 break;
                case COMMAND_PICKUP:
                
                 about = storage->find(pc->actor_type, pc->actor_id);
                 #ifdef DEBUGMODE
//                 warning(" got command_pickup packet: %s (%d) should pickup (%d)",about->type_name,pc->actor_id, pc->larg2());
                 #endif
                 if (about)
                 {
                     do_pickup(pc);
                     add_to_dirtylist(about, pc);
                 }
                 else
                     severe("could not find Object %d of type %d",pc->actor_id, pc->actor_type);
                 break;
                case COMMAND_DROP:
                 about = storage->find(pc->actor_type, pc->actor_id);
                 #ifdef DEBUGMODE
//                 warning(" got command_drop packet: %s (%d) should drop (%d)",about->type_name,pc->actor_id, pc->larg2());
//                 print_packet(pc);
                 #endif
                 if (about)
                 {
                     do_drop(pc);
                     add_to_dirtylist(about, pc);
                 }
                 else
                     severe("could not find Object %d of type %d",pc->actor_id, pc->actor_type);
                 break;

                case COMMAND_TURN:
                 about = storage->find(pc->actor_type, pc->actor_id);
                 if (about)
                 {
                     add_to_dirtylist(about, pc);
                 }
                 else
                     severe("could not find Object %d of type %d",pc->actor_id, pc->actor_type);
                 break;

             }
            
             break;
            case TYPE_INFO_NUM:
            /* fall through intended */
            case TYPE_INFO_STRING:
            /* fall through intended */
            case TYPE_INFO_VECT:
             about = storage->find(p->actor_type, p->actor_id);
             if (about)
             {
                set_electron_var(about, p);
                add_to_dirtylist(about, NULL);
             }
             else
             {
                severe("received info packet about unkown Object (id = %d, type %d)",p->actor_id, p->actor_type);
                print_packet(p);
             }
             break;
            default:
             fatal("unkown packet in function incoming(), (type %d)",p->get_type());
        
        }
        
    }



//     message("done at %d", gtime);
    
}

static inline void outgoing()
{
    int ret = 0;
    
//    message(" outgoing %d", gtime);


    for (int i = 0; i < nr_commands_in_buffer;i++)
    {
//        warning("sending command %d", i);
        switch(commbuf[i].command)
        {

            case C_MOVEPLAYER:
//warning("  sending dir %d", commbuf[i].arg);
//                         the_console->printf(makecol(0,0,255), "sending MOVE... %d ", gtime);
             ret = Packet_command::write_to(the_connection, me->actor_type, me->actor_id, COMMAND_DIR, commbuf[i].a);
//                         the_console->printf(makecol(0,0,255), " done %d\n", gtime);
             
             break;
            case C_TURNPLAYER:
             ret = Packet_command::write_to(the_connection, me->actor_type, me->actor_id, COMMAND_TURN, commbuf[i].a);
             break;
            case C_ENTER:
             ret = Packet_command::write_to_ssl(the_connection, me->actor_type, me->actor_id, COMMAND_ENTER, commbuf[i].actor_type,0, commbuf[i].actor_id);
             break;
            case C_EXIT:
             ret = Packet_command::write_to(the_connection, me->actor_type, me->actor_id, COMMAND_EXIT);
             break;
            case C_PICKUP:
             ret = Packet_command::write_to_ssl(the_connection, me->actor_type, me->actor_id, COMMAND_PICKUP, commbuf[i].actor_type,0, commbuf[i].actor_id);
             break;
            case C_PUT:
             ret = Packet_command::write_to_ssl(the_connection,commbuf[i].actor_type, commbuf[i].actor_id, COMMAND_PICKUP, commbuf[i].var_id,0, commbuf[i].x);
             break;
            case C_DROP:
             ret = Packet_command::write_to_ssl(the_connection, me->actor_type, me->actor_id, COMMAND_DROP, commbuf[i].actor_type,0, commbuf[i].actor_id);
             break;
            case C_NUMPACK:
             ret = Packet_info_num::write_to(the_connection, commbuf[i].actor_type, commbuf[i].actor_id, commbuf[i].var_id, commbuf[i].a);
             break;
            case C_VECTPACK:
             ret = Packet_info_vect::write_to(the_connection, commbuf[i].actor_type, commbuf[i].actor_id, commbuf[i].var_id, commbuf[i].x, commbuf[i].y);
             break;
            case C_STRINGPACK:
             ret = Packet_info_string::write_to(the_connection, commbuf[i].actor_type, commbuf[i].actor_id, commbuf[i].var_id, commbuf[i].string);
             free(commbuf[i].string);
             break;
            case C_COMMANDPACK:

             if (commbuf[i].bugserver)
             {
                Packet_command p(commbuf[i].actor_type, commbuf[i].actor_id,commbuf[i].c,commbuf[i].a1,commbuf[i].a2,commbuf[i].a3,commbuf[i].a4,commbuf[i].a5);
                p.freelist_index = -1;
                p.write_to_bogus(the_connection, 0);
             }
             else
             {
                ret = Packet_command::write_to(the_connection,commbuf[i].actor_type, commbuf[i].actor_id,commbuf[i].c,commbuf[i].a1,commbuf[i].a2,commbuf[i].a3,commbuf[i].a4,commbuf[i].a5);
             }
             break;
            default:
             severe("command %d not yet implemented in outgoing()", commbuf[i].command);
             break;
        }
        if (ret < 0)
        {
           severe("It seems the connection to the server was lost");
           connection_valid = FALSE;
           playing = FALSE;
           break;
        }
    }

    if (commbuf == commbuf1)
        commbuf = commbuf2;
    else
        commbuf = commbuf1;
    
    nr_commands_in_buffer_last_time = nr_commands_in_buffer;
    nr_commands_in_buffer = 0;
//    message(" outgoing DONE %d", gtime);


    if (bouncepacket)
    {
        Packet_info_num::write_to(the_connection, 0, SYS_MESSAGE, System::BOUNCE_NEXT_PACKET,0);
        bouncepacket->write_to(the_connection);
        delete_object(bouncepacket);
        bouncepacket = NULL;
    }
}


void handle_comms()
{
//    warning(">>>incoming %d", gtime);
    incoming();
//    warning(">>>out-------- %d", gtime);
    if (connection_valid)
        outgoing();
//    warning(">>>done %d", gtime);
}



void shutdown_connection()
{

    renderer->stop();

    if (connection_valid)
        Packet_info_num::write_to(the_connection, ACTOR_SYSTEM, SYS_MESSAGE, System::HANGUP, 0);

 //   rest(100);

    the_connection->close();
    
    connection_valid = FALSE;
    
    delete the_connection;

    me = dummy_player;
}
