/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include "client.h"
#include "clutils.h"
#include "cmdline.h"

int nochoose = FALSE;


static int isnumber(char *s)
{

    while(*s)
    {
//        fprintf(stderr," %d isdigit:%d\n",*s, isdigit(*s));
        if (!isdigit(*s))
           return FALSE;
        s++;
    }
    return TRUE;
}


static int scan_num(int argc, char **argv, char *s, int *value)
{
    for (int i=0;i< argc; i++)
    {
        if (!strcmp(argv[i], s))
        {
            if (i == argc - 1 || !isnumber(argv[i + 1]))
                fatal("The option %s expects a numeric argument\n", s);

            *value = atoi(argv[i+1]);

            return TRUE;
        }
    }
    return FALSE;
}

static int scan_bool(int argc, char **argv,char *s)
{
   for (int i=0;i< argc; i++)
    {
        if (!strcmp(argv[i], s))
        {
            return TRUE;
        }
    }
    return FALSE;
}

static int scan_string(int argc, char **argv, char *s, char **value)
{
   for (int i=0;i< argc; i++)
    {
        if (!strcmp(argv[i], s))
        {
            if (i >= argc - 1)
                fatal("The option %s expects a string argument\n", s);

            *value = argv[i+1];

            return TRUE;
        }
    }
    return FALSE;
}


#define SCAN_NUM(string, var)    if (scan_num(argc, argv,string, &var))\
                                     nrmatched +=2;
static int nrmatched = 0;


static void parse_client_specific(int argc, char **argv)
{
    char *s = NULL;
    
    if (scan_bool(argc, argv, "-h") || scan_bool(argc, argv, "--help"))
    {

      allegro_message("Usage:\n%s [options]\n"
          "Options are:\n"
          "-h or --help       Display this help.\n"
          "-s <servername>    Set server name(default 'localhost').\n"
          "-st                Start server and connect to it immediately, only works for\n"
          "                   a local server.\n"
          "-p <port>          Set port to connect to (default 5000).\n"
          "-bpp <bitdepth>    Graphical colordepth (8, 15, 16, 24 or 32).\n"
          "-r <resolution>    Resolution (320,640,800,1024).\n"
          "-rs <playfield>    Resolution of playfield, will be stretched to fill the\n"
          "                   screen, passing 0 turns off stretching.\n"
          "-gfx <gfxmode>     Where <gfxmode> is one of win, fs or default.\n"
          "                   default picks whatever allegro.cfg gives it, win\n"
          "                   and fs try to get a windowed or full screen mode.\n"
          "-ct <num>          Console transparancy, 0 is opaque (fastest), 255 is fully\n"
          "                   clear (also quite fast), everything inbetween is partially\n"
          "                   translucent (slow).\n"
          "-spb on/off        Speed blur on or off. This only works when the console is\n"
          "                   partially transparant, the amount of blur depends on the\n"
          "                   transparancy: low transparancy gives less blur.\n"
          "-l <method>        Use lighting  method: 0-none 1-vertex .\n"
          "-dg <datafile>     Use alternative gfx datafile.\n"
          "-ds <datafile>     Use alternative sound datafile.\n"
          "-nl <nausea_level> Controls the camera motion, a higher level\n"
          "                   gives more motion sickness ;-)\n"
          "-filter <method>   Filtering method: 0-none 1-pre-blurred textures\n"
          "-bugserver <int>   hangup at various points during login, send incomplete packages\n"
          "                   and be generally annoying to the server, see doc/bugserver.txt\n"
          "-perspective <int> perspective factor, larger is 'flatter', range 1-8\n"
          , argv[0]);

       exit(1);
    }

    if (scan_num(argc, argv, "-p", &port))
    {
       nochoose = TRUE;
       nrmatched+=2;
    }


    if (scan_num(argc, argv, "-bugserver", &bugserver))
    {
       nrmatched+=2;
    }

    if (scan_num(argc, argv, "-perspective", &perspective_fact))
    {
       nrmatched+=2;
    }



    if ((cmdline_startserver = scan_bool(argc, argv, "-st")))
    {
       nochoose = TRUE;
       nrmatched+=1;
    }

    if (scan_string(argc, argv, "-s", &s))
    {
       nochoose = TRUE;
       nrmatched+=2;
    }

    if (s)
    {
        sstrncpy(servername, s, SERVERNAME_LEN);
    }
    else
        sstrncpy(servername, "localhost", SERVERNAME_LEN);


}

static void parse_mapeditor_specific(int argc, char **argv)
{
    if (scan_bool(argc, argv, "-h") || scan_bool(argc, argv, "--help"))
    {

      allegro_message("Usage:\n%s [options]\n"
          "Options are:\n"
          "-h or --help       Display this help.\n"
          "-bpp <bitdepth>    Graphical colordepth (8, 15, 16, 24 or 32).\n"
          "-r <resolution>    Resolution (320,640,800,1024).\n"
          "-rs <playfield>    Resolution of playfield, will be stretched to fill the\n"
          "                   screen, passing 0 turns off stretching.\n"
          "-gfx <gfxmode>     Where <gfxmode> is one of win, fs or default.\n"
          "                   default picks whatever allegro.cfg gives it, win\n"
          "                   and fs try to get a windowed or full screen mode.\n"
          "-ct <num>          Console transparancy, 0 is opaque (fastest), 255 is fully\n"
          "                   clear (also quite fast), everything inbetween is partially\n"
          "                   translucent (slow).\n"
          "-spb on/off        Speed blur on or off. This only works when the console is\n"
          "                   partially transparant, the amount of blur depends on the\n"
          "                   transparancy: low transparancy gives less blur.\n"
          "-l <method>        Use lighting  method: 0-none 1-vertex .\n"
          "-dg <datafile>     Use alternative gfx datafile.\n"
          "-ds <datafile>     Use alternative sound datafile.\n"
          "-nl <nausea_level> Controls the camera motion, a higher level\n"
          "                   gives more motion sickness ;-)\n"
          "-filter <method>   Filtering method: 0-none 1-pre-blurred textures\n"
          "-m <mapfile>         Load map <mapfile> \n"
          , argv[0]);

       exit(1);
    }

    if (scan_string(argc, argv, "-m", &mapeditor_mapname))
    {
       nochoose = TRUE;
       nrmatched+=2;
    }

    
}

void parse_cmdline(int argc, char **argv, int mapeditor)
{
    char *s = NULL;


    nrmatched = 0;
    
    if (mapeditor)
    {
         parse_mapeditor_specific(argc, argv);
    }
    else
    {
         parse_client_specific(argc, argv);
    }
    

    SCAN_NUM("-filter", filtering);
    SCAN_NUM("-bpp", colordepth);
    SCAN_NUM("-l", lighting_method);
    SCAN_NUM("-r", gfx_w);
    SCAN_NUM("-nl", nausea_level);



    gfx_h = gfx_w * 3 / 4;

    SCAN_NUM("-rs", gfx_s_w);


    SCAN_NUM("-ct", console_transparancy);


    if (scan_string(argc, argv, "-dg", &cmd_gfxdata_name))
    {
       nochoose = TRUE;
       nrmatched+=2;
    }

    if (scan_string(argc, argv, "-ds", &cmd_snddata_name))
    {
       nochoose = TRUE;
       nrmatched+=2;
    }
    
    if (colordepth != 8 && colordepth != 15 && colordepth != 16 && colordepth != 24 && colordepth != 32)
       fatal(" illegal colordepth %d\n", colordepth);

    if (scan_string(argc, argv, "-spb", &s))
    {
       speedblur = !(strcmp(s, "on"));
       nrmatched+=2;
    }

    if (scan_string(argc, argv, "-gfx", &s))
    {
        if (!strcmp(s, "win"))
           gfx_card = GFX_AUTODETECT_WINDOWED;
        else if (!strcmp(s, "fs"))
           gfx_card = GFX_AUTODETECT_FULLSCREEN;
        else
           gfx_card = GFX_AUTODETECT;
        
       nrmatched+=2;
    }

    if (nrmatched < argc - 1)
       fatal("there were unrecognised options, try -h for help\n");

}
