#include <allegro.h>
#include "clutils.h"
#include "client.h"
#include "commbuf.h"

Electron *find_vehicle()
{
    int x = me->gx();
    int y = me->gy();

    Atom *a = lattice->get(x, y);
    ASSERT(a);



    return (Electron *)((a->get(LIST_VEHICLE))->get_head());
}


char *prompt()
{
   static char prompt_buffer[100];
   if (me && me->gx() >= 0)
   {
      ssprintf(prompt_buffer, 100, "[%d, %d] %g%% >",me->gx(),me->gy(), me->get_h() / 10.0);
      return prompt_buffer;
   }
   
   return default_prompt;
}

int find_place_in_list(List *l, Object const *other)
{
   Object *o;

   int count = 0;


   for (l->reset(); (o = l->get());l->next())
   {
      if (o == other)
          return count;

      count++;
   }

   return -1;

}


Object *get_from_list_idx(List *l, int idx)
{
   if (idx < 0 || idx >= l->size())
       return NULL;

   l->reset();

   for (int i=0;i<idx;i++)
       l->next();

       
   return l->get();
}



//hook to stick debugging things,
void debuggingcommand(int cmd)
{

    switch(cmd)
    {
        case 1:
            bouncepacket = new_packet_info_num(0 , SYS_MESSAGE, System::INVALID_PACKET, 0);


         break;
        default:
         message
         (
            "unknown debug cmd: %d\n"
            "debug 1  - ask the server to echo anINVALID_PACKET message back to us\n",
            cmd
         );
         break;
    }
}

void shoot_at_player_if_there_else_location(int x, int y)
{

    Atom *a = lattice->get(x, y);
    Electron *p = NULL;
    
    if (a)
        p =  (Electron *)((a->get(LIST_PLAYER))->get_head());

    if (p)
        cbuf_add_generic_commandpacket(COMMAND_FIRE_AT,-1, -1,p->actor_type, p->actor_id);
    else
        cbuf_add_generic_commandpacket(COMMAND_FIRE_TO,-1,-1, x, y);

}

